/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.recovery;

import aroma1997.backup.BackupInformation;
import aroma1997.backup.recovery.EventListener;
import aroma1997.backup.recovery.GuiRestoreWorld;
import aroma1997.backup.recovery.RestoreChunkInfo;
import aroma1997.core.client.util.Colors;
import aroma1997.core.coremod.CoreMod;
import aroma1997.core.log.LogHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import org.apache.http.ParseException;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiRestoreChunk
extends GuiScreen {
    private int x;
    private int z;
    private int dim;
    private GuiRestoreWorld parent;
    private BackupInformation binfo;
    private boolean clicked;
    private String draw = "";

    public GuiRestoreChunk(GuiRestoreWorld parent, BackupInformation binfo) {
        this.parent = parent;
        this.binfo = binfo;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        for (int i = 0; i < 6; ++i) {
            int x = i % 3;
            int y = i / 3;
            this.field_146292_n.add(new GuiButton(i, this.field_146294_l / 2 + x * 40 - 40, this.field_146295_m / 2 + 40 * y - 50, 20, 20, y == 0 ? "+" : "-"));
        }
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"aromabackuprecovery:restorechunk.confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(8, this.field_146294_l / 2 + 70, this.field_146295_m / 2 - 30, 130, 20, StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.loadCrashlog")));
        this.dim = 0;
        this.z = 0;
        this.x = 0;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            ChunkCoordinates coords;
            if (button.field_146127_k < 6) {
                int diff = button.field_146127_k / 3 == 1 ? -1 : 1;
                switch (button.field_146127_k % 3) {
                    case 0: {
                        this.x += diff;
                        break;
                    }
                    case 1: {
                        this.z += diff;
                        break;
                    }
                    case 2: {
                        this.dim += diff;
                    }
                }
            }
            if (button.field_146127_k == 6) {
                EventListener.coords.put(this.dim, new RestoreChunkInfo(this.x, this.z, this.binfo));
                this.startWorld();
            } else if (button.field_146127_k == 7) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
            } else if (button.field_146127_k == 8 && (coords = this.getRestorePosFromCrashlog(this.binfo.world)) != null) {
                this.x = coords.field_71574_a;
                this.z = coords.field_71573_c;
                this.dim = coords.field_71572_b;
            }
        }
    }

    private void startWorld() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
        if (!this.clicked) {
            this.clicked = true;
            if (this.field_146297_k.func_71359_d().func_90033_f(this.binfo.world)) {
                FMLClientHandler.instance().tryLoadExistingWorld(this.parent.parent, this.binfo.world, this.binfo.world);
            }
        }
    }

    private boolean isStringOK(String str) {
        if (str.charAt(str.length() - 1) == '\b') {
            return true;
        }
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"aromabackuprecovery:restorechunk.title", (Object[])new Object[0]), this.field_146294_l / 2, 20, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"aromabackuprecovery:restorechunk.chunkX", (Object[])new Object[0]), this.field_146294_l / 2 - 30, this.field_146295_m / 2 - 70, -1);
        this.func_73732_a(this.field_146289_q, this.x + "", this.field_146294_l / 2 - 30, this.field_146295_m / 2 - 25, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"aromabackuprecovery:restorechunk.chunkZ", (Object[])new Object[0]), this.field_146294_l / 2 + 10, this.field_146295_m / 2 - 70, -1);
        this.func_73732_a(this.field_146289_q, this.z + "", this.field_146294_l / 2 + 10, this.field_146295_m / 2 - 25, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"aromabackuprecovery:restorechunk.dim", (Object[])new Object[0]), this.field_146294_l / 2 + 50, this.field_146295_m / 2 - 70, -1);
        this.func_73732_a(this.field_146289_q, this.dim + "", this.field_146294_l / 2 + 50, this.field_146295_m / 2 - 25, -1);
        this.func_73731_b(this.field_146289_q, StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.info.1"), 30, 150, -1);
        this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.info.2"), 30, 170, 350, -1);
        this.field_146289_q.func_78279_b(this.draw, 20, 70, 140, -1);
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    private ChunkCoordinates getRestorePosFromCrashlog(String worldName) {
        File crashlogFolder = new File(CoreMod.mcLocation, "crash-reports");
        if (!crashlogFolder.exists() || !crashlogFolder.isDirectory()) {
            return null;
        }
        HashMap<FileTime, ChunkCoordinates> files = new HashMap<FileTime, ChunkCoordinates>();
        for (File file : crashlogFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
            FileTime date = null;
            try {
                date = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                date = FileTime.fromMillis(System.currentTimeMillis());
            }
            boolean pos = false;
            boolean dim = false;
            ChunkCoordinates coords = new ChunkCoordinates();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while (reader.ready()) {
                    String line = reader.readLine().trim();
                    if (line.startsWith("Level dimension:")) {
                        coords.field_71572_b = Integer.parseInt(line.substring("Level dimension: ".length()));
                        dim = true;
                        continue;
                    }
                    if (line.startsWith("Block location:")) {
                        String str = line.substring(line.indexOf("Chunk: (at") + "Chunk: (at ".length(), line.indexOf("; contains blocks "));
                        String[] split = (str = str.substring(str.indexOf(" in ") + " in ".length())).split(",");
                        if (split.length != 2) {
                            throw new ParseException("Something went wrong during parsing of Chunk Coords");
                        }
                        coords.field_71574_a = Integer.parseInt(split[0]);
                        coords.field_71573_c = Integer.parseInt(split[1]);
                        pos = true;
                        continue;
                    }
                    if (line.startsWith("Level name:") && this.binfo.world.equals(line.substring("Level name: ".length()))) continue;
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                LogHelper.logException((String)("Failed to load crashlog: " + file.getName()), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LogHelper.logException((String)("Failed to load crashlog: " + file.getName()), (Throwable)e);
                continue;
            }
            if (!pos || !dim) continue;
            files.put(date, coords);
        }
        if (files.size() == 0) {
            this.draw = Colors.RED + StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.crashlog.none");
            return null;
        }
        FileTime key = null;
        if (files.size() == 1) {
            for (Map.Entry entry : files.entrySet()) {
                key = (FileTime)entry.getKey();
            }
        } else {
            ArrayList list = new ArrayList();
            list.addAll(files.keySet());
            Collections.sort(list);
            key = (FileTime)list.get(0);
        }
        if (key == null) {
            this.draw = Colors.RED + StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.crashlog.none");
            return null;
        }
        this.draw = key.toMillis() < System.currentTimeMillis() - 86400000L ? Colors.RED + StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.crashlog.outdated") : StatCollector.func_74838_a((String)"aromabackuprecovery:restorechunk.crashlog.success");
        return (ChunkCoordinates)files.get(key);
    }
}

