/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import fiskfille.lightsabers.LightsaberAPI;
import fiskfille.lightsabers.client.gui.GuiLightsaberForge;
import fiskfille.lightsabers.common.block.ModBlocks;
import fiskfille.lightsabers.common.helper.ALRenderHelper;
import fiskfille.lightsabers.common.helper.LightsaberColors;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import fiskfille.lightsabers.common.item.ItemLightsaberPart;
import fiskfille.lightsabers.common.item.ModItems;
import fiskfille.lightsabers.common.lightsaber.Lightsaber;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class LightsaberForgeRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiLightsaberForge.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.lightsaber_forge");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() == ModItems.lightsaber) {
            Object[] aobject = new Object[8];
            Lightsaber.EnumPartType[] types = new Lightsaber.EnumPartType[]{Lightsaber.EnumPartType.EMITTER, Lightsaber.EnumPartType.SWITCH_SECTION, Lightsaber.EnumPartType.BODY, Lightsaber.EnumPartType.POMMEL};
            for (int i = 0; i < types.length; ++i) {
                Lightsaber.EnumPartType type = types[i];
                aobject[i] = LightsaberHelper.createLightsaberPart(LightsaberHelper.getPart(result, type), type);
            }
            aobject[4] = new ItemStack(ModItems.lightsaberCircuitry);
            aobject[5] = LightsaberHelper.createCrystal(LightsaberHelper.getColorId(result));
            int[] aint = LightsaberHelper.getFocusingCrystalIds(result);
            for (int i = 0; i < aint.length; ++i) {
                int id = aint[i];
                aobject[i + 6] = LightsaberHelper.createFocusingCrystal(id);
            }
            CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(result, aobject);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block9: {
            Item item;
            ItemStack itemstack;
            block11: {
                block10: {
                    block8: {
                        itemstack = ingredient.func_77946_l();
                        itemstack.field_77994_a = 1;
                        item = ingredient.func_77973_b();
                        if (!(item instanceof ItemLightsaberPart)) break block8;
                        Lightsaber.EnumPartType type = LightsaberHelper.getPartType(ingredient);
                        Lightsaber.EnumPartType[] types = new Lightsaber.EnumPartType[]{Lightsaber.EnumPartType.EMITTER, Lightsaber.EnumPartType.SWITCH_SECTION, Lightsaber.EnumPartType.BODY, Lightsaber.EnumPartType.POMMEL};
                        for (int i = 0; i < LightsaberColors.getColors().length; ++i) {
                            Object[] aobject = new Object[8];
                            for (int j = 0; j < types.length; ++j) {
                                Lightsaber.EnumPartType type1 = types[j];
                                aobject[j] = LightsaberHelper.createLightsaberPart(LightsaberHelper.getLightsaberFromPart(ingredient), type1);
                            }
                            aobject[4] = new ItemStack(ModItems.lightsaberCircuitry);
                            aobject[5] = LightsaberHelper.createCrystal(i);
                            CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(LightsaberHelper.createLightsaber(i, LightsaberHelper.getLightsaberFromPart(ingredient), null), aobject);
                            recipe.computeVisuals();
                            this.arecipes.add(recipe);
                        }
                        break block9;
                    }
                    if (item != Item.func_150898_a((Block)ModBlocks.lightsaberCrystal)) break block10;
                    for (Lightsaber lightsaber : LightsaberAPI.getLightsabers()) {
                        Object[] aobject = new Object[8];
                        Lightsaber.EnumPartType[] types = new Lightsaber.EnumPartType[]{Lightsaber.EnumPartType.EMITTER, Lightsaber.EnumPartType.SWITCH_SECTION, Lightsaber.EnumPartType.BODY, Lightsaber.EnumPartType.POMMEL};
                        for (int i = 0; i < types.length; ++i) {
                            Lightsaber.EnumPartType type1 = types[i];
                            aobject[i] = LightsaberHelper.createLightsaberPart(lightsaber, type1);
                        }
                        aobject[4] = new ItemStack(ModItems.lightsaberCircuitry);
                        aobject[5] = itemstack;
                        CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(LightsaberHelper.createLightsaber(LightsaberHelper.getCrystalColorId(ingredient), lightsaber, null), aobject);
                        recipe.computeVisuals();
                        this.arecipes.add(recipe);
                    }
                    break block9;
                }
                if (item != ModItems.focusingCrystal) break block11;
                for (Lightsaber lightsaber : LightsaberAPI.getLightsabers()) {
                    Object[] aobject = new Object[8];
                    Lightsaber.EnumPartType[] types = new Lightsaber.EnumPartType[]{Lightsaber.EnumPartType.EMITTER, Lightsaber.EnumPartType.SWITCH_SECTION, Lightsaber.EnumPartType.BODY, Lightsaber.EnumPartType.POMMEL};
                    for (int i = 0; i < types.length; ++i) {
                        Lightsaber.EnumPartType type1 = types[i];
                        aobject[i] = LightsaberHelper.createLightsaberPart(lightsaber, type1);
                    }
                    aobject[4] = new ItemStack(ModItems.lightsaberCircuitry);
                    aobject[5] = LightsaberHelper.createCrystal(0);
                    aobject[6] = itemstack;
                    CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(LightsaberHelper.createLightsaber(LightsaberHelper.getCrystalColorId(ingredient), lightsaber, LightsaberHelper.getFocusingCrystalId(ingredient)), aobject);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
                break block9;
            }
            if (item != ModItems.lightsaberCircuitry) break block9;
            for (Lightsaber lightsaber : LightsaberAPI.getLightsabers()) {
                Object[] aobject = new Object[8];
                Lightsaber.EnumPartType[] types = new Lightsaber.EnumPartType[]{Lightsaber.EnumPartType.EMITTER, Lightsaber.EnumPartType.SWITCH_SECTION, Lightsaber.EnumPartType.BODY, Lightsaber.EnumPartType.POMMEL};
                for (int i = 0; i < types.length; ++i) {
                    Lightsaber.EnumPartType type1 = types[i];
                    aobject[i] = LightsaberHelper.createLightsaberPart(lightsaber, type1);
                }
                aobject[4] = itemstack;
                aobject[5] = LightsaberHelper.createCrystal(0);
                CachedLightsaberForgeRecipe recipe = new CachedLightsaberForgeRecipe(LightsaberHelper.createLightsaber(LightsaberHelper.getCrystalColorId(ingredient), lightsaber, new int[0]), aobject);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        }
    }

    public String getGuiTexture() {
        return "lightsabers:textures/gui/container/lightsaber_forge.png";
    }

    public String getOverlayIdentifier() {
        return "lightsaber_forge";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)102);
        Minecraft mc = Minecraft.func_71410_x();
        int k = -5;
        int l = -11;
        int guiLeft = (mc.field_71462_r.field_146294_l - 176) / 2;
        int guiTop = (mc.field_71462_r.field_146295_m - 166) / 2;
        CachedLightsaberForgeRecipe recipe1 = this.getForgeRecipes(null).get(recipe);
        ItemStack itemstack = recipe1.result.item;
        if (itemstack != null) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_77978_p().func_74757_a("active", true);
            float spin = mc.field_71439_g.field_70173_aa;
            int short1 = 240;
            int short2 = 240;
            GL11.glEnable((int)32826);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            ALRenderHelper.startGlScissor(guiLeft + 43, guiTop + 22, 113, 47);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)(k + 110), (float)(l + 40), (float)50.0f);
            GL11.glRotatef((float)((float)Math.sin(spin / 20.0f) * 2.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.sin(spin / 20.0f + 2.0f) * 2.5f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(90.0f + spin), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74520_c();
            float height = LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.EMITTER).getEmitter().height + LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.SWITCH_SECTION).getSwitchSection().height + LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.BODY).getBody().height + LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.POMMEL).getPommel().height;
            float f = (-(LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.BODY).getBody().height + LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.POMMEL).getPommel().height) + height / 2.0f) * 0.0625f;
            float scale = 50.0f;
            GL11.glScalef((float)(-scale), (float)scale, (float)scale);
            GL11.glPushMatrix();
            scale = 0.45f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            ALRenderHelper.renderLightsaberHilt(itemstack);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            scale = 0.45f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            scale = 1.3499999f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)(-(LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.SWITCH_SECTION).getSwitchSection().height + LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.EMITTER).getEmitter().height) * 0.03125f * 0.75f), (float)0.0f);
            ALRenderHelper.renderLightsaberBlade(itemstack, false);
            GL11.glPopMatrix();
            ALRenderHelper.endGlScissor();
            GL11.glPopMatrix();
            RenderHelper.func_74518_a();
        }
    }

    public List<CachedLightsaberForgeRecipe> getForgeRecipes(LightsaberForgeRecipeHandler handler) {
        ArrayList list = Lists.newArrayList();
        for (TemplateRecipeHandler.CachedRecipe recipe : handler == null ? this.arecipes : handler.arecipes) {
            list.add((CachedLightsaberForgeRecipe)recipe);
        }
        return list;
    }

    public class CachedLightsaberForgeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedLightsaberForgeRecipe(ItemStack out, Object[] items) {
            super((TemplateRecipeHandler)LightsaberForgeRecipeHandler.this);
            this.result = new PositionedStack((Object)out, 131, 76);
            this.ingredients = new ArrayList();
            this.setIngredients(items);
        }

        public void setIngredients(Object[] items) {
            this.addSlotToContainer(0, 20, 17, items);
            this.addSlotToContainer(1, 20, 35, items);
            this.addSlotToContainer(2, 20, 53, items);
            this.addSlotToContainer(3, 20, 71, items);
            this.addSlotToContainer(4, 43, 71, items);
            this.addSlotToContainer(5, 66, 71, items);
            this.addSlotToContainer(6, 89, 71, items);
            this.addSlotToContainer(7, 107, 71, items);
        }

        private void addSlotToContainer(int id, int x, int y, Object[] items) {
            if (items[id] != null) {
                PositionedStack stack = new PositionedStack(items[id], x - 5, y - 11, false);
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(LightsaberForgeRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

