/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.lightsabers.common.entity.EntityLightsaber;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class ItemLightsaberBase
extends ItemSword {
    @SideOnly(value=Side.CLIENT)
    public static IIcon crystalEmptySlotIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon focusingCrystalEmptySlotIcon;

    public ItemLightsaberBase() {
        super(Item.ToolMaterial.EMERALD);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public double getAttackDamage() {
        return 8.0;
    }

    public Entity getThrownLightsaberEntity(World world, EntityLivingBase entity, ItemStack itemstack) {
        return new EntityLightsaber(world, entity, itemstack);
    }

    public static void refreshNBT(ItemStack itemstack) {
        if (itemstack != null && !itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
    }

    public static boolean isActive(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        ItemLightsaberBase.refreshNBT(itemstack);
        return itemstack.func_77978_p().func_74767_n("active");
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack itemstack) {
        if (ItemLightsaberBase.isActive(itemstack)) {
            MovingObjectPosition mop = this.getMovingObjectPosition(entity.field_70170_p, entity, true);
            if (mop != null) {
                MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
                if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                } else {
                    return this.onPunchBlock(itemstack, entity, mop);
                }
            }
            entity.func_85030_a("lightsabers:lightsaber_swing", 1.0f, 1.0f);
            if (entity.func_70093_af()) {
                this.throwLightsaber(entity, itemstack);
            }
        }
        return super.onEntitySwing(entity, itemstack);
    }

    public void throwLightsaber(EntityLivingBase entity, ItemStack itemstack) {
        Entity lightsaber = this.getThrownLightsaberEntity(entity.field_70170_p, entity, itemstack);
        entity.field_70170_p.func_72838_d(lightsaber);
        entity.func_70062_b(0, null);
    }

    private MovingObjectPosition getMovingObjectPosition(World world, EntityLivingBase entity, boolean b) {
        if (entity instanceof EntityPlayer) {
            double reach = 5.0;
            if (entity instanceof EntityPlayerMP) {
                reach = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
            }
            MovingObjectPosition mop = this.func_77621_a(world, (EntityPlayer)entity, b);
            Vec3 position = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
            Vec3 look = entity.func_70676_i(0.0f);
            Vec3 lookPosition = position.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
            float expand = 1.0f;
            List possibleEntities = world.func_72839_b((Entity)entity, entity.field_70121_D.func_72321_a(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach).func_72314_b((double)expand, (double)expand, (double)expand));
            double closestDistance = reach;
            for (Object possibleEntity : possibleEntities) {
                double distanceToEntity;
                Entity selectingEntity = (Entity)possibleEntity;
                if (!selectingEntity.func_70067_L()) continue;
                float borderSize = selectingEntity.func_70111_Y();
                AxisAlignedBB selectionBounds = selectingEntity.field_70121_D.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
                MovingObjectPosition entityMOP = selectionBounds.func_72327_a(position, lookPosition);
                if (entityMOP != null) {
                    entityMOP.field_72313_a = MovingObjectPosition.MovingObjectType.ENTITY;
                }
                if (selectionBounds.func_72318_a(position)) {
                    if (!(closestDistance > 0.0) && closestDistance != 0.0) continue;
                    mop = entityMOP;
                    closestDistance = 0.0;
                    continue;
                }
                if (entityMOP == null || !((distanceToEntity = position.func_72438_d(entityMOP.field_72307_f)) < closestDistance) && closestDistance != 0.0) continue;
                if (selectingEntity == selectingEntity.field_70154_o && !selectingEntity.canRiderInteract()) {
                    if (closestDistance != 0.0) continue;
                    mop = entityMOP;
                    continue;
                }
                mop = entityMOP;
                closestDistance = distanceToEntity;
            }
            return mop;
        }
        return null;
    }

    public boolean onPunchBlock(ItemStack stack, EntityLivingBase entity, MovingObjectPosition mop) {
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        LightsaberHelper.igniteLightsaber((EntityLivingBase)player, !ItemLightsaberBase.isActive(itemstack));
        return itemstack;
    }

    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer player, Entity entity) {
        return !ItemLightsaberBase.isActive(itemstack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getAttackDamage(), 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IIconRegister) {
        crystalEmptySlotIcon = par1IIconRegister.func_94245_a("lightsabers:lightsaber_crystal_outline");
        focusingCrystalEmptySlotIcon = par1IIconRegister.func_94245_a("lightsabers:focusing_crystal_outline");
    }
}

