/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.helper;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fiskfille.lightsabers.LightsaberAPI;
import fiskfille.lightsabers.common.block.ModBlocks;
import fiskfille.lightsabers.common.container.InventoryLightsaberForge;
import fiskfille.lightsabers.common.helper.FocusingCrystals;
import fiskfille.lightsabers.common.helper.LightsaberColors;
import fiskfille.lightsabers.common.item.ItemLightsaberBase;
import fiskfille.lightsabers.common.item.ModItems;
import fiskfille.lightsabers.common.lightsaber.Lightsaber;
import fiskfille.lightsabers.common.lightsaber.LightsaberManager;
import fiskfille.lightsabers.common.network.ALNetworkManager;
import fiskfille.lightsabers.common.network.PacketIgniteLightsaber;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LightsaberHelper {
    public static int getColorId(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        NBTTagCompound nbttagcompound = itemstack.func_77978_p().func_74775_l("Lightsaber");
        return nbttagcompound == null ? 0 : (nbttagcompound.func_74764_b("color") ? nbttagcompound.func_74762_e("color") : 0);
    }

    public static int[] getFocusingCrystalIds(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        NBTTagCompound nbttagcompound = itemstack.func_77978_p().func_74775_l("Lightsaber");
        return nbttagcompound == null ? new int[]{} : (nbttagcompound.func_74764_b("FocusingCrystals") ? nbttagcompound.func_74759_k("FocusingCrystals") : new int[]{});
    }

    public static String getPartString(ItemStack itemstack, Lightsaber.EnumPartType type) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        String s = type.name().toLowerCase();
        if (nbttagcompound == null) {
            return LightsaberManager.lightsaberGraflex.getName();
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Lightsaber");
        return nbttagcompound1 == null ? LightsaberManager.lightsaberGraflex.getName() : (nbttagcompound1.func_74764_b(s) ? nbttagcompound1.func_74779_i(s) : LightsaberManager.lightsaberGraflex.getName());
    }

    public static Lightsaber getPart(ItemStack itemstack, Lightsaber.EnumPartType type) {
        Lightsaber lightsaber = LightsaberAPI.getLightsaberByName(LightsaberHelper.getPartString(itemstack, type));
        if (lightsaber == null) {
            lightsaber = LightsaberManager.lightsaberGraflex;
        }
        return lightsaber;
    }

    public static Lightsaber.EnumPartType getPartType(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        return Lightsaber.EnumPartType.valueOf(itemstack.func_77978_p().func_74779_i("type").toUpperCase());
    }

    public static ItemStack createLightsaber(int colorId, Lightsaber emitter, Lightsaber switchSection, Lightsaber body, Lightsaber pommel, int ... focusingCrystalIds) {
        ItemStack itemstack = new ItemStack(ModItems.lightsaber);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74768_a("color", colorId);
        nbttagcompound1.func_74778_a("emitter", emitter.getName());
        nbttagcompound1.func_74778_a("switch_section", switchSection.getName());
        nbttagcompound1.func_74778_a("body", body.getName());
        nbttagcompound1.func_74778_a("pommel", pommel.getName());
        if (focusingCrystalIds != null && focusingCrystalIds.length > 0) {
            nbttagcompound1.func_74783_a("FocusingCrystals", focusingCrystalIds);
        }
        nbttagcompound.func_74782_a("Lightsaber", (NBTBase)nbttagcompound1);
        itemstack.func_77982_d(nbttagcompound);
        return itemstack;
    }

    public static ItemStack createLightsaber(int colorId, Lightsaber lightsaber, int ... focusingCrystalIds) {
        return LightsaberHelper.createLightsaber(colorId, lightsaber, lightsaber, lightsaber, lightsaber, focusingCrystalIds);
    }

    public static ItemStack createRandomLightsaber(Random random, int colorId) {
        Lightsaber[] parts = new Lightsaber[4];
        ArrayList list = Lists.newArrayList();
        int color = colorId;
        if (colorId == -1) {
            color = random.nextInt(LightsaberColors.getColors().length);
        }
        for (int i = 0; i < 4; ++i) {
            parts[i] = LightsaberAPI.getLightsabers().get(random.nextInt(LightsaberAPI.getLightsabers().size()));
        }
        int j = -1;
        for (int i = 0; i < 2; ++i) {
            float f = random.nextFloat();
            float f2 = i == 0 ? 0.5f : 0.25f;
            if (!(f < f2)) continue;
            int k = random.nextInt(FocusingCrystals.getFocusingCrystals().length);
            if (j != k) {
                list.add(k);
            }
            j = k;
        }
        int[] aint = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            aint[i] = (Integer)list.get(i);
        }
        return LightsaberHelper.createLightsaber(color, parts[0], parts[1], parts[2], parts[3], aint);
    }

    public static ItemStack createRandomLightsaber(Random random) {
        return LightsaberHelper.createRandomLightsaber(random, -1);
    }

    public static ItemStack createDoubleLightsaber(ItemStack upperLightsaber, ItemStack lowerLightsaber) {
        ItemStack itemstack = new ItemStack(ModItems.doubleLightsaber);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74782_a("UpperLightsaber", (NBTBase)upperLightsaber.func_77978_p().func_74775_l("Lightsaber"));
        nbttagcompound.func_74782_a("LowerLightsaber", (NBTBase)lowerLightsaber.func_77978_p().func_74775_l("Lightsaber"));
        itemstack.func_77982_d(nbttagcompound);
        return itemstack;
    }

    public static ItemStack getDoubleLightsaberUpper(ItemStack itemstack) {
        ItemStack itemstack1 = new ItemStack(ModItems.lightsaber);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74782_a("Lightsaber", (NBTBase)itemstack.func_77978_p().func_74775_l("UpperLightsaber"));
        nbttagcompound.func_74757_a("active", itemstack.func_77978_p().func_74767_n("active"));
        itemstack1.func_77982_d(nbttagcompound);
        return itemstack1;
    }

    public static ItemStack getDoubleLightsaberLower(ItemStack itemstack) {
        ItemStack itemstack1 = new ItemStack(ModItems.lightsaber);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74782_a("Lightsaber", (NBTBase)itemstack.func_77978_p().func_74775_l("LowerLightsaber"));
        nbttagcompound.func_74757_a("active", itemstack.func_77978_p().func_74767_n("active"));
        itemstack1.func_77982_d(nbttagcompound);
        return itemstack1;
    }

    public static ItemStack createLightsaberPart(Lightsaber lightsaber, Lightsaber.EnumPartType type) {
        ItemStack itemstack = new ItemStack(type == Lightsaber.EnumPartType.EMITTER ? ModItems.lightsaberEmitter : (type == Lightsaber.EnumPartType.SWITCH_SECTION ? ModItems.lightsaberSwitchSection : (type == Lightsaber.EnumPartType.BODY ? ModItems.lightsaberBody : ModItems.lightsaberPommel)));
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("type", type.name().toLowerCase());
        nbttagcompound.func_74778_a("lightsaber", lightsaber.getName());
        itemstack.func_77982_d(nbttagcompound);
        return itemstack;
    }

    public static Lightsaber getLightsaberFromPart(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        return LightsaberAPI.getLightsaberByName(itemstack.func_77978_p().func_74779_i("lightsaber"));
    }

    public static ItemStack getLightsaberForgeResult(InventoryLightsaberForge inventory, World world) {
        ItemStack emitter = inventory.func_70301_a(0);
        ItemStack switchSection = inventory.func_70301_a(1);
        ItemStack body = inventory.func_70301_a(2);
        ItemStack pommel = inventory.func_70301_a(3);
        ItemStack circuitry = inventory.func_70301_a(4);
        ItemStack crystal = inventory.func_70301_a(5);
        ItemStack focusingCrystal1 = inventory.func_70301_a(6);
        ItemStack focusingCrystal2 = inventory.func_70301_a(7);
        if (emitter != null && emitter.func_77973_b() == ModItems.lightsaberEmitter && switchSection != null && switchSection.func_77973_b() == ModItems.lightsaberSwitchSection && body != null && body.func_77973_b() == ModItems.lightsaberBody && pommel != null && pommel.func_77973_b() == ModItems.lightsaberPommel && circuitry != null && circuitry.func_77973_b() == ModItems.lightsaberCircuitry && crystal != null && crystal.func_77973_b() == Item.func_150898_a((Block)ModBlocks.lightsaberCrystal)) {
            int color = LightsaberHelper.getCrystalColorId(crystal);
            ArrayList list = Lists.newArrayList();
            if (focusingCrystal1 != null) {
                list.add(LightsaberHelper.getFocusingCrystalId(focusingCrystal1));
            }
            if (focusingCrystal2 != null) {
                list.add(LightsaberHelper.getFocusingCrystalId(focusingCrystal2));
            }
            int[] aint = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aint[i] = (Integer)list.get(i);
            }
            return LightsaberHelper.createLightsaber(color, LightsaberHelper.getLightsaberFromPart(emitter), LightsaberHelper.getLightsaberFromPart(switchSection), LightsaberHelper.getLightsaberFromPart(body), LightsaberHelper.getLightsaberFromPart(pommel), aint);
        }
        return null;
    }

    public static ItemStack getEquippedLightsaber(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            if (inventory.field_70462_a[i] == null || inventory.field_70462_a[i].func_77973_b() != ModItems.lightsaber) continue;
            return inventory.field_70462_a[i];
        }
        return null;
    }

    public static int getCrystalColorId(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        return itemstack.func_77978_p().func_74762_e("color");
    }

    public static ItemStack createCrystal(int colorId) {
        ItemStack itemstack = new ItemStack(ModBlocks.lightsaberCrystal);
        ItemLightsaberBase.refreshNBT(itemstack);
        itemstack.func_77978_p().func_74768_a("color", colorId);
        return itemstack;
    }

    public static int getCrystalIdFromColor(int color) {
        for (int i = 0; i < LightsaberColors.getColors().length; ++i) {
            if (color != LightsaberColors.getColors()[i]) continue;
            return i;
        }
        return 0;
    }

    public static int getFocusingCrystalId(ItemStack itemstack) {
        ItemLightsaberBase.refreshNBT(itemstack);
        return itemstack.func_77978_p().func_74762_e("FocusingCrystal");
    }

    public static ItemStack createFocusingCrystal(int crystalId) {
        ItemStack itemstack = new ItemStack(ModItems.focusingCrystal, 1, crystalId);
        ItemLightsaberBase.refreshNBT(itemstack);
        itemstack.func_77978_p().func_74768_a("FocusingCrystal", crystalId);
        return itemstack;
    }

    public static int getFocusingCrystalIdFromName(String name) {
        for (int i = 0; i < FocusingCrystals.getFocusingCrystals().length; ++i) {
            if (!name.equals(FocusingCrystals.getFocusingCrystals()[i])) continue;
            return i;
        }
        return 0;
    }

    public static void igniteLightsaberWithoutNotify(EntityLivingBase entity, boolean state) {
        ItemStack itemstack = entity.func_70694_bm();
        if (itemstack != null) {
            ItemLightsaberBase.refreshNBT(itemstack);
            itemstack.func_77978_p().func_74757_a("active", state);
        }
    }

    public static void igniteLightsaber(EntityLivingBase entity, boolean state) {
        ItemStack itemstack = entity.func_70694_bm();
        if (itemstack != null) {
            ItemLightsaberBase.refreshNBT(itemstack);
            if (itemstack.func_77978_p().func_74767_n("active") != state) {
                if (entity.field_70170_p.field_72995_K) {
                    ALNetworkManager.networkWrapper.sendToServer((IMessage)new PacketIgniteLightsaber(entity, state));
                } else {
                    ALNetworkManager.networkWrapper.sendToDimension((IMessage)new PacketIgniteLightsaber(entity, state), entity.field_71093_bK);
                }
                LightsaberHelper.igniteLightsaberWithoutNotify(entity, state);
            }
        }
    }
}

