/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.helper;

import com.google.common.collect.Maps;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import java.util.Map;
import net.minecraft.util.StatCollector;

public class LightsaberColors {
    public static final int DEEP_BLUE = 255;
    public static final int MEDIUM_BLUE = 27647;
    public static final int LIGHT_BLUE = 5880319;
    public static final int ARCTIC_BLUE = 0xDDF6FF;
    public static final int WHITE = 0xFFFFFF;
    public static final int INDIGO = 6095103;
    public static final int PURPLE = 12400321;
    public static final int MAGENTA = 0xFF00FF;
    public static final int PINK = 16748474;
    public static final int RED = 0xFF0000;
    public static final int BLOOD_ORANGE = 0xFF8000;
    public static final int AMBER = 16758272;
    public static final int YELLOW = 0xFFFF00;
    public static final int GOLD = 0xFFFF3A;
    public static final int LIME_GREEN = 0xBFFF00;
    public static final int GREEN = 65280;
    public static final int MINT_GREEN = 65435;
    public static final int CYAN = 65535;
    public static Map<Integer, Integer> rarityMap = Maps.newHashMap();
    public static Map<Integer, String[]> chestMap = Maps.newHashMap();
    public static final int RARITY_COMMON = 0;
    public static final int RARITY_UNCOMMON = 1;
    public static final int RARITY_RARE = 2;
    public static final int RARITY_EPIC = 3;
    private static boolean hasInit = false;

    public static int[] getColors() {
        return new int[]{255, 27647, 5880319, 0xDDF6FF, 0xFFFFFF, 6095103, 12400321, 0xFF00FF, 16748474, 0xFF0000, 0xFF8000, 16758272, 0xFFFF00, 0xFFFF3A, 0xBFFF00, 65280, 65435, 65535};
    }

    public static String getColorName(int id) {
        return StatCollector.func_74838_a((String)("color." + id));
    }

    public static float[] getRGB(int hex) {
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static void registerRarity(int color, int rarity, String ... chests) {
        int index = LightsaberHelper.getCrystalIdFromColor(color);
        if (index != -1) {
            rarityMap.put(index, rarity);
            chestMap.put(index, chests);
        }
    }

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        LightsaberColors.registerRarity(255, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        LightsaberColors.registerRarity(27647, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        LightsaberColors.registerRarity(5880319, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        LightsaberColors.registerRarity(16758272, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        LightsaberColors.registerRarity(0xFFFF00, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        LightsaberColors.registerRarity(0xFFFF3A, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        LightsaberColors.registerRarity(0xBFFF00, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest", "pyramidDesertyChest");
        LightsaberColors.registerRarity(65280, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest");
        LightsaberColors.registerRarity(65435, 0, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidJungleChest");
        LightsaberColors.registerRarity(0xFF00FF, 1, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        LightsaberColors.registerRarity(16748474, 1, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "dungeonChest");
        LightsaberColors.registerRarity(0xFF0000, 1, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "villageBlacksmith");
        LightsaberColors.registerRarity(0xFF8000, 1, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "pyramidDesertyChest");
        LightsaberColors.registerRarity(6095103, 2, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        LightsaberColors.registerRarity(12400321, 2, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        LightsaberColors.registerRarity(65535, 2, "sithTombCoffin", "sithTombTreasury", "sithTombAnnex", "strongholdLibrary");
        LightsaberColors.registerRarity(0xDDF6FF, 3, "sithTombTreasury", "mineshaftCorridor");
        LightsaberColors.registerRarity(0xFFFFFF, 3, "sithTombTreasury", "mineshaftCorridor");
    }

    static {
        LightsaberColors.init();
    }
}

