/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.helper;

import fiskfille.lightsabers.client.LightsaberAPIClient;
import fiskfille.lightsabers.client.model.ModelLightsaberBlade;
import fiskfille.lightsabers.common.config.ModConfig;
import fiskfille.lightsabers.common.helper.LightsaberColors;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import fiskfille.lightsabers.common.item.ItemLightsaberBase;
import fiskfille.lightsabers.common.lightsaber.Lightsaber;
import fiskfille.lightsabers.common.lightsaber.LightsaberManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ALRenderHelper {
    private static ModelLightsaberBlade modelLightsaberBlade = new ModelLightsaberBlade(34);
    private static ModelLightsaberBlade modelCrossguardBlade = new ModelLightsaberBlade(4);

    public static void setLighting(int lighting) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(lighting % 65536) / 255.0f), (float)((float)(lighting / 65536) / 255.0f));
    }

    public static void renderLightsaberHilt(ItemStack itemstack) {
        for (Lightsaber.EnumPartType type : Lightsaber.EnumPartType.values()) {
            Lightsaber lightsaber = LightsaberHelper.getPart(itemstack, type);
            ModelBase model = LightsaberAPIClient.getModelFor(lightsaber, type);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("lightsabers", "textures/models/lightsaber/" + type.name().toLowerCase() + "_" + lightsaber.getName().toLowerCase().replace(' ', '_').replace("(", "").replace(")", "") + ".png"));
            if (type == Lightsaber.EnumPartType.EMITTER) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)(-LightsaberHelper.getPart((ItemStack)itemstack, (Lightsaber.EnumPartType)Lightsaber.EnumPartType.SWITCH_SECTION).getSwitchSection().height * 0.0625f), (float)0.0f);
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
                continue;
            }
            if (type == Lightsaber.EnumPartType.POMMEL) {
                GL11.glPushMatrix();
                Lightsaber.Part body = LightsaberHelper.getPart(itemstack, Lightsaber.EnumPartType.BODY).getBody();
                float[] afloat = body.glInstructions;
                if (afloat != null && afloat.length > 0) {
                    for (int i = 0; i < afloat.length; ++i) {
                        float f = afloat[i];
                        if (i % 2 == 0) {
                            GL11.glTranslatef((float)0.0f, (float)(f * 0.0625f), (float)0.0f);
                            continue;
                        }
                        GL11.glRotatef((float)f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                } else {
                    GL11.glTranslatef((float)0.0f, (float)(body.height * 0.0625f), (float)0.0f);
                }
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
                continue;
            }
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        }
    }

    public static void renderLightsaberBlade(ItemStack itemstack, boolean flag) {
        if (ItemLightsaberBase.isActive(itemstack)) {
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            float[] color = LightsaberColors.getRGB(LightsaberColors.getColors()[LightsaberHelper.getColorId(itemstack)]);
            Lightsaber emitter = LightsaberHelper.getPart(itemstack, Lightsaber.EnumPartType.EMITTER);
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            ALRenderHelper.setLighting((int)(61680.0f * ModConfig.renderLightingMultiplier));
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)32772);
            GL11.glAlphaFunc((int)516, (float)0.99f);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2884);
            if (emitter == LightsaberManager.lightsaberKnighted) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.083f, (float)-0.23f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                modelCrossguardBlade.renderCrossguardOuter(itemstack, color[0], color[1], color[2], flag);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.083f, (float)0.23f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                modelCrossguardBlade.renderCrossguardOuter(itemstack, color[0], color[1], color[2], flag);
                GL11.glPopMatrix();
            }
            modelLightsaberBlade.renderOuter(itemstack, color[0], color[1], color[2], flag);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPushMatrix();
            if (emitter == LightsaberManager.lightsaberKnighted) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.083f, (float)-0.23f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                modelCrossguardBlade.renderCrossguardInner(itemstack);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.083f, (float)0.23f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                modelCrossguardBlade.renderCrossguardInner(itemstack);
                GL11.glPopMatrix();
            }
            modelLightsaberBlade.renderInner(itemstack);
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            GL11.glPopMatrix();
        }
    }

    public static void drawTip(float size, float tip) {
        float f = 0.0625f;
        float f1 = f / 2.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)size, (double)size, 0.0);
        tessellator.func_78377_a((double)(-size), (double)size, 0.0);
        tessellator.func_78377_a((double)(-size + f1), (double)(-size - tip), (double)(-f1));
        tessellator.func_78377_a((double)(size - f1), (double)(-size - tip), (double)(-f1));
        tessellator.func_78377_a((double)size, (double)size, (double)(-f));
        tessellator.func_78377_a((double)(-size), (double)size, (double)(-f));
        tessellator.func_78377_a((double)(-size + f1), (double)(-size - tip), (double)(-f + f1));
        tessellator.func_78377_a((double)(size - f1), (double)(-size - tip), (double)(-f + f1));
        tessellator.func_78377_a((double)(-f1), (double)size, (double)(size - f1));
        tessellator.func_78377_a((double)(-f1), (double)size, (double)(-size - f1));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(-size));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(size - f));
        tessellator.func_78377_a((double)f1, (double)size, (double)(size - f1));
        tessellator.func_78377_a((double)f1, (double)size, (double)(-size - f1));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(-size));
        tessellator.func_78377_a(0.0, (double)(-size - tip), (double)(size - f));
        tessellator.func_78381_a();
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }
}

