/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.generator.structure;

import fiskfille.lightsabers.common.block.ModBlocks;
import fiskfille.lightsabers.common.generator.structure.Structure;
import fiskfille.lightsabers.common.tileentity.TileEntitySithCoffin;
import fiskfille.lightsabers.common.tileentity.TileEntitySithStoneCoffin;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class StructureSithTomb
extends Structure {
    public StructureSithTomb(World world, int x, int y, int z) {
        super(world, x, y, z);
    }

    @Override
    public void spawnStructure(Random random) {
        this.generateEntrance(random);
        int stairLength = 5;
        int k = 63;
        while (!this.worldObj.func_147437_c(this.xCoord, k + 1, this.zCoord + 17 + stairLength)) {
            ++k;
        }
        while (this.yCoord - stairLength + 5 > k) {
            ++stairLength;
        }
        this.generateStairway(random, stairLength);
        this.generateAntechamber(random);
        this.generateAnnex(random);
        this.xCoord -= 17;
        this.zCoord -= 5;
        this.generateBurialChamber(random);
        this.generateTreasury(random);
        int coffinX = -1;
        int coffinY = 0;
        int coffinZ = 6;
        this.generateCoffin(20, -1, 10, 2, coffinX, coffinY, coffinZ);
        this.generateCoffin(23, -1, 10, 2, coffinX, coffinY, coffinZ);
        this.generateCoffin(26, -1, 10, 2, coffinX, coffinY, coffinZ);
        this.generateCoffin(20, -1, 2, 0, coffinX, coffinY, coffinZ);
    }

    private void generateEntrance(Random random) {
        int k;
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 11; ++j) {
                for (k = 0; k < 16; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 4 - i, j, 1 + k);
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 9; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, 4 - j, 0, 1 + i);
                k = 0;
                while (this.worldObj.func_147437_c(this.xCoord + 4 - j, this.yCoord - 1 + k, this.zCoord + 1 + i)) {
                    this.setBlock(this.worldObj.func_72807_a((int)(this.xCoord + 4 - j), (int)(this.zCoord + 1 + i)).field_76753_B, 0, 4 - j, --k, 1 + i);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 0 : (i == 4 ? 1 : 2), 2 - i, 0, 1);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 0 : (i == 4 ? 1 : 3), 2 - i, 0, 16);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 4 : (i == 4 ? 5 : 1), 2 - i, i == 0 || i == 4 ? 4 : 5, 1);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 4 : (i == 4 ? 5 : 1), 2 - i, 4, 16);
            this.setBlock(ModBlocks.darkForcestone, i == 0 || i == 4 ? 0 : 1, 2 - i, 4, 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, 2, 2 - i, 5, 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, 3, 2 - i, 5, 15);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 1), 4, 0, 3 + i);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 7 : (i == 4 ? 6 : 1), 4, i == 0 || i == 4 ? 4 : 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestone, i == 0 || i == 4 ? 0 : 1, 3, 4, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 1), 4, 0, 10 + i);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 7 : (i == 4 ? 6 : 1), 4, 4, 10 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 1, 3, 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 1, 3, 5, 10 + i);
            this.setBlock((Block)Blocks.field_150399_cn, 14, 2, 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, 2, 4, 9 + i);
            this.setBlock((Block)(i == 0 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 3 : 1, 2, 1, 9 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 0), -4, 0, 3 + i);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 7 : (i == 4 ? 6 : 1), -4, i == 0 || i == 4 ? 4 : 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestone, i == 0 || i == 4 ? 0 : 1, -3, 4, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : (i == 4 ? 2 : 0), -4, 0, 10 + i);
            this.setBlock((Block)(i == 0 || i == 4 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 7 : (i == 4 ? 6 : 1), -4, 4, 10 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 0, -3, 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 0, -3, 5, 10 + i);
            this.setBlock((Block)Blocks.field_150399_cn, 14, -2, 5, 3 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 5, -2, 4, 9 + i);
            this.setBlock((Block)(i == 0 ? ModBlocks.darkForcestoneStairs : ModBlocks.forcestoneSlab), i == 0 ? 3 : 1, -2, 1, 9 + i);
            if (i < 3) {
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, 1 + i, 2);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, 1 + i, 2);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, 6 + i, 10);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, 6 + i, 10);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, 6 + i, 14);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, 6 + i, 14);
                this.setBlock((Block)Blocks.field_150399_cn, 14, -1 + i, 5, 3);
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, -1 + i, 0, 10);
                this.setBlock(ModBlocks.darkForcestoneStairs, 6, -1 + i, 0, 14);
                this.setBlock(ModBlocks.darkForcestoneStairs, 2, -1 + i, 6, 10);
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, -1 + i, 6, 14);
                this.setBlock(ModBlocks.darkForcestoneStairs, 1, 2, 6, 11 + i);
                this.setBlock(ModBlocks.darkForcestoneStairs, 0, -2, 6, 11 + i);
                this.setBlock(ModBlocks.darkForcestoneStairs, 2, -1 + i, 9, 10);
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, -1 + i, 9, 14);
                this.setBlock(ModBlocks.darkForcestoneStairs, 7, -1 + i, 9, 11);
                this.setBlock(ModBlocks.darkForcestoneStairs, 6, -1 + i, 9, 13);
                this.setBlock(ModBlocks.darkForcestoneStairs, 2, -1 + i, 10, 11);
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, -1 + i, 10, 13);
            }
            if (i < 4) {
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, 1 + i, 8);
                this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, 1 + i, 8);
                this.setBlock(ModBlocks.darkForcestone, 2, 2, 1 + i, 14);
                this.setBlock(ModBlocks.darkForcestone, 2, -2, 1 + i, 14);
            }
            this.setBlock((Block)ModBlocks.forcestoneSlab, 1, 2 - i, 6, 9);
            this.setBlock(ModBlocks.darkForcestoneStairs, 1, 2, 9, 10 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 0, -2, 9, 10 + i);
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 2; ++k) {
                    this.setBlock(ModBlocks.darkForcestone, i == 1 && k == 1 ? 0 : 2, 4 - i, 1 + j, 1 + k);
                    this.setBlock(ModBlocks.darkForcestone, i == 1 && k == 1 ? 0 : 2, -4 + i, 1 + j, 1 + k);
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 5; ++j) {
                for (k = 0; k < 2; ++k) {
                    this.setBlock(ModBlocks.darkForcestone, 2, 4, 1 + j, 8 + k);
                    this.setBlock(ModBlocks.darkForcestone, 2, -4, 1 + j, 8 + k);
                    this.setBlock(ModBlocks.darkForcestone, i == 1 && k == 0 ? 0 : 2, 4 - i, 1 + j, 15 + k);
                    this.setBlock(ModBlocks.darkForcestone, i == 1 && k == 0 ? 0 : 2, -4 + i, 1 + j, 15 + k);
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 7; ++j) {
                this.setBlock(ModBlocks.darkForcestone, j > 0 && i == 1 ? 1 : 0, 3, 1 + i, 8 + j);
                this.setBlock(ModBlocks.darkForcestone, j > 0 && i == 1 ? 1 : 0, -3, 1 + i, 8 + j);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 4; ++j) {
                this.setBlock(ModBlocks.darkForcestone, j == 1 ? 1 : 0, -2 + i, 1 + j, 15);
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 6; ++j) {
                if (j <= 3 && (i <= 1 || i >= 5)) continue;
                this.setBlock(ModBlocks.darkForcestone, 0, 3 - i, 5, 4 + j);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i != 0 && i != 4 && j != 0 && j != 4) continue;
                this.setBlock(ModBlocks.darkForcestone, 0, -2 + i, 5, 10 + j);
            }
        }
        for (i = 0; i < 2; ++i) {
            j = i == 0 ? 0 : 6;
            this.setBlock(ModBlocks.darkForcestoneStairs, 3, 3 - j, 1, 3);
            this.setBlock(ModBlocks.darkForcestoneStairs, 2, 3 - j, 1, 7);
            this.setBlock(ModBlocks.darkForcestoneStairs, 7, 3 - j, 3, 3);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 3 - j, 3, 7);
        }
        for (i = 0; i < 4; ++i) {
            int x = i % 2 == 0 ? -4 : 3;
            int y = 6;
            int z = 8 + i / 2 * 7;
            for (int j2 = 0; j2 < 4; ++j2) {
                int k2 = j2 == 0 ? 0 : (j2 == 1 ? 2 : (j2 == 2 ? 3 : 1));
                this.setBlock(ModBlocks.darkForcestoneStairs, k2, x + j2 % 2, y, z + j2 / 2);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.setBlock(Blocks.field_150350_a, 0, -1 + i, 0, 11 + j);
            }
        }
        this.setBlock(ModBlocks.darkForcestoneStairs, 1, 1, 10, 12);
        this.setBlock(ModBlocks.darkForcestoneStairs, 0, -1, 10, 12);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 9, 12);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 9, 12);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 3, 2);
        this.setBlock((Block)Blocks.field_150399_cn, 14, 0, 10, 12);
        this.setBlock(ModBlocks.darkForcestone, 0, 3, 5, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 2, 3, 5, 1);
        this.setBlock(ModBlocks.darkForcestoneStairs, 2, 4, 5, 1);
        this.setBlock(ModBlocks.darkForcestoneStairs, 1, 4, 5, 2);
        this.setBlock(ModBlocks.darkForcestone, 0, -3, 5, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 2, -3, 5, 1);
        this.setBlock(ModBlocks.darkForcestoneStairs, 2, -4, 5, 1);
        this.setBlock(ModBlocks.darkForcestoneStairs, 0, -4, 5, 2);
        this.setBlock(Blocks.field_150451_bX, 0, 0, 0, 3);
        this.setBlock(Blocks.field_150451_bX, 0, 1, 0, 4);
        this.setBlock(Blocks.field_150451_bX, 0, -1, 0, 4);
        this.setBlock(Blocks.field_150451_bX, 0, 0, 0, 5);
        this.setBlock(Blocks.field_150451_bX, 0, 1, 0, 6);
        this.setBlock(Blocks.field_150451_bX, 0, -1, 0, 6);
        this.setBlock(Blocks.field_150451_bX, 0, 0, 0, 7);
        this.setBlock(Blocks.field_150451_bX, 0, 0, 0, 8);
        this.generateStatue(0, 1, 14, 2, false);
        this.zCoord += 12;
    }

    private void generateStairway(Random random, int stairLength) {
        int k;
        int j;
        int i;
        int i1 = 0;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j <= i1; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, 2, -6 + i, 4 - j);
                this.setBlock(ModBlocks.darkForcestone, 0, -2, -6 + i, 4 - j);
                if (j == i1) continue;
                for (k = 0; k < 3; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 1 - k, -6 + i, 4 - j);
                }
            }
            ++i1;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 7; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, 1 - i, -1 - j, -2 + j);
                if (j <= 0) continue;
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, 1 - i, -j, -2 + j);
            }
            this.setBlock(ModBlocks.darkForcestone, 0, 1 - i, -1, 4);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, -1, 3);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, -2, 4);
            for (j = 0; j < stairLength; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, 1 - i, -8 - j, 5 + j);
                this.setBlock(ModBlocks.darkForcestoneStairs, 3, 1 - i, -7 - j, 5 + j);
                this.setBlock(ModBlocks.darkForcestone, 0, 1 - i, -2 - j, 5 + j);
                this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, -3 - j, 5 + j);
                this.setBlock(Blocks.field_150350_a, 6, 1 - i, -4 - j, 5 + j);
                this.setBlock(Blocks.field_150350_a, 6, 1 - i, -5 - j, 5 + j);
                this.setBlock(Blocks.field_150350_a, 6, 1 - i, -6 - j, 5 + j);
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < stairLength; ++j) {
                if ((i + j + 1) % 5 == 0) {
                    this.setBlock(ModBlocks.darkActivatedForcestone, 8, 2, -3 - i - j, 5 + j);
                    this.setBlock(ModBlocks.darkActivatedForcestone, 8, -2, -3 - i - j, 5 + j);
                    continue;
                }
                this.setBlock(ModBlocks.darkForcestone, 0, 2, -3 - i - j, 5 + j);
                this.setBlock(ModBlocks.darkForcestone, 0, -2, -3 - i - j, 5 + j);
            }
        }
        this.zCoord += 5 + stairLength;
        this.yCoord -= 7 + stairLength;
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 10; ++j) {
                for (k = 0; k < 10; ++k) {
                    this.setBlock(Blocks.field_150348_b, 0, 4 - i, j - 3, k);
                }
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 8; ++j) {
                for (k = 0; k < 8; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 3 - i, j - 2, k + 1);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                for (k = 0; k < 11; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 1 - i, j + 1, k);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 11; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, 2 - i, 0, j);
                if (j < 10) {
                    this.setBlock(ModBlocks.darkForcestone, 0, 2 - i, 4, j + 1);
                }
                if (i >= 4) continue;
                this.setBlock(ModBlocks.darkForcestone, i == 1 ? 1 : 0, 2, 1 + i, j);
                this.setBlock(ModBlocks.darkForcestone, i == 1 ? 1 : 0, -2, 1 + i, j);
                this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 3, 7 + i);
                this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 3, 7 + i);
            }
        }
        for (i = 0; i < 2; ++i) {
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 4, 1 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 4, 1 + i);
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 0, 1 - i, 5, 0);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, 4, 0);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, i + 1, 4);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, i + 1, 4);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, i + 1, 6);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, i + 1, 6);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, 3, 4);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, 1 - i, 4, 3);
            this.setBlock(ModBlocks.darkForcestoneStairs, 7, 1 - i, 3, 6);
        }
        this.setBlock((Block)Blocks.field_150320_F, 0, 0, 4, 5);
        this.setBlock((Block)Blocks.field_150320_F, 1, 0, -1, 5);
        this.setBlock(ModBlocks.darkForcestone, 2, 0, 3, 5);
        this.setBlock(ModBlocks.darkForcestone, 2, 0, 0, 5);
        for (i = 0; i < 2; ++i) {
            this.setBlock((Block)Blocks.field_150320_F, 4, 3, 1 + i, 5);
            this.setBlock((Block)Blocks.field_150320_F, 5, -3, 1 + i, 5);
            this.setBlock(ModBlocks.darkForcestone, 3, 2, 1 + i, 5);
            this.setBlock(ModBlocks.darkForcestone, 3, -2, 1 + i, 5);
            j = i == 0 ? 3 : -3;
            this.setBlock(Blocks.field_150348_b, 0, j, 2, 3);
            this.setBlock((Block)Blocks.field_150488_af, 0, j, 3, 3);
            this.setBlock(Blocks.field_150429_aA, 3, j, 2, 4);
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock(Blocks.field_150452_aw, 0, 1 - i, 1, 3);
            this.setBlock(Blocks.field_150452_aw, 0, 1 - i, 1, 7);
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i != 0 && i != 6 && j != 0 && j != 4) continue;
                this.setBlock(Blocks.field_150348_b, 0, 3 - i, -2, 3 + j);
                this.setBlock((Block)Blocks.field_150488_af, 0, 3 - i, -1, 3 + j);
            }
        }
        this.setBlock(Blocks.field_150348_b, 0, 1, -2, 5);
        this.setBlock(Blocks.field_150429_aA, 2, 0, -2, 5);
        this.setBlock((Block)Blocks.field_150488_af, 0, 1, -2, 6);
        this.setBlock((Block)Blocks.field_150488_af, 0, 1, -2, 4);
        this.setBlock((Block)Blocks.field_150333_U, 8, -3, 3, 4);
        this.setBlock((Block)Blocks.field_150488_af, 0, -3, 4, 4);
        this.setBlock(Blocks.field_150429_aA, 1, -1, 4, 5);
        for (i = 0; i < 5; ++i) {
            this.setBlock((Block)Blocks.field_150333_U, 8, -3, -2 + i, 2 - i % 2);
            this.setBlock((Block)Blocks.field_150333_U, 8, 3, -2 + i, 2 - i % 2);
            this.setBlock((Block)Blocks.field_150488_af, 0, -3, -1 + i, 2 - i % 2);
            this.setBlock((Block)Blocks.field_150488_af, 0, 3, -1 + i, 2 - i % 2);
            if (i >= 4) continue;
            this.setBlock((Block)Blocks.field_150333_U, 8, -3, -1 + i, 8 - i % 2);
            this.setBlock((Block)Blocks.field_150488_af, 0, -3, i, 8 - i % 2);
            this.setBlock((Block)Blocks.field_150488_af, 0, -2, i == 2 ? 5 : 4, 7 - i);
        }
        this.zCoord += 10;
    }

    private void generateAntechamber(Random random) {
        int k;
        int j;
        int i;
        for (i = 0; i < 23; ++i) {
            for (j = 0; j < 7; ++j) {
                for (k = 0; k < 11; ++k) {
                    this.setBlock(ModBlocks.darkForcestone, j == 2 ? 1 : 0, 11 - i, j - 1, 1 + k);
                }
            }
        }
        for (i = 0; i < 21; ++i) {
            for (j = 0; j < 5; ++j) {
                for (k = 0; k < 9; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 10 - i, j, 2 + k);
                }
            }
        }
        for (i = 0; i < 21; ++i) {
            for (j = 0; j < 9; ++j) {
                if (i != 0 && i != 20 && j != 0 && j != 8) continue;
                k = i == 0 ? 0 : (i == 20 ? 1 : (j == 0 ? 3 : 2));
                this.setBlock(ModBlocks.darkForcestoneStairs, k, 10 - i, 0, 2 + j);
                this.setBlock(ModBlocks.darkForcestoneStairs, k + 4, 10 - i, 3, 2 + j);
                this.setBlock(ModBlocks.darkForcestone, 0, 10 - i, 4, 2 + j);
            }
        }
        for (i = 0; i < 19; ++i) {
            for (j = 0; j < 7; ++j) {
                if (i != 0 && i != 18 && j != 0 && j != 6) continue;
                k = i == 0 ? 0 : (i == 18 ? 1 : (j == 0 ? 3 : 2));
                this.setBlock(ModBlocks.darkForcestoneStairs, k + 4, 9 - i, 4, 3 + j);
            }
        }
        for (i = 0; i < 17; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i == 0 || i == 16 || j == 0 || j == 4) {
                    k = i == 0 ? 0 : (i == 16 ? 1 : (j == 0 ? 3 : 2));
                    this.setBlock(ModBlocks.darkForcestoneStairs, k, 8 - i, -1, 4 + j);
                    continue;
                }
                this.setBlock((Block)ModBlocks.forcestoneSlab, 1, 8 - i, -1, 4 + j);
            }
        }
        for (i = 0; i < 15; ++i) {
            boolean flag;
            boolean bl = flag = i == 1 || i == 4 || i == 10 || i == 13;
            if (flag || i == 7) {
                this.setBlock(Blocks.field_150451_bX, 1, 7 - i, -1, 5);
                this.setBlock(Blocks.field_150451_bX, 1, 7 - i, -1, 7);
            }
            if (flag && i != 7) continue;
            this.setBlock(Blocks.field_150451_bX, 1, 7 - i, -1, 6);
        }
        for (i = 0; i < 2; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 2, 8, i, 11);
            this.setBlock(ModBlocks.darkForcestone, 2, 4, i, 11);
            this.setBlock(ModBlocks.darkForcestone, 2, -11, i, 8);
            this.setBlock(ModBlocks.darkForcestone, 2, -11, i, 4);
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock((Block)ModBlocks.forcestoneSlab, 1, 1 - i, 3, 1);
            this.setBlock(Blocks.field_150350_a, 0, 1 - i, 2, 1);
            this.setBlock(Blocks.field_150350_a, 0, 1 - i, 1, 1);
            this.setBlock(Blocks.field_150350_a, 0, 1 - i, 0, 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, 3, 1 - i, 0, 1);
            for (j = 0; j < 3; ++j) {
                this.setBlock(Blocks.field_150350_a, 0, 5 + i, j, 11);
                this.setBlock(Blocks.field_150350_a, 0, -11, j, 7 - i);
            }
            this.setBlock(Blocks.field_150350_a, 0, 5 + i, 0, 10);
            this.setBlock(Blocks.field_150350_a, 0, -10, 0, 7 - i);
        }
        for (i = 0; i < 4; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 2, 2, 1 + i, 1);
            this.setBlock(ModBlocks.darkForcestone, 2, -2, 1 + i, 1);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, i, 2);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, i, 2);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 8, i, 10);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 4, i, 10);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -10, i, 8);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -10, i, 4);
        }
        this.generateStatue(10, 0, 6, 1, true);
        this.generateStatue(-8, 0, 10, 2, true);
        this.generateStatue(-8, 0, 2, 0, true);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, -7, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, -9, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, -10, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, -7, 3, 10);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, -9, 3, 10);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, -10, 3, 10);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, 10, 3, 5);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, 10, 3, 7);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 3, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 1, 3, 0, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 0, -3, 0, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, 7, 3, 10);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, 5, 3, 10);
        this.setBlock(ModBlocks.darkForcestoneStairs, 4, 7, 2, 11);
        this.setBlock(ModBlocks.darkForcestoneStairs, 5, 5, 2, 11);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, -10, 3, 7);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, -10, 3, 5);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, -11, 2, 7);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, -11, 2, 5);
        this.xCoord += 6;
        this.zCoord += 11;
    }

    private void generateAnnex(Random random) {
        int k;
        int j;
        int i;
        for (i = 0; i < 15; ++i) {
            for (j = 0; j < 7; ++j) {
                for (k = 0; k < 9; ++k) {
                    if (j == 6) {
                        this.setBlock(ModBlocks.darkForcestone, 0, i - 9, j - 1, 2 + k);
                        continue;
                    }
                    this.setBlock(i == 0 || i == 14 || j == 0 || j == 5 || k == 0 || k == 8 ? ModBlocks.darkForcestone : Blocks.field_150350_a, j == 2 ? 1 : 0, i - 9, j - 1, 2 + k);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                for (k = 0; k < 2; ++k) {
                    this.setBlock(i == 0 || i == 4 || j == 0 || j == 4 ? ModBlocks.darkForcestone : Blocks.field_150350_a, 0, 2 - i, j - 1, k + 1);
                }
            }
        }
        for (i = 0; i < 13; ++i) {
            for (j = 0; j < 7; ++j) {
                if (i != 0 && i != 12 && j != 0 && j != 6) continue;
                k = i == 0 ? 1 : (i == 12 ? 0 : (j == 0 ? 3 : 2));
                this.setBlock(i == 0 || i == 12 || j == 0 || j == 6 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k, i - 8, 0, 3 + j);
                this.setBlock(i == 0 || i == 12 || j == 0 || j == 6 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k - 4, i - 8, 3, 3 + j);
            }
        }
        for (i = 0; i < 11; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i != 0 && i != 10 && j != 0 && j != 4) continue;
                k = i == 0 ? 1 : (i == 10 ? 0 : (j == 0 ? 3 : 2));
                this.setBlock(i == 0 || i == 10 || j == 0 || j == 4 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k - 4, i - 7, 4, 4 + j);
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 3; ++j) {
                if (i != 0 && i != 8 && j != 0 && j != 2) continue;
                k = i == 0 ? 0 : (i == 8 ? 1 : (j == 0 ? 2 : 3));
                this.setBlock(i == 0 || i == 8 || j == 0 || j == 2 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k - 4, i - 6, 4, 5 + j);
            }
        }
        for (i = 0; i < 2; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 2, 2, i, 2);
            this.setBlock(ModBlocks.darkForcestone, 2, -2, i, 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, 1, 2, 1 + i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 5, -1, 2, 1 + i);
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock(Blocks.field_150350_a, 0, 1 - i, 0, 3);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 2, i, 3);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -2, i, 3);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 4, i, 5);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, 4, i, 7);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -8, i, 5);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -8, i, 7);
            this.setBlock(ModBlocks.darkForcestone, 1, 4, 3, 5 + i);
            this.setBlock(ModBlocks.darkForcestone, 1, -8, 3, 5 + i);
        }
        for (i = 0; i < 5; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 0, 2 - i, 3, 3);
        }
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, 4, 3, 4);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, 4, 3, 8);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, -8, 3, 4);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, -8, 3, 8);
        this.generateStructureChestContents(random, 4, 0, 6, ChestGenHooks.getItems((String)"sithTombAnnex", (Random)random), ChestGenHooks.getCount((String)"sithTombAnnex", (Random)random));
        this.generateStructureChestContents(random, -8, 0, 6, ChestGenHooks.getItems((String)"sithTombAnnex", (Random)random), ChestGenHooks.getCount((String)"sithTombAnnex", (Random)random));
    }

    private void generateBurialChamber(Random random) {
        int k;
        int j;
        int i;
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.setBlock(i == 0 || i == 4 || j == 0 || j == 4 ? ModBlocks.darkForcestone : Blocks.field_150350_a, 0, -1, i - 1, 2 - j);
            }
        }
        for (i = 0; i < 19; ++i) {
            for (j = 0; j < 7; ++j) {
                for (k = 0; k < 13; ++k) {
                    this.setBlock(i == 0 || i == 18 || j == 0 || j == 6 || k == 0 || k == 12 ? ModBlocks.darkForcestone : Blocks.field_150350_a, j == 2 ? 1 : 0, -i - 2, j - 1, 6 - k);
                }
            }
        }
        for (i = 0; i < 17; ++i) {
            for (j = 0; j < 11; ++j) {
                if (i != 0 && i != 16 && j != 0 && j != 10) continue;
                k = i == 0 ? 0 : (i == 16 ? 1 : (j == 0 ? 2 : 3));
                this.setBlock(i == 0 || i == 16 || j == 0 || j == 10 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k, -i - 3, 0, 5 - j);
                this.setBlock(i == 0 || i == 16 || j == 0 || j == 10 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k + 4, -i - 3, 5, 5 - j);
            }
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i != 0 && i != 6 && j != 0 && j != 4) continue;
                k = i == 0 ? 1 : (i == 6 ? 0 : (j == 0 ? 3 : 2));
                this.setBlock(i == 0 || i == 6 || j == 0 || j == 4 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k, -i - 5, -1, 2 - j);
            }
        }
        for (i = 0; i < 12; ++i) {
            for (j = 0; j < 7; ++j) {
                if (i != 0 && i != 11 && j != 0 && j != 6) continue;
                k = i == 0 ? 1 : (i == 11 ? 0 : (j == 0 ? 3 : 2));
                this.setBlock(i == 0 || i == 11 || j == 0 || j == 6 ? ModBlocks.darkForcestoneStairs : Blocks.field_150350_a, k + 4, -i - 6, 5, 3 - j);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 1, -3, 4, 1 - i);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 6 : (i == 2 ? 7 : 4), -3, 3, 1 - i);
            this.setBlock(ModBlocks.darkForcestone, 0, -14, 0, 1 - i);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -18 + i, 0, 4);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -18 + i, 0, -4);
            this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -13, 0, 1 - i);
            for (j = 0; j < 2; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 1, -2, 2 + i, 3 + j);
                this.setBlock(ModBlocks.darkForcestone, 1, -2, 2 + i, -4 + j);
                this.setBlock(ModBlocks.darkForcestone, 1, -15 + i, 2 + j, -6);
            }
            for (j = 0; j < 3; ++j) {
                this.setBlock(Blocks.field_150350_a, 0, -2, i, 1 - j);
            }
            this.setBlock(Blocks.field_150350_a, 0, -3, 0, 1 - i);
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 7; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 0, -19 + i, 0, 3 - j);
            }
        }
        for (i = 0; i < 5; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 0, -3, 5, 2 - i);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -3, i, 2);
            this.setBlock(ModBlocks.darkActivatedForcestone, 0, -3, i, -2);
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, -4, 5, 2 - i);
            this.setBlock(ModBlocks.darkForcestone, 0, -15, 0, 2 - i);
            this.setBlock(i == 4 ? ModBlocks.darkForcestone : ModBlocks.darkActivatedForcestone, 0, -19, 1 + i, 3);
            this.setBlock(i == 4 ? ModBlocks.darkForcestone : ModBlocks.darkActivatedForcestone, 0, -19, 1 + i, -3);
            for (j = 0; j < 3; ++j) {
                this.setBlock(ModBlocks.darkForcestone, 1, -20, 2 + j, 2 - i);
            }
        }
        for (i = 0; i < 6; ++i) {
            this.setBlock(ModBlocks.darkForcestone, 2, -3, i, 5);
            this.setBlock(ModBlocks.darkForcestone, 2, -3, i, -5);
            this.setBlock(ModBlocks.darkForcestone, 2, -19, i, 5);
            this.setBlock(ModBlocks.darkForcestone, 2, -19, i, -5);
        }
        for (i = 0; i < 2; ++i) {
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, -1 - i, 2, 1);
            this.setBlock(ModBlocks.darkForcestoneStairs, 7, -1 - i, 2, -1);
        }
        this.generateStatue(-6, 0, 5, 2, true);
        this.generateStatue(-10, 0, 5, 2, true);
        this.generateStatue(-14, 0, 5, 2, true);
        this.generateStatue(-6, 0, -5, 0, true);
        this.generateStatue(-10, 0, -5, 0, true);
        this.generateStatue(-14, 0, -5, 0, true);
        this.generateStatue(-19, 1, 0, 3, true);
        this.setBlock(ModBlocks.darkForcestoneStairs, 6, -19, 5, 2);
        this.setBlock(ModBlocks.darkForcestoneStairs, 7, -19, 5, -2);
        this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -15, 0, 3);
        this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -14, 0, 2);
        this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -15, 0, -3);
        this.setBlock((Block)ModBlocks.forcestoneSlab, 1, -14, 0, -2);
        for (i = 0; i < 5; ++i) {
            if (i == 0 || i == 3) {
                this.setBlock(Blocks.field_150451_bX, 0, -6 - i, -1, 0);
                continue;
            }
            this.setBlock(Blocks.field_150451_bX, 0, -6 - i, -1, 1);
            this.setBlock(Blocks.field_150451_bX, 0, -6 - i, -1, -1);
        }
        this.setBlock(ModBlocks.sithCoffin, 1, -15, 1, 0);
        this.setBlock(ModBlocks.sithCoffin, 9, -16, 1, 0);
        this.fillStructureInventory(ModBlocks.sithCoffin, random, -15, 1, 0, ChestGenHooks.getItems((String)"sithTombCoffin", (Random)random), ChestGenHooks.getCount((String)"sithTombCoffin", (Random)random));
        this.xCoord -= 14;
        ++this.yCoord;
        this.zCoord -= 6;
    }

    private void generateTreasury(Random random) {
        int k;
        int j;
        int i;
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                for (k = 0; k < 3; ++k) {
                    this.setBlock(i == 0 || i == 4 || j == 0 || j == 4 ? ModBlocks.darkForcestone : Blocks.field_150350_a, i == 0 || i == 4 ? (k == 1 ? 0 : 2) : 0, 2 - i, j - 1, -k - 1);
                }
            }
        }
        for (i = 0; i < 11; ++i) {
            for (j = 0; j < 6; ++j) {
                for (k = 0; k < 9; ++k) {
                    this.setBlock(ModBlocks.darkForcestone, 0, 5 - i, j - 1, -4 - k);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 7; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 2 - i, j, -4 - k);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            this.setBlock(ModBlocks.darkForcestoneStairs, 1, 1, 0, -6 - i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 0, -1, 0, -6 - i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, 4, 4, -6 - i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 5, -4, 4, -6 - i);
            this.setBlock(ModBlocks.darkForcestoneStairs, 7, 1 - i, 4, -11);
            for (j = 0; j < 4; ++j) {
                this.setBlock(Blocks.field_150350_a, 0, 1 - i, j, -11);
                for (k = 0; k < 2; ++k) {
                    this.setBlock(Blocks.field_150350_a, 0, 3 + k, j, -6 - i);
                    this.setBlock(Blocks.field_150350_a, 0, -3 - k, j, -6 - i);
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : 2, 3, 0, -6 - i * 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 3 : 2, -3, 0, -6 - i * 2);
            this.setBlock(ModBlocks.darkForcestoneStairs, i == 0 ? 1 : 0, 1 - i * 2, 0, -10);
        }
        for (i = 0; i < 4; ++i) {
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, 2, i, -4);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, -2, i, -4);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, 2, i, -10);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, -2, i, -10);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, 3, i, -5);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, -3, i, -5);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, 3, i, -9);
            this.setBlock(ModBlocks.darkActivatedForcestone, 2, -3, i, -9);
        }
        this.generateStatue(0, 0, -11, 0, false);
        this.generateStatue(4, 0, -7, 1, false);
        this.generateStatue(-4, 0, -7, 3, false);
        this.setBlock(ModBlocks.darkForcestoneStairs, 3, 0, 0, -6);
        this.setBlock(ModBlocks.darkForcestoneStairs, 2, 0, 0, -8);
        this.setBlock(Blocks.field_150451_bX, 0, 0, 0, -7);
        this.generateStructureChestContents(random, 0, 0, -10, ChestGenHooks.getItems((String)"sithTombTreasury", (Random)random), ChestGenHooks.getCount((String)"sithTombTreasury", (Random)random));
        this.generateStructureChestContents(random, 3, 0, -7, ChestGenHooks.getItems((String)"sithTombTreasury", (Random)random), ChestGenHooks.getCount((String)"sithTombTreasury", (Random)random));
        this.generateStructureChestContents(random, -3, 0, -7, ChestGenHooks.getItems((String)"sithTombTreasury", (Random)random), ChestGenHooks.getCount((String)"sithTombTreasury", (Random)random));
    }

    private void generateStatue(int x, int y, int z, int rotation, boolean foot) {
        if (rotation % 2 == 0) {
            this.setBlock(ModBlocks.darkForcestone, 2, x, y + 1, z);
            this.setBlock(ModBlocks.darkForcestone, 1, x, y + 2, z);
            this.setBlock(ModBlocks.darkForcestoneStairs, 5, x + 1, y + 2, z);
            this.setBlock(ModBlocks.darkForcestoneStairs, 4, x - 1, y + 2, z);
            this.setBlock(Blocks.field_150451_bX, 0, x, y + 3, z);
            if (foot) {
                this.setBlock(ModBlocks.darkForcestone, 0, x, y, z);
                if (rotation == 2) {
                    this.setBlock(ModBlocks.darkForcestoneStairs, 2, x, y, z - 1);
                } else {
                    this.setBlock(ModBlocks.darkForcestoneStairs, 3, x, y, z + 1);
                }
            } else {
                this.setBlock(ModBlocks.darkForcestone, 2, x, y, z);
            }
        } else {
            this.setBlock(ModBlocks.darkForcestone, 2, x, y + 1, z);
            this.setBlock(ModBlocks.darkForcestone, 1, x, y + 2, z);
            this.setBlock(ModBlocks.darkForcestoneStairs, 7, x, y + 2, z + 1);
            this.setBlock(ModBlocks.darkForcestoneStairs, 6, x, y + 2, z - 1);
            this.setBlock(Blocks.field_150451_bX, 0, x, y + 3, z);
            if (foot) {
                this.setBlock(ModBlocks.darkForcestone, 0, x, y, z);
                if (rotation == 1) {
                    this.setBlock(ModBlocks.darkForcestoneStairs, 0, x - 1, y, z);
                } else {
                    this.setBlock(ModBlocks.darkForcestoneStairs, 1, x + 1, y, z);
                }
            } else {
                this.setBlock(ModBlocks.darkForcestone, 2, x, y, z);
            }
        }
    }

    private void generateCoffin(int x, int y, int z, int rotation, int coffinX, int coffinY, int coffinZ) {
        this.setBlock(ModBlocks.sithStoneCoffin, rotation, x, y, z);
        this.setBlock(ModBlocks.sithStoneCoffin, rotation + 8, x, y + 1, z);
        TileEntitySithStoneCoffin tile = (TileEntitySithStoneCoffin)this.worldObj.func_147438_o(this.xCoord + x, this.yCoord + y, this.zCoord + z);
        TileEntitySithCoffin tile1 = (TileEntitySithCoffin)this.worldObj.func_147438_o(this.xCoord + coffinX, this.yCoord + coffinY, this.zCoord + coffinZ);
        if (tile != null && tile1 != null) {
            tile.mainCoffin = tile1;
        }
    }
}

