/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.generator;

import cpw.mods.fml.common.IWorldGenerator;
import fiskfille.lightsabers.common.generator.structure.EnumStructure;
import fiskfille.lightsabers.common.generator.structure.Structure;
import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;

public class WorldGeneratorStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateOverworld(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
            }
        }
    }

    protected boolean canSpawnStructureAtCoords(World world, int x, int z, EnumStructure structure) {
        int k = x;
        int l = z;
        if (x < 0) {
            x -= structure.maxDistance - 1;
        }
        if (z < 0) {
            z -= structure.maxDistance - 1;
        }
        int i1 = x / structure.maxDistance;
        int j1 = z / structure.maxDistance;
        Random random = world.func_72843_D(i1, j1, 235785655);
        i1 *= structure.maxDistance;
        j1 *= structure.maxDistance;
        if (k == (i1 += random.nextInt(structure.maxDistance - structure.minDistance)) && l == (j1 += random.nextInt(structure.maxDistance - structure.minDistance))) {
            BiomeGenBase biome = world.func_72959_q().func_76935_a(k, l);
            for (BiomeGenBase biome1 : structure.biomeList) {
                if (biome != biome1) continue;
                return true;
            }
        }
        return false;
    }

    public void generateOverworld(World world, Random random, int x, int z) {
        WorldInfo info = world.func_72912_H();
        if (info.func_76067_t() != WorldType.field_77138_c && info.func_76089_r()) {
            Chunk chunk = world.func_72938_d(x, z);
            for (EnumStructure enumStructure : EnumStructure.values()) {
                if (!this.canSpawnStructureAtCoords(world, x, z, enumStructure)) continue;
                int y = Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                try {
                    Constructor<? extends Structure> c = enumStructure.structureClass.getConstructor(World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    Structure structure = c.newInstance(world, x, y, z);
                    structure.spawnStructure(random);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }
}

