/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.generator;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.IWorldGenerator;
import fiskfille.lightsabers.common.block.ModBlocks;
import fiskfille.lightsabers.common.generator.WorldGenCrystalCaveEntrance;
import fiskfille.lightsabers.common.helper.LightsaberColors;
import fiskfille.lightsabers.common.tileentity.TileEntityCrystal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGeneratorOres
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public boolean isCrystalCaveChunk(World world, int x, int z) {
        Random rand = new Random(world.func_72905_C() + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(33) == 0;
    }

    public boolean isCrystalCaveChunk(World world, Chunk chunk) {
        return this.isCrystalCaveChunk(world, chunk.field_76635_g, chunk.field_76647_h);
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        Chunk chunk;
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c && this.isCrystalCaveChunk(world, chunk = world.func_72938_d(chunkX, chunkZ)) && world.func_72807_a(chunkX, chunkZ) != BiomeGenBase.field_76771_b) {
            ArrayList airBlocks = Lists.newArrayList();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    int topBlock;
                    for (topBlock = 256; world.func_147439_a(chunkX + i, topBlock, chunkZ + j) == Blocks.field_150350_a && topBlock > 0; --topBlock) {
                    }
                    for (int y = 0; y < topBlock - 10; ++y) {
                        if (world.func_147439_a(chunkX + i, y, chunkZ + j) != Blocks.field_150350_a) continue;
                        airBlocks.add(new int[]{chunkX + i, y, chunkZ + j});
                    }
                }
            }
            if (airBlocks.size() > 1024) {
                int[] aint = (int[])airBlocks.get(random.nextInt(airBlocks.size()));
                int x = aint[0];
                int y = aint[1];
                int z = aint[2];
                int count = 0;
                while (y < world.func_72825_h(x, z)) {
                    if (count < 10 + random.nextInt(10)) {
                        ++y;
                    } else {
                        if (random.nextInt(3) == 0) {
                            x += (random.nextInt(3) - 1) * 2;
                        }
                        if (random.nextInt(9) == 0) {
                            ++y;
                        }
                        if (random.nextInt(3) == 0) {
                            z += (random.nextInt(3) - 1) * 2;
                        }
                    }
                    new WorldGenCrystalCaveEntrance(32).func_76484_a(world, random, x, y, z);
                    ++count;
                }
                int radius = 1;
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        this.generateCrystal(20, ModBlocks.lightsaberCrystal, 64, world, random, chunkX + i * 16, chunkZ + j * 16);
                    }
                }
            }
        }
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateOre(int veinsPerChunk, Block block, int veinSize, int minY, World world, Random random, int chunkX, int chunkZ) {
        for (int i = 0; i < veinsPerChunk; ++i) {
            int randPosX = chunkX + random.nextInt(16);
            int randPosY = random.nextInt(minY);
            int randPosZ = chunkZ + random.nextInt(16);
            new WorldGenMinable(block, veinSize).func_76484_a(world, random, randPosX, randPosY, randPosZ);
        }
    }

    public void generateCrystal(int veinsPerChunk, Block block, int minY, World world, Random random, int chunkX, int chunkZ) {
        for (int i = 0; i < veinsPerChunk; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = chunkX + random.nextInt(16);
            if (world.func_147439_a(randPosX, randPosY = random.nextInt(minY), randPosZ = chunkZ + random.nextInt(16)) != Blocks.field_150350_a) continue;
            if (world.func_147439_a(randPosX + 1, randPosY, randPosZ).func_149688_o() == Material.field_151576_e) {
                this.setCrystal(world, block, randPosX, randPosY, randPosZ, 2, random);
            } else if (world.func_147439_a(randPosX, randPosY, randPosZ + 1).func_149688_o() == Material.field_151576_e) {
                this.setCrystal(world, block, randPosX, randPosY, randPosZ, 4, random);
            } else if (world.func_147439_a(randPosX - 1, randPosY, randPosZ).func_149688_o() == Material.field_151576_e) {
                this.setCrystal(world, block, randPosX, randPosY, randPosZ, 1, random);
            } else if (world.func_147439_a(randPosX, randPosY, randPosZ - 1).func_149688_o() == Material.field_151576_e) {
                this.setCrystal(world, block, randPosX, randPosY, randPosZ, 3, random);
            }
            if (world.func_147439_a(randPosX, randPosY - 1, randPosZ).func_149688_o() == Material.field_151576_e) {
                this.setCrystal(world, block, randPosX, randPosY, randPosZ, 5, random);
            }
            if (world.func_147439_a(randPosX, randPosY + 1, randPosZ).func_149688_o() != Material.field_151576_e) continue;
            this.setCrystal(world, block, randPosX, randPosY, randPosZ, 6, random);
        }
    }

    public void setCrystal(World world, Block block, int x, int y, int z, int metadata, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<Integer, Integer> e : LightsaberColors.rarityMap.entrySet()) {
            if (e.getValue() == 3) continue;
            for (int i = 0; i <= 2 - e.getValue(); ++i) {
                list.add(e.getKey());
            }
        }
        world.func_147465_d(x, y, z, block, metadata, 2);
        TileEntityCrystal tile = (TileEntityCrystal)world.func_147438_o(x, y, z);
        int colorId = (Integer)list.get(rand.nextInt(list.size()));
        if (tile != null) {
            tile.colorId = colorId;
        }
    }
}

