/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.event;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fiskfille.lightsabers.common.config.ModConfig;
import fiskfille.lightsabers.common.entity.EntityLightsaber;
import fiskfille.lightsabers.common.item.ItemLightsaberBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class CommonEventHandlerDL {
    private Minecraft mc;
    private long nextUpdate;
    private ArrayList<EntityLightAdapter> trackedEntities;
    private Thread thread;
    private boolean threadRunning;

    public void load() {
        this.mc = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedEntities = new ArrayList();
        this.threadRunning = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent tick) {
        if (this.mc.field_71441_e != null && System.currentTimeMillis() > this.nextUpdate && !DynamicLights.globalLightsOff() && ModConfig.dynamicLightsEnabled) {
            this.nextUpdate = System.currentTimeMillis() + (long)ModConfig.dynamicLightsUpdateInterval;
            if (!this.threadRunning) {
                this.thread = new EntityListChecker(this.mc.field_71441_e.field_72996_f);
                this.thread.setPriority(1);
                this.thread.start();
                this.threadRunning = true;
            }
        }
    }

    private int getEntityEquipmentMaxLight(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            int light = this.getLightFromItemStack(((EntityLivingBase)entity).func_71124_b(0));
            for (int i = 1; i < entity.func_70035_c().length; ++i) {
                light = DynamicLights.maxLight((int)light, (int)this.getLightFromItemStack(entity.func_70035_c()[i]));
            }
            return light;
        }
        if (entity instanceof EntityLightsaber) {
            return 15;
        }
        return 0;
    }

    private int getLightFromItemStack(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemLightsaberBase && ItemLightsaberBase.isActive(itemstack)) {
            return 15;
        }
        return 0;
    }

    private class EntityLightAdapter
    implements IDynamicLightSource {
        private Entity entity;
        private int lightLevel = 0;
        private boolean enabled = false;

        public EntityLightAdapter(Entity e) {
            this.entity = e;
        }

        public void onTick() {
            this.lightLevel = CommonEventHandlerDL.this.getEntityEquipmentMaxLight(this.entity);
            if (!this.enabled && this.lightLevel > 0) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 1) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource((IDynamicLightSource)this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource((IDynamicLightSource)this);
            this.enabled = false;
        }

        public Entity getAttachmentEntity() {
            return this.entity;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List<Entity> input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList newList = Lists.newArrayList();
            for (Object object : this.list) {
                Entity entity = (Entity)object;
                if (!entity.func_70089_S() || CommonEventHandlerDL.this.getEntityEquipmentMaxLight(entity) <= 0) continue;
                boolean found = false;
                Iterator iter = CommonEventHandlerDL.this.trackedEntities.iterator();
                EntityLightAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityLightAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)entity)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityLightAdapter(entity);
                adapter.onTick();
                newList.add(adapter);
            }
            for (EntityLightAdapter adapter : CommonEventHandlerDL.this.trackedEntities) {
                adapter.onTick();
            }
            CommonEventHandlerDL.this.trackedEntities = newList;
            CommonEventHandlerDL.this.threadRunning = false;
        }
    }
}

