/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fiskfille.lightsabers.common.block.BlockBasic;
import fiskfille.lightsabers.common.helper.LightsaberColors;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import fiskfille.lightsabers.common.tileentity.TileEntityCrystal;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrystal
extends BlockBasic
implements ITileEntityProvider {
    private Random rand = new Random();

    public BlockCrystal() {
        super(Material.field_151592_s);
        this.func_149715_a(0.25f);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149778_k);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subBlocks) {
        for (int i = 0; i < LightsaberColors.getColors().length; ++i) {
            subBlocks.add(LightsaberHelper.createCrystal(i));
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149716_u() {
        return true;
    }

    private boolean func_150107_m(World world, int x, int y, int z) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        return block.canPlaceTorchOnTop(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) || this.func_150107_m(world, x, y - 1, z) || this.func_150107_m(world, x, y + 1, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int j1 = metadata;
        if (side == 0 && this.func_150107_m(world, x, y + 1, z)) {
            j1 = 6;
        }
        if (side == 1 && this.func_150107_m(world, x, y - 1, z)) {
            j1 = 5;
        }
        if (side == 2 && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
            j1 = 4;
        }
        if (side == 3 && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
            j1 = 3;
        }
        if (side == 4 && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
            j1 = 2;
        }
        if (side == 5 && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
            j1 = 1;
        }
        return j1;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (world.func_72805_g(x, y, z) == 0) {
            this.func_149726_b(world, x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0) {
            if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
                world.func_72921_c(x, y, z, 1, 2);
            } else if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
                world.func_72921_c(x, y, z, 2, 2);
            } else if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
                world.func_72921_c(x, y, z, 3, 2);
            } else if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
                world.func_72921_c(x, y, z, 4, 2);
            } else if (this.func_150107_m(world, x, y - 1, z)) {
                world.func_72921_c(x, y, z, 5, 2);
            } else if (this.func_150107_m(world, x, y + 1, z)) {
                world.func_72921_c(x, y, z, 6, 2);
            }
        }
        this.func_150109_e(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_150108_b(world, x, y, z, block);
    }

    protected boolean func_150108_b(World world, int x, int y, int z, Block block) {
        if (this.func_150109_e(world, x, y, z)) {
            int l = world.func_72805_g(x, y, z);
            boolean flag = false;
            if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true) && l == 1) {
                flag = true;
            }
            if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true) && l == 2) {
                flag = true;
            }
            if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true) && l == 3) {
                flag = true;
            }
            if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true) && l == 4) {
                flag = true;
            }
            if (!this.func_150107_m(world, x, y - 1, z) && l == 5) {
                flag = true;
            }
            if (!this.func_150107_m(world, x, y + 1, z) && l == 6) {
                flag = true;
            }
            if (flag) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean func_150109_e(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == this) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3, Vec3 vec31) {
        int l = world.func_72805_g(x, y, z);
        float f = 0.0625f;
        float width = f * 6.0f;
        float height = f * 6.0f;
        if (l == 1) {
            this.func_149676_a(0.0f, 0.5f - width / 2.0f, 0.5f - width / 2.0f, height, 0.5f + width / 2.0f, 0.5f + width / 2.0f);
        } else if (l == 2) {
            this.func_149676_a(1.0f - height, 0.5f - width / 2.0f, 0.5f - width / 2.0f, 1.0f, 0.5f + width / 2.0f, 0.5f + width / 2.0f);
        } else if (l == 3) {
            this.func_149676_a(0.5f - width / 2.0f, 0.5f - width / 2.0f, 0.0f, 0.5f + width / 2.0f, 0.5f + width / 2.0f, height);
        } else if (l == 4) {
            this.func_149676_a(0.5f - width / 2.0f, 0.5f - width / 2.0f, 1.0f - height, 0.5f + width / 2.0f, 0.5f + width / 2.0f, 1.0f);
        } else if (l == 5) {
            this.func_149676_a(0.5f - width / 2.0f, 0.0f, 0.5f - width / 2.0f, 0.5f + width / 2.0f, height, 0.5f + width / 2.0f);
        } else {
            this.func_149676_a(0.5f - width / 2.0f, 1.0f - height, 0.5f - width / 2.0f, 0.5f + width / 2.0f, 1.0f, 0.5f + width / 2.0f);
        }
        return super.func_149731_a(world, x, y, z, vec3, vec31);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityCrystal();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
        TileEntityCrystal tile = (TileEntityCrystal)world.func_147438_o(x, y, z);
        if (tile != null) {
            tile.setColor(LightsaberHelper.getCrystalColorId(itemstack));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityCrystal tile = (TileEntityCrystal)world.func_147438_o(x, y, z);
        if (tile != null) {
            return LightsaberHelper.createCrystal(tile.colorId);
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        TileEntityCrystal tile = (TileEntityCrystal)world.func_147438_o(x, y, z);
        if (tile != null && !player.field_71075_bZ.field_75098_d) {
            this.func_149642_a(world, x, y, z, LightsaberHelper.createCrystal(tile.colorId));
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            return true;
        }
        return false;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }
}

