/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.client.render.item;

import fiskfille.lightsabers.client.LightsaberAPIClient;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import fiskfille.lightsabers.common.lightsaber.Lightsaber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLightsaberPart
implements IItemRenderer {
    public Lightsaber.EnumPartType partType;

    public RenderLightsaberPart(Lightsaber.EnumPartType type) {
        this.partType = type;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        if (type == IItemRenderer.ItemRenderType.ENTITY) return true;
        if (type != IItemRenderer.ItemRenderType.INVENTORY) return false;
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Lightsaber lightsaber = LightsaberHelper.getLightsaberFromPart(item);
        if (lightsaber == null) {
            return;
        }
        ModelBase model = LightsaberAPIClient.getModelFor(lightsaber, this.partType);
        float height = this.partType == Lightsaber.EnumPartType.EMITTER ? lightsaber.getEmitter().height : (this.partType == Lightsaber.EnumPartType.SWITCH_SECTION ? lightsaber.getSwitchSection().height : (this.partType == Lightsaber.EnumPartType.BODY ? lightsaber.getBody().height : lightsaber.getPommel().height));
        float f = (height / 2.0f - (this.partType == Lightsaber.EnumPartType.BODY || this.partType == Lightsaber.EnumPartType.POMMEL ? height : 0.0f)) * 0.0625f;
        float scale = 1.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("lightsabers", "textures/models/lightsaber/" + this.partType.name().toLowerCase() + "_" + lightsaber.getName().toLowerCase().replace(' ', '_').replace("(", "").replace(")", "") + ".png"));
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)5.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.15f, (float)0.9f);
            GL11.glScalef((float)(scale /= 2.5f), (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.1f, (float)0.15f, (float)0.475f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(scale /= 2.5f), (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(scale /= 2.5f), (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
            GL11.glRotatef((float)-110.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.partType == Lightsaber.EnumPartType.POMMEL && height <= 4.0f) {
                scale = 2.0f;
            }
            while (height * scale > 20.0f) {
                scale -= 0.01f;
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
            model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
        }
    }
}

