/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.lightsabers.client.model;

import com.google.common.collect.Lists;
import fiskfille.lightsabers.common.config.ModConfig;
import fiskfille.lightsabers.common.helper.ALRenderHelper;
import fiskfille.lightsabers.common.helper.FocusingCrystals;
import fiskfille.lightsabers.common.helper.LightsaberHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ModelLightsaberBlade
extends ModelBase {
    public ModelRenderer blade;
    public int bladeLength;

    public ModelLightsaberBlade(int length) {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.blade = new ModelRenderer((ModelBase)this, 0, 0);
        this.blade.func_78789_a(-0.5f, (float)(-length), -0.5f, 1, length, 1);
        this.bladeLength = length;
    }

    public void renderInner(ItemStack stack) {
        int[] crystalds = LightsaberHelper.getFocusingCrystalIds(stack);
        ArrayList focusingCrystals = Lists.newArrayList();
        for (int id : crystalds) {
            focusingCrystals.add(FocusingCrystals.getFocusingCrystals()[id]);
        }
        if (focusingCrystals.contains("inverting_focusing_crystal")) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (focusingCrystals.contains("compressed_focusing_crystal")) {
            GL11.glScalef((float)0.6f, (float)1.0f, (float)0.6f);
        }
        if (focusingCrystals.contains("cracked_kyber_crystal")) {
            int ticks = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 100;
            float divider = 60.0f;
            Random rand = new Random(ticks * 1000);
            for (int i = 0; i < 4; ++i) {
                GL11.glPushMatrix();
                if (i != 0) {
                    GL11.glTranslatef((float)((rand.nextFloat() - 0.5f) / divider), (float)0.0f, (float)((rand.nextFloat() - 0.5f) / divider));
                    for (int j = 0; j < this.bladeLength; ++j) {
                        GL11.glPushMatrix();
                        GL11.glRotatef((float)rand.nextInt(360), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)(-0.012499999f + rand.nextFloat() * 0.0125f), (float)(0.0625f + rand.nextFloat() * (float)this.bladeLength * 0.0625f));
                        ALRenderHelper.drawTip(0.04f, 0.0f);
                        GL11.glPopMatrix();
                    }
                }
                if (!focusingCrystals.contains("fine_cut_focusing_crystal")) {
                    this.blade.func_78785_a(0.0625f);
                    GL11.glTranslatef((float)0.0f, (float)(-0.0625f * (0.5f + (float)this.bladeLength)), (float)0.03125f);
                    ALRenderHelper.drawTip(0.03125f, 0.125f);
                }
                GL11.glPopMatrix();
            }
        }
        if (focusingCrystals.contains("fine_cut_focusing_crystal")) {
            Tessellator tessellator = Tessellator.field_78398_a;
            float f = 0.0625f;
            float length = f * (float)this.bladeLength * 0.7f;
            float edge = f * 1.5f;
            float edgeAngle = -f * 1.5f;
            float length1 = f * (float)this.bladeLength * 0.3f;
            float edge1 = f / 2.0f;
            float tip = f * 1.5f;
            tessellator.func_78382_b();
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-length), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-length), (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-length), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-length), (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a(0.0, (double)edgeAngle, (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-f), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - length), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(0.0f - length), (double)edge);
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - length), (double)(f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(-length1 - length), (double)edge1);
            tessellator.func_78377_a(0.0, (double)(0.0f - length), (double)edge);
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(-f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a(0.0, (double)(-tip - f * (float)this.bladeLength), (double)(-f / 2.0f));
            tessellator.func_78377_a((double)(f / 2.0f), (double)(0.0f - f * (float)this.bladeLength), (double)(f / 2.0f));
            tessellator.func_78381_a();
            this.blade.func_78785_a(0.0625f);
        } else {
            this.blade.func_78785_a(0.0625f);
            GL11.glTranslatef((float)0.0f, (float)(-0.0625f * (0.5f + (float)this.bladeLength)), (float)0.03125f);
            ALRenderHelper.drawTip(0.03125f, 0.125f);
        }
    }

    public void renderOuter(ItemStack itemstack, float r, float g, float b, boolean flag) {
        int[] focusingCrystalIds = LightsaberHelper.getFocusingCrystalIds(itemstack);
        ArrayList focusingCrystals = Lists.newArrayList();
        for (int id : focusingCrystalIds) {
            focusingCrystals.add(FocusingCrystals.getFocusingCrystals()[id]);
        }
        int smooth = 10;
        float width = 0.6f;
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.1f;
        if (focusingCrystals.contains("compressed_focusing_crystal")) {
            width = 0.4f;
            smooth = 7;
            f3 = 0.07f;
        }
        if (focusingCrystals.contains("fine_cut_focusing_crystal")) {
            f *= 0.55f;
            f1 *= 0.925f;
            f2 *= 1.1f;
        }
        if (flag) {
            width *= ModConfig.renderGlobalMultiplier * ModConfig.renderWidthMultiplier;
            smooth = (int)((float)smooth * (ModConfig.renderGlobalMultiplier * ModConfig.renderSmoothingMultiplier));
        }
        int layerCount = 5 * smooth;
        for (int i = 0; i < layerCount; ++i) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)(f3 / (float)smooth * (flag ? ModConfig.renderGlobalMultiplier * ModConfig.renderOpacityMultiplier : 1.0f)));
            float scale = 1.0f + (float)i * (width / (float)smooth);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.blade.field_82906_o, (float)this.blade.field_82908_p, (float)this.blade.field_82907_q);
            GL11.glTranslatef((float)(this.blade.field_78800_c * 0.0625f), (float)(this.blade.field_78797_d * 0.0625f), (float)(this.blade.field_78798_e * 0.0625f));
            GL11.glScaled((double)(scale * f), (double)((1.0f - (float)i * (focusingCrystals.contains("fine_cut_focusing_crystal") ? 0.003f : 0.005f) + 0.2f) * f1), (double)(scale * f2));
            GL11.glTranslatef((float)(-this.blade.field_82906_o), (float)(-this.blade.field_82908_p), (float)(-this.blade.field_82907_q));
            GL11.glTranslatef((float)(-this.blade.field_78800_c * 0.0625f), (float)(-this.blade.field_78797_d * 0.0625f), (float)(-this.blade.field_78798_e * 0.0625f));
            GL11.glTranslatef((float)0.0f, (float)(-((float)i) / 400.0f + 0.06f), (float)0.0f);
            if (focusingCrystals.contains("fine_cut_focusing_crystal")) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.005f + (float)i * 1.0E-5f));
            }
            this.blade.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderCrossguardInner(ItemStack itemstack) {
        int[] aint = LightsaberHelper.getFocusingCrystalIds(itemstack);
        ArrayList list = Lists.newArrayList();
        for (int id : aint) {
            list.add(FocusingCrystals.getFocusingCrystals()[id]);
        }
        if (list.contains("fine_cut_focusing_crystal")) {
            GL11.glScalef((float)1.0f, (float)1.2f, (float)1.0f);
        }
        this.renderInner(itemstack);
    }

    public void renderCrossguardOuter(ItemStack itemstack, float r, float g, float b, boolean flag) {
        int[] aint = LightsaberHelper.getFocusingCrystalIds(itemstack);
        ArrayList list = Lists.newArrayList();
        for (int id : aint) {
            list.add(FocusingCrystals.getFocusingCrystals()[id]);
        }
        int smooth = 10;
        float width = 0.4f;
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.1f;
        if (list.contains("compressed_focusing_crystal")) {
            width = 0.2f;
            smooth = 7;
            f1 = 0.9f;
            f3 = 0.07f;
        }
        if (list.contains("fine_cut_focusing_crystal")) {
            f *= 0.55f;
            f1 *= 0.925f;
            f2 *= 1.3f;
        }
        if (flag) {
            width *= ModConfig.renderGlobalMultiplier * ModConfig.renderWidthMultiplier;
            smooth = (int)((float)smooth * (ModConfig.renderGlobalMultiplier * ModConfig.renderSmoothingMultiplier));
        }
        int i1 = 5 * smooth;
        for (int i = 0; i < i1; ++i) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)(f3 / (float)smooth * (flag ? ModConfig.renderGlobalMultiplier * ModConfig.renderOpacityMultiplier : 1.0f)));
            float scale = 1.0f + (float)i * (width / (float)smooth);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.blade.field_82906_o, (float)this.blade.field_82908_p, (float)this.blade.field_82907_q);
            GL11.glTranslatef((float)(this.blade.field_78800_c * 0.0625f), (float)(this.blade.field_78797_d * 0.0625f), (float)(this.blade.field_78798_e * 0.0625f));
            GL11.glScaled((double)(scale * f), (double)((1.0f - (float)i * 0.05f + 2.0f) * f1), (double)(scale * f2));
            GL11.glTranslatef((float)(-this.blade.field_82906_o), (float)(-this.blade.field_82908_p), (float)(-this.blade.field_82907_q));
            GL11.glTranslatef((float)(-this.blade.field_78800_c * 0.0625f), (float)(-this.blade.field_78797_d * 0.0625f), (float)(-this.blade.field_78798_e * 0.0625f));
            GL11.glTranslatef((float)0.0f, (float)(-((float)i) / 400.0f + 0.06f), (float)0.0f);
            if (list.contains("fine_cut_focusing_crystal")) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.005f + (float)i * 1.0E-5f));
            }
            this.blade.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

