/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerAdapterPluggable
extends PipePluggable
implements IEnergyHandler {
    private static final int MAX_POWER = 40;
    private IPipeTile container;

    @Override
    public void validate(IPipeTile pipe, ForgeDirection direction) {
        this.container = pipe;
    }

    @Override
    public void invalidate() {
        this.container = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftTransport.powerAdapterItem)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    @Override
    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableRenderer getRenderer() {
        return new PowerAdapterPluggableRenderer();
    }

    @Override
    public void writeData(ByteBuf data) {
    }

    @Override
    public void readData(ByteBuf data) {
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int maxR = Math.min(40, maxReceive);
        if (this.container != null && this.container.getPipe() instanceof IEnergyHandler) {
            int energyCanReceive = ((IEnergyHandler)((Object)this.container.getPipe())).receiveEnergy(from, maxR, true);
            if (!simulate) {
                return ((IEnergyHandler)((Object)this.container.getPipe())).receiveEnergy(from, energyCanReceive, false);
            }
            return energyCanReceive;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.container.getPipe() instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container.getPipe())).getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.container.getPipe() instanceof IEnergyHandler) {
            return ((IEnergyHandler)((Object)this.container.getPipe())).getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return false;
    }

    protected static final class PowerAdapterPluggableRenderer
    implements IPipePluggableRenderer {
        private float zFightOffset = 2.4414062E-4f;

        protected PowerAdapterPluggableRenderer() {
        }

        @Override
        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            if (renderPass != 0) {
                return;
            }
            float[][] zeroState = new float[3][2];
            IIcon[] icons = FakeBlock.INSTANCE.getTextureState().popArray();
            int bottom = side.ordinal();
            for (int i = 0; i < 6; ++i) {
                icons[i] = BuildCraftTransport.instance.pipeIconProvider.getIcon((i & 6) == (bottom & 6) ? PipeIconProvider.TYPE.PipePowerAdapterBottom.ordinal() : PipeIconProvider.TYPE.PipePowerAdapterSide.ordinal());
            }
            zeroState[0][0] = 0.1875f;
            zeroState[0][1] = 0.8125f;
            zeroState[1][0] = 0.0f;
            zeroState[1][1] = 0.1251f;
            zeroState[2][0] = 0.1875f;
            zeroState[2][1] = 0.8125f;
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            IIcon iIcon = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipePowerAdapterTop.ordinal());
            icons[bottom ^ 1] = iIcon;
            icons[bottom] = iIcon;
            zeroState[0][0] = 0.25f + this.zFightOffset;
            zeroState[0][1] = 0.75f - this.zFightOffset;
            zeroState[1][0] = 0.125f;
            zeroState[1][1] = 0.25f + this.zFightOffset;
            zeroState[2][0] = 0.25f + this.zFightOffset;
            zeroState[2][1] = 0.75f - this.zFightOffset;
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, side);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
            FakeBlock.INSTANCE.getTextureState().pushArray();
        }
    }
}

