/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.worldgen;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public final class OilPopulate {
    public static final OilPopulate INSTANCE = new OilPopulate();
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"BUILDCRAFT_OIL", (Class[])new Class[0], (Object[])new Object[0]);
    private static final byte LARGE_WELL_HEIGHT = 16;
    private static final byte MEDIUM_WELL_HEIGHT = 6;
    public final Set<Integer> excessiveBiomes = new HashSet<Integer>();
    public final Set<Integer> surfaceDepositBiomes = new HashSet<Integer>();
    public final Set<Integer> excludedBiomes = new HashSet<Integer>();

    private OilPopulate() {
    }

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Pre event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE);
        if (!doGen) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        this.generateOil(event.world, event.rand, event.chunkX, event.chunkZ);
    }

    public void generateOil(World world, Random rand, int chunkX, int chunkZ) {
        int lakeZ;
        int lakeY;
        int lakeX;
        Block block;
        int x = chunkX * 16 + 8 + rand.nextInt(16);
        int z = chunkZ * 16 + 8 + rand.nextInt(16);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (this.excludedBiomes.contains(biome.field_76756_M)) {
            return;
        }
        boolean oilBiome = this.surfaceDepositBiomes.contains(biome.field_76756_M);
        double bonus = oilBiome ? 3.0 : 1.0;
        bonus *= BuildCraftEnergy.oilWellScalar;
        if (this.excessiveBiomes.contains(biome.field_76756_M)) {
            bonus *= 30.0;
        } else if (BuildCraftCore.debugWorldgen) {
            bonus *= 20.0;
        }
        GenType type = GenType.NONE;
        if (rand.nextDouble() <= 4.0E-4 * bonus) {
            type = GenType.LARGE;
        } else if (rand.nextDouble() <= 0.001 * bonus) {
            type = GenType.MEDIUM;
        } else if (oilBiome && rand.nextDouble() <= 0.02 * bonus) {
            type = GenType.LAKE;
        }
        if (type == GenType.NONE) {
            return;
        }
        int groundLevel = this.getTopBlock(world, x, z);
        if (groundLevel < 5) {
            return;
        }
        double deviation = this.surfaceDeviation(world, x, groundLevel, z, 8);
        if (deviation > 0.45) {
            return;
        }
        if (type == GenType.LARGE || type == GenType.MEDIUM) {
            int y;
            int maxHeight;
            int wellX = x;
            int wellZ = z;
            int wellHeight = 6;
            if (type == GenType.LARGE) {
                wellHeight = 16;
            }
            if ((maxHeight = groundLevel + wellHeight) >= world.func_72800_K() - 1) {
                return;
            }
            int wellY = 20 + rand.nextInt(10);
            int radius = type == GenType.LARGE ? 8 + rand.nextInt(9) : 4 + rand.nextInt(4);
            int radiusSq = radius * radius;
            for (int poolX = -radius; poolX <= radius; ++poolX) {
                for (int poolY = -radius; poolY <= radius; ++poolY) {
                    for (int poolZ = -radius; poolZ <= radius; ++poolZ) {
                        int distance = poolX * poolX + poolY * poolY + poolZ * poolZ;
                        if (distance > radiusSq) continue;
                        world.func_147465_d(poolX + wellX, poolY + wellY, poolZ + wellZ, BuildCraftEnergy.blockOil, 0, distance == radiusSq ? 3 : 2);
                    }
                }
            }
            int lakeRadius = type == GenType.LARGE ? 25 + rand.nextInt(20) : 5 + rand.nextInt(10);
            this.generateSurfaceDeposit(world, rand, biome, wellX, groundLevel, wellZ, lakeRadius);
            boolean makeSpring = type == GenType.LARGE && BuildCraftEnergy.spawnOilSprings && BuildCraftCore.springBlock != null && (BuildCraftCore.debugWorldgen || rand.nextDouble() <= 0.25);
            int baseY = makeSpring ? 0 : wellY;
            if (makeSpring && world.func_147439_a(wellX, baseY, wellZ) == Blocks.field_150357_h) {
                world.func_147465_d(wellX, baseY, wellZ, BuildCraftCore.springBlock, 1, 3);
            }
            for (y = baseY + 1; y <= maxHeight; ++y) {
                world.func_147465_d(wellX, y, wellZ, BuildCraftEnergy.blockOil, 0, 3);
            }
            if (type == GenType.LARGE) {
                for (y = wellY; y <= maxHeight - wellHeight / 2; ++y) {
                    world.func_147465_d(wellX + 1, y, wellZ, BuildCraftEnergy.blockOil, 0, 3);
                    world.func_147465_d(wellX - 1, y, wellZ, BuildCraftEnergy.blockOil, 0, 3);
                    world.func_147465_d(wellX, y, wellZ + 1, BuildCraftEnergy.blockOil, 0, 3);
                    world.func_147465_d(wellX, y, wellZ - 1, BuildCraftEnergy.blockOil, 0, 3);
                }
            }
        } else if (type == GenType.LAKE && (block = world.func_147439_a(lakeX = x, lakeY = groundLevel, lakeZ = z)) == biome.field_76752_A) {
            this.generateSurfaceDeposit(world, rand, biome, lakeX, lakeY, lakeZ, 5 + rand.nextInt(10));
        }
    }

    public void generateSurfaceDeposit(World world, Random rand, int x, int y, int z, int radius) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        this.generateSurfaceDeposit(world, rand, biome, x, y, z, radius);
    }

    private void generateSurfaceDeposit(World world, Random rand, BiomeGenBase biome, int x, int y, int z, int radius) {
        int depth = rand.nextDouble() < 0.5 ? 1 : 2;
        this.setOilColumnForLake(world, biome, x, y, z, depth, 2);
        for (int w = 1; w <= radius; ++w) {
            float proba = (float)(radius - w + 4) / (float)(radius + 4);
            this.setOilWithProba(world, biome, rand, proba, x, y, z + w, depth);
            this.setOilWithProba(world, biome, rand, proba, x, y, z - w, depth);
            this.setOilWithProba(world, biome, rand, proba, x + w, y, z, depth);
            this.setOilWithProba(world, biome, rand, proba, x - w, y, z, depth);
            for (int i = 1; i <= w; ++i) {
                this.setOilWithProba(world, biome, rand, proba, x + i, y, z + w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + i, y, z - w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + w, y, z + i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - w, y, z + i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - i, y, z + w, depth);
                this.setOilWithProba(world, biome, rand, proba, x - i, y, z - w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + w, y, z - i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - w, y, z - i, depth);
            }
        }
        for (int dx = x - radius; dx <= x + radius; ++dx) {
            for (int dz = z - radius; dz <= z + radius; ++dz) {
                if (this.isOil(world, dx, y, dz) || !this.isOilSurrounded(world, dx, y, dz)) continue;
                this.setOilColumnForLake(world, biome, dx, y, dz, depth, 2);
            }
        }
    }

    private boolean isReplaceableFluid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return (block instanceof BlockStaticLiquid || block instanceof BlockFluidBase || block instanceof IFluidBlock) && block.func_149688_o() != Material.field_151587_i;
    }

    private boolean isOil(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == BuildCraftEnergy.blockOil;
    }

    private boolean isReplaceableForLake(World world, BiomeGenBase biome, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == biome.field_76753_B || block == biome.field_76752_A) {
            return true;
        }
        if (!block.func_149688_o().func_76230_c()) {
            return true;
        }
        if (block.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            return true;
        }
        if (block instanceof BlockFlower) {
            return true;
        }
        return !block.func_149662_c();
    }

    private boolean isOilAdjacent(World world, int x, int y, int z) {
        return this.isOil(world, x + 1, y, z) || this.isOil(world, x - 1, y, z) || this.isOil(world, x, y, z + 1) || this.isOil(world, x, y, z - 1);
    }

    private boolean isOilSurrounded(World world, int x, int y, int z) {
        return this.isOil(world, x + 1, y, z) && this.isOil(world, x - 1, y, z) && this.isOil(world, x, y, z + 1) && this.isOil(world, x, y, z - 1);
    }

    private void setOilWithProba(World world, BiomeGenBase biome, Random rand, float proba, int x, int y, int z, int depth) {
        if (rand.nextFloat() <= proba && !world.func_147437_c(x, y - depth - 1, z) && this.isOilAdjacent(world, x, y, z)) {
            this.setOilColumnForLake(world, biome, x, y, z, depth, 3);
        }
    }

    private void setOilColumnForLake(World world, BiomeGenBase biome, int x, int y, int z, int depth, int update) {
        if (this.isReplaceableForLake(world, biome, x, y + 1, z)) {
            if (!world.func_147437_c(x, y + 2, z)) {
                return;
            }
            if (!this.isReplaceableFluid(world, x, y, z) && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
                return;
            }
            world.func_147465_d(x, y, z, BuildCraftEnergy.blockOil, 0, update);
            if (!world.func_147437_c(x, y + 1, z)) {
                world.func_147465_d(x, y + 1, z, Blocks.field_150350_a, 0, update);
            }
            for (int d = 1; d <= depth - 1; ++d) {
                if (this.isReplaceableFluid(world, x, y - d, z) || !world.isSideSolid(x, y - d - 1, z, ForgeDirection.UP)) {
                    return;
                }
                world.func_147465_d(x, y - d, z, BuildCraftEnergy.blockOil, 0, 2);
            }
        }
    }

    private int getTopBlock(World world, int x, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        int trimmedX = x & 0xF;
        int trimmedZ = z & 0xF;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            Block block = chunk.func_150810_a(trimmedX, y, trimmedZ);
            if (block.isAir((IBlockAccess)world, x, y, z)) continue;
            if (block instanceof BlockStaticLiquid) {
                return y;
            }
            if (block instanceof BlockFluidBase) {
                return y;
            }
            if (block instanceof IFluidBlock) {
                return y;
            }
            if (!block.func_149688_o().func_76230_c() || block instanceof BlockFlower) continue;
            return y - 1;
        }
        return -1;
    }

    private double surfaceDeviation(World world, int x, int y, int z, int radius) {
        int diameter = radius * 2;
        double centralTendancy = y;
        double deviation = 0.0;
        for (int i = 0; i < diameter; ++i) {
            for (int k = 0; k < diameter; ++k) {
                deviation += (double)this.getTopBlock(world, x - radius + i, z - radius + k) - centralTendancy;
            }
        }
        return Math.abs(deviation / centralTendancy);
    }

    private static enum GenType {
        LARGE,
        MEDIUM,
        LAKE,
        NONE;

    }
}

