/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.api.items.IList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    protected StackHelper() {
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canStacksOrListsMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() instanceof IList) {
            IList list = (IList)stack1.func_77973_b();
            return list.matches(stack1, stack2);
        }
        if (stack2.func_77973_b() instanceof IList) {
            IList list = (IList)stack2.func_77973_b();
            return list.matches(stack2, stack1);
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int mergeStacks(ItemStack mergeSource, ItemStack mergeTarget, boolean doMerge) {
        if (!StackHelper.canStacksMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.func_77976_d() - mergeTarget.field_77994_a, mergeSource.field_77994_a);
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.field_77994_a += mergeCount;
        }
        return mergeCount;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary) {
        int[] idBase;
        if (StackHelper.isMatchingItem(base, comparison, true, false)) {
            return true;
        }
        if (oreDictionary && (idBase = OreDictionary.getOreIDs((ItemStack)base)).length > 0) {
            for (int id : idBase) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77960_j() != Short.MAX_VALUE && comparison.func_77960_j() != itemstack.func_77960_j()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCraftingEquivalent(int[] oreIDs, ItemStack comparison) {
        if (oreIDs.length > 0) {
            for (int id : oreIDs) {
                for (ItemStack itemstack : OreDictionary.getOres((String)OreDictionary.getOreName((int)id))) {
                    if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77960_j() != Short.MAX_VALUE && comparison.func_77960_j() != itemstack.func_77960_j()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMatchingItemOrList(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() instanceof IList) {
            IList list = (IList)a.func_77973_b();
            return list.matches(a, b);
        }
        if (b.func_77973_b() instanceof IList) {
            IList list = (IList)b.func_77973_b();
            return list.matches(b, a);
        }
        return StackHelper.isMatchingItem(a, b, true, false);
    }

    public static boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        return StackHelper.isMatchingItem(base, comparison, true, true);
    }

    public static boolean isEqualItem(ItemStack a, ItemStack b) {
        if (StackHelper.isMatchingItem(a, b, false, true)) {
            return StackHelper.isWildcard(a) || StackHelper.isWildcard(b) || a.func_77960_j() == b.func_77960_j();
        }
        return false;
    }

    public static boolean isMatchingItem(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchDamage && a.func_77981_g() && !StackHelper.isWildcard(a) && !StackHelper.isWildcard(b) && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return !matchNBT || a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isWildcard(ItemStack stack) {
        return StackHelper.isWildcard(stack.func_77960_j());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }
}

