/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.pressure.blocks.tank.blocks;

import java.util.Locale;
import java.util.NoSuchElementException;
import net.bdew.lib.data.DataSlotTank;
import net.bdew.lib.multiblock.data.DataSlotOutputConfig;
import net.bdew.lib.multiblock.data.DataSlotOutputConfig$;
import net.bdew.lib.multiblock.data.OutputConfig;
import net.bdew.lib.multiblock.data.OutputConfigFluid;
import net.bdew.lib.multiblock.data.OutputConfigRSControllable;
import net.bdew.lib.multiblock.data.RSMode$;
import net.bdew.pressure.blocks.tank.blocks.TileDataPort;
import net.bdew.pressure.blocks.tank.controller.TileTankController;
import net.bdew.pressure.compat.computers.CallContext;
import net.bdew.pressure.compat.computers.POption;
import net.bdew.pressure.compat.computers.PString$;
import net.bdew.pressure.compat.computers.Result;
import net.bdew.pressure.compat.computers.Result$;
import net.bdew.pressure.compat.computers.Result$Null$;
import net.bdew.pressure.compat.computers.TileCommandHandler;
import net.bdew.pressure.misc.CountedDataSlotTank;
import net.bdew.pressure.misc.FluidMapHelpers$;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class DataPortCommands$
extends TileCommandHandler<TileDataPort> {
    public static final DataPortCommands$ MODULE$;
    private final Map<String, Object> outputNames;

    static {
        new DataPortCommands$();
    }

    public Map<String, Object> outputNames() {
        return this.outputNames;
    }

    public TileTankController getCore(CallContext<TileDataPort> ctx) {
        return (TileTankController)ctx.tile().getCore().getOrElse((Function0)new Serializable(){

            public final Nothing$ apply() {
                return DataPortCommands$.MODULE$.err("Not connected to tank");
            }
        });
    }

    private DataPortCommands$() {
        MODULE$ = this;
        this.outputNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"red"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"green"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blue"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yellow"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cyan"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"purple"), (Object)BoxesRunTime.boxToInteger((int)5))}));
        this.command("isConnected", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                return Result$.MODULE$.resBoolean(ctx.tile().getCore().isDefined());
            }
        });
        this.command("getCapacity", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                return Result$.MODULE$.resInt(DataPortCommands$.MODULE$.getCore(ctx).tank().getCapacity());
            }
        });
        this.command("hasFluid", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                DataSlotTank tank = DataPortCommands$.MODULE$.getCore(ctx).tank();
                return Result$.MODULE$.resBoolean(tank.getFluid() != null && tank.getFluid().amount > 0);
            }
        });
        this.command("getFluid", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                FluidStack fluid = DataPortCommands$.MODULE$.getCore(ctx).tank().getFluid();
                return fluid != null && fluid.getFluid() != null && fluid.amount > 0 ? Result$.MODULE$.Map((Seq<Tuple2<String, Result>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Result$.MODULE$.resString(fluid.getFluid().getName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)Result$.MODULE$.resInt(fluid.amount))})) : Result$Null$.MODULE$;
            }
        });
        this.command("getOutputs", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                DataSlotOutputConfig configs = DataPortCommands$.MODULE$.getCore(ctx).outputConfig();
                return Result$.MODULE$.resMap((Map<String, Result>)((Map)DataPortCommands$.MODULE$.outputNames().withFilter((Function1)new Serializable(this){

                    public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                        Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).map((Function1)new Serializable(this, configs){
                    private final DataSlotOutputConfig configs$1;

                    public final Tuple2<String, Result> apply(Tuple2<String, Object> x$1) {
                        Tuple2<String, Object> tuple2 = x$1;
                        if (tuple2 != null) {
                            Result result;
                            Some some;
                            OutputConfig x;
                            String oName = (String)tuple2._1();
                            int oNum = tuple2._2$mcI$sp();
                            Object object = Predef$.MODULE$.ArrowAssoc((Object)oName);
                            Option option = DataSlotOutputConfig$.MODULE$.dataSlotOutputConfig2map(this.configs$1).get((Object)BoxesRunTime.boxToInteger((int)oNum));
                            if (option instanceof Some && (x = (OutputConfig)(some = (Some)option).x()) instanceof OutputConfigFluid) {
                                OutputConfigFluid outputConfigFluid = (OutputConfigFluid)x;
                                result = Result$.MODULE$.Map((Seq<Tuple2<String, Result>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)Result$.MODULE$.resString("fluid")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)Result$.MODULE$.resString(outputConfigFluid.rsMode().toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"average"), (Object)Result$.MODULE$.resDouble(outputConfigFluid.avg()))}));
                            } else {
                                result = None$.MODULE$.equals(option) ? Result$.MODULE$.Map((Seq<Tuple2<String, Result>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)Result$.MODULE$.resString("unconnected"))})) : Result$.MODULE$.Map((Seq<Tuple2<String, Result>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)Result$.MODULE$.resString("unknown"))}));
                            }
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)result);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.configs$1 = configs$1;
                    }
                }, Map$.MODULE$.canBuildFrom())));
            }
        });
        this.command("setOutputMode", this.command$default$2(), new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Result apply(CallContext<TileDataPort> ctx) {
                Enumeration.Value newMode;
                Tuple2 tuple22;
                Tuple2<String, String> tuple2 = ctx.params(PString$.MODULE$, PString$.MODULE$);
                if (tuple2 == null) throw new MatchError(tuple2);
                String oName = (String)tuple2._1();
                String mode = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)oName, (Object)mode);
                String oName2 = (String)tuple23._1();
                String mode2 = (String)tuple23._2();
                int oNum = BoxesRunTime.unboxToInt((Object)DataPortCommands$.MODULE$.outputNames().getOrElse((Object)oName2.toLowerCase(Locale.US), (Function0)new Serializable(this){

                    public final Nothing$ apply() {
                        return DataPortCommands$.MODULE$.err("Invalid output name");
                    }
                }));
                try {
                    newMode = RSMode$.MODULE$.withName(mode2.toUpperCase(Locale.US));
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw DataPortCommands$.MODULE$.err("Invalid output mode");
                }
                Option option = DataSlotOutputConfig$.MODULE$.dataSlotOutputConfig2map(DataPortCommands$.MODULE$.getCore(ctx).outputConfig()).get((Object)BoxesRunTime.boxToInteger((int)oNum));
                if (!(option instanceof Some)) throw DataPortCommands$.MODULE$.err("Unable to set output state");
                Some some = (Some)option;
                OutputConfig x = (OutputConfig)some.x();
                if (!(x instanceof OutputConfigRSControllable)) throw DataPortCommands$.MODULE$.err("Unable to set output state");
                OutputConfigRSControllable outputConfigRSControllable = (OutputConfigRSControllable)x;
                outputConfigRSControllable.rsMode_$eq(newMode);
                DataPortCommands$.MODULE$.getCore(ctx).outputConfig().updated();
                return Result$.MODULE$.resBoolean(true);
            }
        });
        this.command("getFilter", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                return (Result)DataPortCommands$.MODULE$.getCore(ctx).getFluidFilter().map((Function1)new Serializable(this){

                    public final Result apply(Fluid x) {
                        return Result$.MODULE$.apply(Result$.MODULE$.resString(x.getName()));
                    }
                }).getOrElse((Function0)new Serializable(this){

                    public final Result$Null$ apply() {
                        return Result$Null$.MODULE$;
                    }
                });
            }
        });
        this.command("setFilter", this.command$default$2(), new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                Option option;
                block5: {
                    Result result;
                    block4: {
                        block2: {
                            block3: {
                                option = (Option)ctx.params(new POption<String>(PString$.MODULE$));
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String s = (String)some.x();
                                if (!FluidRegistry.isFluidRegistered((String)s)) break block3;
                                DataPortCommands$.MODULE$.getCore(ctx).setFluidFilter(FluidRegistry.getFluid((String)s));
                                result = Result$.MODULE$.resBoolean(true);
                                break block4;
                            }
                            throw DataPortCommands$.MODULE$.err("Unknown fluid");
                        }
                        if (!None$.MODULE$.equals(option)) break block5;
                        DataPortCommands$.MODULE$.getCore(ctx).clearFluidFilter();
                        result = Result$.MODULE$.resBoolean(true);
                    }
                    return result;
                }
                throw new MatchError((Object)option);
            }
        });
        this.command("getCountsIn", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                return FluidMapHelpers$.MODULE$.fluidPairsToResult(((CountedDataSlotTank)DataPortCommands$.MODULE$.getCore(ctx).tank()).fluidIn().values(), "count", new Serializable(this){

                    public final Result apply(int v) {
                        return Result$.MODULE$.resInt(v);
                    }
                });
            }
        });
        this.command("getCountsOut", true, new Serializable(){

            public final Result apply(CallContext<TileDataPort> ctx) {
                return FluidMapHelpers$.MODULE$.fluidPairsToResult(((CountedDataSlotTank)DataPortCommands$.MODULE$.getCore(ctx).tank()).fluidOut().values(), "count", new Serializable(this){

                    public final Result apply(int v) {
                        return Result$.MODULE$.resInt(v);
                    }
                });
            }
        });
    }
}

