/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.ElectriCraft.Auxiliary.ConversionTile;
import Reika.ElectriCraft.Base.ElectricalReceiver;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.API.Power.PowerTracker;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMotor
extends ElectricalReceiver
implements Screwdriverable,
ShaftPowerEmitter,
ConversionTile,
NBTMachine,
PowerSourceTracker,
ShaftMerger {
    private static final int soundtime = (int)((float)EngineType.DC.getSoundLength() * 2.04f);
    private StepTimer soundTimer = new StepTimer(soundtime);
    protected int omega;
    protected int torque;
    protected long power;
    protected int iotick;
    private ForgeDirection facing;
    private int maxAmp = 1;
    private float sourceSize;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntity tg;
        super.updateEntity(world, x, y, z, meta);
        if (this.iotick > 0) {
            this.iotick -= 8;
        }
        if (!world.field_72995_K && this.network != null) {
            this.torque = this.getEffectiveCurrent(world, x, y, z) * 8;
            this.omega = this.network.getTerminalVoltage(this) / 8;
        }
        this.power = (long)this.omega * (long)this.torque;
        if (this.power > 0L) {
            this.soundTimer.update();
            if (this.soundTimer.checkCap()) {
                SoundRegistry.ELECTRIC.playSoundAtBlock(world, x, y, z, this.getSoundVolume(world, x, y, z), 0.333f);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
        }
        if ((tg = this.getAdjacentTileEntity(this.getFacing().getOpposite())) instanceof ShaftPowerReceiver) {
            ShaftPowerReceiver rec = (ShaftPowerReceiver)tg;
            rec.setOmega(this.omega);
            rec.setTorque(this.torque);
            rec.setPower(this.power);
        }
    }

    @Override
    public void onNetworkChanged() {
        this.sourceSize = Math.max(this.network.getNumberSourcesPer(this), (float)(this.getPowerSources(this, null).size() / this.network.getNumberSinks()));
    }

    private int getEffectiveCurrent(World world, int x, int y, int z) {
        int in = this.network.getTerminalCurrent(this);
        float f = Math.min(1.0f, (float)this.maxAmp / this.sourceSize);
        if (this.sourceSize > (float)this.maxAmp && in > 0 && rand.nextInt(10) == 0) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.PARTICLE.ordinal(), (TileEntity)this, (int)ReikaParticleHelper.SMOKE.ordinal(), (int)1);
        }
        return (int)((float)in * f);
    }

    public boolean upgrade(ItemStack is) {
        boolean flag = false;
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.redgoldingot) && this.maxAmp < 2) {
            this.maxAmp = 2;
            flag = true;
        } else if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.tungsteningot) && this.maxAmp < 4) {
            this.maxAmp = 4;
            flag = true;
        }
        if (flag && this.network != null) {
            this.network.updateWires();
        }
        return flag;
    }

    private float getSoundVolume(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150325_L && world.func_147439_a(x, y + 1, z) == Blocks.field_150325_L) {
            return 0.1f;
        }
        ForgeDirection dir = this.getFacing();
        ForgeDirection dir2 = dir.getOpposite();
        for (int i = 0; i < 6; ++i) {
            int dz;
            int dy;
            int dx;
            Block id;
            ForgeDirection side = this.dirs[i];
            if (side == dir || side == dir2 || side == ForgeDirection.DOWN || (id = world.func_147439_a(dx = x + side.offsetX, dy = y + side.offsetY, dz = z + side.offsetZ)) == Blocks.field_150325_L) continue;
            return 0.36f;
        }
        return 0.1f;
    }

    @Override
    public final ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    public final int getOmega() {
        return this.omega;
    }

    public final int getTorque() {
        return this.torque;
    }

    public final long getPower() {
        return this.power;
    }

    public final int getIORenderAlpha() {
        return this.iotick;
    }

    public final void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.omega = NBT.func_74762_e("omg");
        this.torque = NBT.func_74762_e("tq");
        this.power = NBT.func_74763_f("pwr");
        this.maxAmp = NBT.func_74762_e("amp");
        this.iotick = NBT.func_74762_e("io");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74768_a("omg", this.omega);
        NBT.func_74768_a("tq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74768_a("amp", this.maxAmp);
        NBT.func_74768_a("io", this.iotick);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.MOTOR;
    }

    @Override
    public boolean canNetworkOnSide(ForgeDirection dir) {
        return dir == this.getFacing();
    }

    public boolean canWriteTo(ForgeDirection from) {
        ForgeDirection dir = this.getFacing().getOpposite();
        return dir == from;
    }

    public boolean isEmitting() {
        return true;
    }

    @Override
    public boolean canReceivePowerFromSide(ForgeDirection dir) {
        return this.canNetworkOnSide(dir);
    }

    @Override
    public boolean canReceivePower() {
        return true;
    }

    public int getEmittingX() {
        return this.field_145851_c + this.getFacing().getOpposite().offsetX;
    }

    public int getEmittingY() {
        return this.field_145848_d + this.getFacing().getOpposite().offsetY;
    }

    public int getEmittingZ() {
        return this.field_145849_e + this.getFacing().getOpposite().offsetZ;
    }

    public long getMaxPower() {
        return this.power;
    }

    public long getCurrentPower() {
        return this.power;
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.incrementFacing();
        return true;
    }

    protected void incrementFacing() {
        int o = this.getFacing().ordinal();
        if (o == 5) {
            this.setFacing(this.dirs[2]);
        } else {
            this.setFacing(this.dirs[o + 1]);
        }
        this.rebuildNetwork();
    }

    public NBTTagCompound getTagsToWriteToStack() {
        if (this.maxAmp > 1) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("amp", this.maxAmp);
            return nbt;
        }
        return null;
    }

    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        if (NBT != null && NBT.func_74764_b("amp")) {
            this.maxAmp = NBT.func_74762_e("amp");
        }
    }

    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        NBTTagCompound NBT = new NBTTagCompound();
        NBT.func_74768_a("amp", 4);
        li.add(NBT);
        return li;
    }

    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        ArrayList<String> li = new ArrayList<String>();
        if (NBT != null && NBT.func_74764_b("amp")) {
            int amp = NBT.func_74762_e("amp");
            li.add(String.format("Contains a %dx amplifier", amp));
        }
        return li;
    }

    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return this.network != null ? this.network.getInputSources(io, caller) : new PowerSourceList();
    }

    public int getIoOffsetX() {
        return 0;
    }

    public int getIoOffsetY() {
        return 0;
    }

    public int getIoOffsetZ() {
        return 0;
    }

    public void onPowerLooped(PowerTracker pwr) {
        if (this.power > 0L) {
            this.fail();
        }
    }

    public void fail() {
        this.delete();
    }
}

