/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.ElectriCraft.Base.TileEntityWireComponent;
import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Items.ItemWirePlacer;
import Reika.ElectriCraft.Registry.ElectriBlocks;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.WireType;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityEUBattery;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityEUCable;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityEUSplitter;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityRFBattery;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityRFCable;
import Reika.ElectriCraft.TileEntities.TileEntityBattery;
import Reika.ElectriCraft.TileEntities.TileEntityFuse;
import Reika.ElectriCraft.TileEntities.TileEntityGenerator;
import Reika.ElectriCraft.TileEntities.TileEntityMeter;
import Reika.ElectriCraft.TileEntities.TileEntityMotor;
import Reika.ElectriCraft.TileEntities.TileEntityRelay;
import Reika.ElectriCraft.TileEntities.TileEntityResistor;
import Reika.ElectriCraft.TileEntities.TileEntityTransformer;
import Reika.ElectriCraft.TileEntities.TileEntityWire;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum ElectriTiles implements TileEnum
{
    WIRE("electri.wire", ElectriBlocks.WIRE, TileEntityWire.class, 0, "RenderWire"),
    GENERATOR("machine.electrigenerator", ElectriBlocks.MACHINE, TileEntityGenerator.class, 0, "RenderGenerator"),
    MOTOR("machine.electrimotor", ElectriBlocks.MACHINE, TileEntityMotor.class, 1, "RenderMotor"),
    RESISTOR("machine.electriresistor", ElectriBlocks.MACHINE, TileEntityResistor.class, 2, "RenderResistor"),
    RELAY("machine.electrirelay", ElectriBlocks.MACHINE, TileEntityRelay.class, 3, "RenderRelay"),
    BATTERY("machine.electribattery", ElectriBlocks.BATTERY, TileEntityBattery.class, 4),
    CABLE("machine.rfcable", ElectriBlocks.CABLE, TileEntityRFCable.class, 0, "RenderCable"),
    METER("machine.wiremeter", ElectriBlocks.MACHINE, TileEntityMeter.class, 4, "RenderElectricMeter"),
    RFBATTERY("machine.rfbattery", ElectriBlocks.RFBATTERY, TileEntityRFBattery.class, 0, "RenderModBattery"),
    TRANSFORMER("machine.transformer", ElectriBlocks.MACHINE, TileEntityTransformer.class, 5, "RenderTransformer"),
    EUSPLIT("machine.eusplit", ElectriBlocks.EUSPLIT, TileEntityEUSplitter.class, 0),
    EUCABLE("machine.eucable", ElectriBlocks.EUCABLE, TileEntityEUCable.class, 0, "RenderCable"),
    EUBATTERY("machine.eubattery", ElectriBlocks.EUBATTERY, TileEntityEUBattery.class, 0, "RenderModBattery"),
    FUSE("machine.fuse", ElectriBlocks.MACHINE, TileEntityFuse.class, 6, "RenderFuse");

    private String name;
    private final Class teClass;
    private int meta;
    private String render;
    private final ElectriBlocks blockInstance;
    private TileEntity renderInstance;
    private static final BlockMap<ElectriTiles> machineMappings;
    public static final ElectriTiles[] TEList;

    private ElectriTiles(String n2, ElectriBlocks block, Class<? extends TileEntity> tile, int m) {
        this(n2, block, tile, m, null);
    }

    private ElectriTiles(String n2, ElectriBlocks block, Class<? extends TileEntity> tile, int m, String r) {
        this.teClass = tile;
        this.name = n2;
        this.render = r;
        this.meta = m;
        this.blockInstance = block;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public Class getTEClass() {
        return this.teClass;
    }

    public static ArrayList<ElectriTiles> getTilesOfBlock(ElectriBlocks b) {
        ArrayList<ElectriTiles> li = new ArrayList<ElectriTiles>();
        for (int i = 0; i < TEList.length; ++i) {
            if (ElectriTiles.TEList[i].blockInstance != b) continue;
            li.add(TEList[i]);
        }
        return li;
    }

    public static TileEntity createTEFromIDAndMetadata(Block id, int meta) {
        if (id == ElectriBlocks.WIRE.getBlockInstance()) {
            return new TileEntityWire();
        }
        ElectriTiles index = ElectriTiles.getMachineFromIDandMetadata(id, meta);
        if (index == null) {
            ElectriCraft.logger.logError((Object)("ID " + id + " and metadata " + meta + " are not a valid machine identification pair!"));
            return null;
        }
        Class TEClass = index.teClass;
        try {
            return (TileEntity)TEClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ElectriCraft.instance, "ID " + id + " and Metadata " + meta + " failed to instantiate its TileEntity of " + TEClass);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ElectriCraft.instance, "ID " + id + " and Metadata " + meta + " failed illegally accessed its TileEntity of " + TEClass);
        }
    }

    public static ElectriTiles getMachineFromIDandMetadata(Block id, int meta) {
        return (ElectriTiles)((Object)machineMappings.get(id, meta));
    }

    public boolean isAvailableInCreativeInventory() {
        if (this == CABLE || this == RFBATTERY) {
            return PowerTypes.RF.isLoaded();
        }
        if (this == EUCABLE || this == EUBATTERY) {
            return PowerTypes.EU.isLoaded();
        }
        return true;
    }

    public boolean hasCustomItem() {
        return this == WIRE || this == BATTERY || this == RFBATTERY || this == EUBATTERY;
    }

    public boolean isWiring() {
        return this == WIRE || this == CABLE;
    }

    public static ElectriTiles getTE(IBlockAccess iba, int x, int y, int z) {
        Block id = iba.func_147439_a(x, y, z);
        if (id == ElectriBlocks.WIRE.getBlockInstance()) {
            return WIRE;
        }
        int meta = iba.func_72805_g(x, y, z);
        return ElectriTiles.getMachineFromIDandMetadata(id, meta);
    }

    public ItemStack getCraftedProduct(TileEntity te) {
        if (this == WIRE) {
            ItemStack is;
            TileEntityWire tw = (TileEntityWire)te;
            ItemStack itemStack = is = tw.insulated ? tw.getWireType().getCraftedInsulatedProduct() : tw.getWireType().getCraftedProduct();
            if (tw.getWireType() == WireType.SUPERCONDUCTOR) {
                is = ((ItemWirePlacer)is.func_77973_b()).getFilledSuperconductor(tw.insulated);
            }
            return is;
        }
        if (this == BATTERY) {
            return ((TileEntityBattery)te).getBatteryType().getCraftedProduct();
        }
        return this.getCraftedProduct();
    }

    public ItemStack getCraftedProduct() {
        if (this == WIRE) {
            return new ItemStack(ElectriItems.WIRE.getItemInstance());
        }
        if (this == BATTERY) {
            return new ItemStack(ElectriItems.BATTERY.getItemInstance());
        }
        if (this == RFBATTERY) {
            return new ItemStack(ElectriItems.RFBATTERY.getItemInstance());
        }
        if (this == EUBATTERY) {
            return new ItemStack(ElectriItems.EUBATTERY.getItemInstance());
        }
        return new ItemStack(ElectriItems.PLACER.getItemInstance(), 1, this.ordinal());
    }

    public TileEntity createTEInstanceForRender() {
        if (this.renderInstance == null) {
            try {
                this.renderInstance = (TileEntity)this.teClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ElectriCraft.instance, "Could not create TE instance to render " + (Object)((Object)this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ElectriCraft.instance, "Could not create TE instance to render " + (Object)((Object)this));
            }
        }
        return this.renderInstance;
    }

    public boolean hasRender() {
        return this.render != null;
    }

    public String getRenderer() {
        if (!this.hasRender()) {
            throw new RuntimeException("Machine " + this.name + " has no render to call!");
        }
        return "Reika.ElectriCraft.Renders." + this.render;
    }

    public Block getBlock() {
        return this.getBlockInstance();
    }

    public Block getBlockInstance() {
        return this.blockInstance.getBlockInstance();
    }

    public int getBlockMetadata() {
        return this.meta;
    }

    public boolean renderInPass1() {
        switch (this) {
            case TRANSFORMER: {
                return true;
            }
        }
        return false;
    }

    public boolean isDummiedOut() {
        if (DragonAPICore.isReikasComputer()) {
            return false;
        }
        return this == EUSPLIT && !PowerTypes.EU.isLoaded();
    }

    public void addRecipe(IRecipe ir) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(ir, RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addRecipe(ItemStack is, Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(is, RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addCrafting(Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(this.getCraftedProduct(), RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(), (Object[])obj);
            }
        }
    }

    public void addSizedOreCrafting(int size, Object ... obj) {
        ItemStack is = this.getCraftedProduct();
        ShapedOreRecipe ir = new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)size), obj);
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addSizedOreNBTCrafting(int size, NBTTagCompound tag, Object ... obj) {
        ItemStack is = this.getCraftedProduct();
        is.field_77990_d = (NBTTagCompound)tag.func_74737_b();
        ShapedOreRecipe ir = new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)size), obj);
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addOreCrafting(Object ... obj) {
        ItemStack is = this.getCraftedProduct();
        ShapedOreRecipe ir = new ShapedOreRecipe(is, obj);
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)ir, RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addSizedCrafting(int num, Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), (Object[])obj);
            }
        }
    }

    public static void loadMappings() {
        for (int i = 0; i < TEList.length; ++i) {
            ElectriTiles r = TEList[i];
            Block id = r.getBlock();
            int meta = r.getBlockMetadata();
            machineMappings.put(id, meta, (Object)r);
        }
    }

    public String getPlaceSound() {
        switch (this) {
            case WIRE: 
            case CABLE: {
                return "step.cloth";
            }
        }
        return "step.stone";
    }

    public boolean isSpecialWiringPiece() {
        return TileEntityWireComponent.class.isAssignableFrom(this.teClass);
    }

    public boolean isWiringPiece() {
        return WiringTile.class.isAssignableFrom(this.teClass);
    }

    public static ElectriTiles getMachine(ItemStack item) {
        if (item.func_77973_b() == ElectriItems.WIRE.getItemInstance()) {
            return WIRE;
        }
        if (item.func_77973_b() == ElectriItems.BATTERY.getItemInstance()) {
            return BATTERY;
        }
        if (item.func_77973_b() == ElectriItems.RFBATTERY.getItemInstance()) {
            return RFBATTERY;
        }
        if (item.func_77973_b() == ElectriItems.EUBATTERY.getItemInstance()) {
            return EUBATTERY;
        }
        return TEList[item.func_77960_j()];
    }

    public boolean hasNBTVariants() {
        return NBTMachine.class.isAssignableFrom(this.teClass);
    }

    static {
        machineMappings = new BlockMap();
        TEList = ElectriTiles.values();
    }
}

