/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum BatteryType {
    REDSTONE(20, 256, 32),
    GLOWSTONE(24, 512, 64),
    LAPIS(28, 2048, 128),
    ENDER(33, 4096, 256),
    DIAMOND(40, 16384, 1024),
    STAR(48, 65536, 4096);

    public final long maxCapacity;
    public final int outputVoltage;
    public final int outputCurrent;
    private IIcon icon;
    public static final BatteryType[] batteryList;

    private BatteryType(int cap, int v, int a) {
        this.maxCapacity = ReikaMathLibrary.longpow((int)2, (int)cap);
        this.outputCurrent = a;
        this.outputVoltage = v;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("battery." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public String getFormattedCapacity() {
        double base = ReikaMathLibrary.getThousandBase((double)this.maxCapacity);
        String exp = ReikaEngLibrary.getSIPrefix((double)this.maxCapacity);
        return String.format("%.3f%sJ", base, exp);
    }

    public void addCrafting() {
        ItemStack is = this.getCraftedProduct();
        ItemStack in = ElectriItems.CRYSTAL.getStackOfMetadata(this.ordinal());
        Object[] obj = new Object[]{"ScS", "WCW", "SPS", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('c'), this.getTopMaterial(), Character.valueOf('C'), in, Character.valueOf('P'), this.getBottomMaterial(), Character.valueOf('S'), ItemStacks.steelingot};
        ShapedOreRecipe ir = new ShapedOreRecipe(is, obj);
        WorktableRecipes.getInstance().addRecipe((IRecipe)ir, RecipeHandler.RecipeLevel.CORE);
        if (ConfigRegistry.TABLEMACHINES.getState()) {
            GameRegistry.addRecipe((IRecipe)ir);
        }
    }

    private Object getBottomMaterial() {
        switch (this) {
            case STAR: {
                return ItemStacks.bedingot;
            }
            case DIAMOND: {
                return ItemStacks.tungsteningot;
            }
        }
        return ItemStacks.basepanel;
    }

    private Object getTopMaterial() {
        switch (this) {
            case GLOWSTONE: 
            case LAPIS: {
                return "ingotSilver";
            }
            case STAR: 
            case DIAMOND: 
            case ENDER: {
                return ItemStacks.redgoldingot;
            }
        }
        return "ingotCopper";
    }

    public ItemStack getCraftedProduct() {
        return ElectriItems.BATTERY.getStackOfMetadata(this.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void loadIcon(IIconRegister ico) {
        this.icon = ico.func_94245_a("electricraft:battery/" + this.name().toLowerCase(Locale.ENGLISH) + "_glow");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getGlowingIcon() {
        return this.icon;
    }

    public static String getDataForDisplay() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < batteryList.length; ++i) {
            BatteryType type = batteryList[i];
            sb.append(type.getName() + " - Capacity: " + type.getFormattedCapacity() + "; Output: " + type.outputCurrent + "A @ " + type.outputVoltage + "V");
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        batteryList = BatteryType.values();
    }
}

