/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.CurrentThrottle;
import Reika.ElectriCraft.Auxiliary.ElectriNetworkEvent;
import Reika.ElectriCraft.Auxiliary.Overloadable;
import Reika.ElectriCraft.Auxiliary.WireEmitter;
import Reika.ElectriCraft.Auxiliary.WireFuse;
import Reika.ElectriCraft.Auxiliary.WireReceiver;
import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.Network.WireNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public final class WirePath {
    final LinkedList<WiringTile> nodes = new LinkedList();
    final Collection<WireFuse> fuses = new ArrayList<WireFuse>();
    final WireEmitter start;
    final WireReceiver end;
    private final WireNetwork net;
    public final int resistance;
    private final int currentLimit;
    private final HashSet<Integer> dimensions = new HashSet();

    public WirePath(LinkedList<WorldLocation> points, WireEmitter start, WireReceiver end, WireNetwork net) {
        this.start = start;
        this.end = end;
        this.net = net;
        this.verify();
        int maxcurrent = Integer.MAX_VALUE;
        int r = 0;
        for (WorldLocation loc : points) {
            int max;
            WiringTile te = (WiringTile)loc.getTileEntity();
            this.nodes.addLast(te);
            this.dimensions.add(loc.dimensionID);
            r += te.getResistance();
            if (te instanceof CurrentThrottle && (max = ((CurrentThrottle)((Object)te)).getCurrentLimit()) < maxcurrent) {
                maxcurrent = max;
            }
            if (!(te instanceof WireFuse)) continue;
            this.fuses.add((WireFuse)((Object)te));
        }
        this.resistance = r;
        this.currentLimit = maxcurrent;
    }

    private void verify() {
        if (this.start == null || this.end == null) {
            throw new IllegalArgumentException("Cannot connect null points!");
        }
        if (this.start.getWorld() != this.end.getWorld()) {
            // empty if block
        }
    }

    public void overload(boolean intersect) {
        for (WiringTile w : this.nodes) {
            if (!intersect && this.net.getNodeAt(w).getPaths() != 1 || !(w instanceof Overloadable)) continue;
            ((Overloadable)((Object)w)).overload(this.getPathCurrent());
        }
    }

    public int getLength() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int getVoltageAt(WiringTile wire) {
        return this.start.canEmitPower() ? (this.start.getGenVoltage() > 0 ? Math.max(0, this.start.getGenVoltage() - this.getResistanceTo(wire)) : 0) : 0;
    }

    private int getResistanceTo(WiringTile wire) {
        return this.getResistanceTo(this.nodes.indexOf(wire));
    }

    private int getResistanceTo(int index) {
        int r = 0;
        for (int i = 0; i < index; ++i) {
            WiringTile wire = this.nodes.get(i);
            r += wire.getResistance();
        }
        return r;
    }

    public String toString() {
        return this.start + ":" + this.end + "{" + this.hashCode() + "}";
    }

    public boolean containsBlock(WiringTile te) {
        return this.nodes.contains(te);
    }

    boolean tick(ElectriNetworkEvent.ElectriNetworkTickEvent evt) {
        int current = this.getPathCurrent();
        boolean flag = false;
        for (WireFuse f : this.fuses) {
            if (current <= f.getMaxCurrent()) continue;
            f.overload(current);
            flag = true;
        }
        return flag;
    }

    public boolean startsAt(int x, int y, int z) {
        return this.start.getX() == x && y == this.start.getY() && z == this.start.getZ();
    }

    public boolean endsAt(int x, int y, int z) {
        return x == this.end.getX() && y == this.end.getY() && z == this.end.getZ();
    }

    public int getTerminalVoltage() {
        int v = this.start.getGenVoltage() > 0 ? this.start.getGenVoltage() - this.getVoltageLoss() : 0;
        return v > 0 ? v : 0;
    }

    public int getVoltageLoss() {
        return this.resistance;
    }

    public boolean isLimitedCurrent() {
        return this.currentLimit < Integer.MAX_VALUE;
    }

    public int getPathCurrent() {
        if (!this.start.canEmitPower()) {
            return 0;
        }
        int total = this.start.getGenCurrent();
        int num = this.net.getNumberPathsStartingAt(this.start);
        int frac = total / num;
        int bonus = 0;
        int unfilled = 0;
        ArrayList<WirePath> li = this.net.getPathsStartingAt(this.start);
        for (WirePath path : li) {
            if (path.isLimitedCurrent()) {
                int max = path.currentLimit;
                if (max <= frac) {
                    bonus += frac - max;
                    continue;
                }
                ++unfilled;
                continue;
            }
            ++unfilled;
        }
        int frac2 = unfilled > 0 ? bonus / unfilled : 0;
        return Math.min(frac + frac2, this.currentLimit);
    }

    Collection<Integer> getDimensions() {
        return Collections.unmodifiableSet(this.dimensions);
    }
}

