/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network.RF;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.ElectriNetworkEvent;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.ElectriNetworkManager;
import Reika.ElectriCraft.NetworkObject;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityRFCable;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RFNetwork
implements NetworkObject {
    private final Collection<TileEntityRFCable> cables = new ArrayList<TileEntityRFCable>();
    private final HashMap<WorldLocation, EnergyInteraction> endpoints = new HashMap();
    private int energy = 0;
    private int networkLimit;
    private boolean disabled;

    public void setIOLimit(int limit) {
        if (this.networkLimit != limit) {
            this.networkLimit = limit;
            for (TileEntityRFCable cable : this.cables) {
                if (cable.getRFLimit() == this.networkLimit) continue;
                cable.setRFLimit(this.networkLimit);
            }
        }
    }

    public int getIOLimit() {
        return this.networkLimit;
    }

    public RFNetwork() {
        ElectriNetworkManager.instance.addNetwork(this);
    }

    @Override
    public void tick(ElectriNetworkEvent.ElectriNetworkTickEvent evt) {
        if (!(this.disabled || this.cables.isEmpty() || this.endpoints.isEmpty())) {
            int i;
            EnergyInteraction ei2;
            ArrayList<EnergyInteraction> collectibles = new ArrayList<EnergyInteraction>();
            ArrayList<EnergyInteraction> insertibles = new ArrayList<EnergyInteraction>();
            int maxCanPush = this.energy;
            for (EnergyInteraction ei2 : this.endpoints.values()) {
                maxCanPush += ei2.getTotalInsertible();
                if (ei2.isCollectible()) {
                    collectibles.add(ei2);
                }
                if (!ei2.isInsertible()) continue;
                insertibles.add(ei2);
            }
            maxCanPush = Math.min(this.getIOLimit(), maxCanPush);
            for (i = 0; i < collectibles.size() && this.energy < maxCanPush; ++i) {
                ei2 = (EnergyInteraction)collectibles.get(i);
                int space = maxCanPush - this.energy;
                this.energy += ei2.collectEnergy(space);
            }
            for (i = 0; i < insertibles.size() && this.energy > 0; ++i) {
                ei2 = (EnergyInteraction)insertibles.get(i);
                int add = Math.min(this.energy, 1 + this.energy / insertibles.size());
                this.energy -= ei2.addEnergy(add);
            }
        }
    }

    @Override
    public void repath(ElectriNetworkEvent.ElectriNetworkRepathEvent evt) {
    }

    public void addElement(TileEntityRFCable te) {
        if (!this.cables.contains((Object)te)) {
            this.cables.add(te);
            if (te.getRFLimit() > 0 && te.getRFLimit() != this.networkLimit) {
                this.setIOLimit(Math.min(te.getRFLimit(), this.getIOLimit()));
            }
        }
    }

    public void removeElement(TileEntityRFCable te) {
        this.cables.remove((Object)te);
        this.rebuild();
    }

    private void rebuild() {
        ElectriCraft.logger.debug((Object)("Remapping RF network " + this));
        for (TileEntityRFCable te : this.cables) {
            te.findAndJoinNetwork(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        this.clear(true);
    }

    public void addConnection(IEnergyHandler ih, ForgeDirection dir) {
        if (ih instanceof TileEntityRFCable) {
            return;
        }
        EnergyInteraction has = this.getInteractionFor(ih);
        if (has == null) {
            this.endpoints.put(new WorldLocation((TileEntity)ih), new EnergyInteraction(ih, new ForgeDirection[]{dir}));
        } else {
            has.addSide(dir);
        }
    }

    public void merge(RFNetwork n) {
        if (n != this) {
            ArrayList<TileEntityRFCable> li = new ArrayList<TileEntityRFCable>();
            for (TileEntityRFCable wire : n.cables) {
                li.add(wire);
            }
            for (EnergyInteraction ei : n.endpoints.values()) {
                EnergyInteraction has = this.getInteractionFor(ei.tile);
                if (has == null) {
                    this.endpoints.put(new WorldLocation((TileEntity)ei.tile), ei);
                    continue;
                }
                has.merge(ei);
            }
            n.clear(false);
            for (TileEntityRFCable wire : li) {
                wire.setNetwork(this);
            }
            if (n.getIOLimit() != 0 && n.networkLimit != this.networkLimit) {
                this.setIOLimit(Math.min(n.getIOLimit(), this.getIOLimit()));
            }
        }
        this.updateWires();
    }

    private EnergyInteraction getInteractionFor(IEnergyHandler tile) {
        return this.endpoints.get(new WorldLocation((TileEntity)tile));
    }

    private void updateWires() {
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (TileEntityRFCable cable : this.cables) {
                cable.resetNetwork();
            }
        }
        this.cables.clear();
        this.endpoints.clear();
        this.energy = 0;
        this.disabled = true;
        ElectriNetworkManager.instance.scheduleNetworkDiscard(this);
    }

    public String toString() {
        return this.cables.size() + ": " + this.endpoints.toString();
    }

    public int drainEnergy(int maxReceive, boolean simulate) {
        maxReceive = Math.min(maxReceive, this.getIOLimit());
        int drain = Math.min(maxReceive, this.energy);
        if (!simulate) {
            this.energy -= drain;
        }
        return drain;
    }

    public int addEnergy(int maxAdd, boolean simulate) {
        if (this.energy >= this.getIOLimit()) {
            return 0;
        }
        maxAdd = Math.min(this.getIOLimit(), maxAdd);
        if (!simulate) {
            this.energy += maxAdd;
        }
        return maxAdd;
    }

    private static class EnergyInteraction {
        private final IEnergyHandler tile;
        private final ArrayList<ForgeDirection> sides = new ArrayList();

        private EnergyInteraction(IEnergyHandler ih, ForgeDirection ... dirs) {
            this.tile = ih;
            for (int i = 0; i < dirs.length; ++i) {
                this.addSide(dirs[i]);
            }
        }

        public boolean isInsertible() {
            return this.getTotalInsertible() > 0;
        }

        public boolean isCollectible() {
            return this.getTotalCollectible() > 0;
        }

        public boolean contains(IEnergyHandler tile) {
            return tile == this.tile;
        }

        public void addSide(ForgeDirection dir) {
            if (!this.sides.contains(dir)) {
                this.sides.add(dir);
            }
        }

        public void merge(EnergyInteraction ei) {
            for (int i = 0; i < ei.sides.size(); ++i) {
                this.addSide(ei.sides.get(i));
            }
        }

        public int collectEnergy(int max) {
            int total = 0;
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!this.tile.canConnectEnergy(dir)) continue;
                int collect = max - total;
                total += this.tile.extractEnergy(dir, collect, false);
            }
            return total;
        }

        public int addEnergy(int max) {
            int total = 0;
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!this.tile.canConnectEnergy(dir)) continue;
                int add = max - total;
                total += this.tile.receiveEnergy(dir, add, false);
            }
            return total;
        }

        public int getTotalCollectible() {
            if (!(this.tile instanceof IEnergyProvider)) {
                return 0;
            }
            int total = 0;
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!this.tile.canConnectEnergy(dir)) continue;
                total += this.tile.extractEnergy(dir, Integer.MAX_VALUE, true);
            }
            return total;
        }

        public int getTotalInsertible() {
            if (!(this.tile instanceof IEnergyReceiver)) {
                return 0;
            }
            int total = 0;
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!this.tile.canConnectEnergy(dir)) continue;
                total += this.tile.receiveEnergy(dir, Integer.MAX_VALUE, true);
            }
            return total;
        }

        public String toString() {
            return this.tile + " @ " + this.sides;
        }

        public boolean equals(Object o) {
            if (o instanceof EnergyInteraction) {
                EnergyInteraction ei = (EnergyInteraction)o;
                return ei.tile.equals(this.tile) && ei.sides.equals(this.sides);
            }
            return false;
        }

        public int hashCode() {
            return this.tile.hashCode() ^ this.sides.hashCode();
        }
    }
}

