/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.WireEmitter;
import Reika.ElectriCraft.Auxiliary.WireReceiver;
import Reika.ElectriCraft.Base.TileEntityWireComponent;
import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.Network.WireNetwork;
import Reika.ElectriCraft.Network.WirePath;
import Reika.ElectriCraft.Registry.ElectriTiles;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PathCalculator {
    private final WireEmitter start;
    private final WireReceiver end;
    private final WireNetwork net;
    private ArrayList<WirePath> paths = new ArrayList();

    public PathCalculator(WireEmitter start, WireReceiver end, WireNetwork w) {
        this.start = start;
        this.end = end;
        this.net = w;
        this.verify();
    }

    private void verify() {
        if (this.start == this.end) {
            throw new IllegalArgumentException("Cannot connect an object to itself!");
        }
        if (this.start == null || this.end == null) {
            throw new IllegalArgumentException("Cannot connect null points!");
        }
        if (this.start.getWorld() != this.end.getWorld()) {
            // empty if block
        }
    }

    public void calculatePaths() {
        int x = this.start.getX();
        int y = this.start.getY();
        int z = this.start.getZ();
        World world = this.start.getWorld();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = WireNetwork.dirs[i];
            LinkedList<WorldLocation> li = new LinkedList<WorldLocation>();
            if (!this.start.canEmitPowerToSide(dir)) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (world.func_72904_c(dx, dy, dz, dx, dy, dz)) {
                TileEntity other;
                WorldRift sr;
                WorldLocation loc;
                if (this.isEnd(world, dx, dy, dz)) {
                    if (!this.end.canReceivePower() || !this.end.canReceivePowerFromSide(dir.getOpposite())) continue;
                    this.paths.add(new WirePath(li, this.start, this.end, this.net));
                    return;
                }
                ElectriTiles t = ElectriTiles.getTE((IBlockAccess)world, dx, dy, dz);
                if (t != null && t.isWiringPiece()) {
                    WiringTile tile = (WiringTile)world.func_147438_o(dx, dy, dz);
                    if (!tile.canNetworkOnSide(dir.getOpposite())) continue;
                    this.recursiveCalculate(world, dx, dy, dz, li);
                    continue;
                }
                TileEntity te = world.func_147438_o(dx, dy, dz);
                if (!(te instanceof WorldRift) || (loc = (sr = (WorldRift)te).getLinkTarget()) == null || !((other = sr.getTileEntityFrom(dir)) instanceof WiringTile) || !((WiringTile)other).canNetworkOnSide(dir.getOpposite())) continue;
                World w2 = loc.getWorld();
                dx = loc.xCoord + dir.offsetX;
                dy = loc.yCoord + dir.offsetY;
                dz = loc.zCoord + dir.offsetZ;
                if (w2 == null || !w2.func_72904_c(dx, dy, dz, dx, dy, dz)) continue;
                this.recursiveCalculate(w2, dx, dy, dz, li);
                continue;
            }
            return;
        }
    }

    private void recursiveCalculate(World world, int x, int y, int z, LinkedList<WorldLocation> li) {
        if (li.contains(new WorldLocation(world, x, y, z))) {
            return;
        }
        li.addLast(new WorldLocation(world, x, y, z));
        WiringTile te = (WiringTile)world.func_147438_o(x, y, z);
        for (int i = 0; i < 6; ++i) {
            TileEntity other;
            WorldRift sr;
            WorldLocation loc;
            int dz;
            int dy;
            int dx;
            ForgeDirection dir = WireNetwork.dirs[i];
            if (!te.canNetworkOnSide(dir) || !world.func_72904_c(dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ, dx, dy, dz)) continue;
            if (this.isEnd(world, dx, dy, dz)) {
                if (!this.end.canReceivePower() || !this.end.canReceivePowerFromSide(dir.getOpposite())) continue;
                this.paths.add(new WirePath(li, this.start, this.end, this.net));
                return;
            }
            ElectriTiles t = ElectriTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (t != null && t.isWiringPiece()) {
                WiringTile tile = (WiringTile)world.func_147438_o(dx, dy, dz);
                if (!this.tileCanConnect(tile) || !tile.canNetworkOnSide(dir.getOpposite())) continue;
                this.recursiveCalculate(world, dx, dy, dz, li);
                continue;
            }
            TileEntity te2 = world.func_147438_o(dx, dy, dz);
            if (!(te2 instanceof WorldRift) || (loc = (sr = (WorldRift)te2).getLinkTarget()) == null || !((other = sr.getTileEntityFrom(dir)) instanceof WiringTile) || !((WiringTile)other).canNetworkOnSide(dir.getOpposite())) continue;
            World w2 = loc.getWorld();
            dx = loc.xCoord + dir.offsetX;
            dy = loc.yCoord + dir.offsetY;
            dz = loc.zCoord + dir.offsetZ;
            if (w2 == null || !w2.func_72904_c(dx, dy, dz, dx, dy, dz)) continue;
            this.recursiveCalculate(w2, dx, dy, dz, li);
        }
        li.removeLast();
    }

    private boolean tileCanConnect(WiringTile tile) {
        return tile instanceof TileEntityWireComponent ? ((TileEntityWireComponent)tile).canConnect() : true;
    }

    private boolean isEnd(World world, int x, int y, int z) {
        return this.end.getWorld() == world && x == this.end.getX() && y == this.end.getY() && z == this.end.getZ();
    }

    ArrayList<WirePath> getCalculatedPaths() {
        return this.paths;
    }

    public WirePath getShortestPath() {
        int index = -1;
        int length = Integer.MAX_VALUE;
        for (int i = 0; i < this.paths.size(); ++i) {
            WirePath path = this.paths.get(i);
            int l = path.getLength();
            if (l >= length) continue;
            length = l;
            index = i;
        }
        return index >= 0 ? this.paths.get(index) : null;
    }
}

