/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.GUIs;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ElectriCraft.Auxiliary.ElectriDescriptions;
import Reika.ElectriCraft.Registry.BatteryType;
import Reika.ElectriCraft.Registry.ElectriBook;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Registry.WireType;
import Reika.ElectriCraft.TileEntities.TileEntityResistor;
import Reika.ElectriCraft.TileEntities.TileEntityWire;
import Reika.RotaryCraft.Auxiliary.HandbookAuxData;
import Reika.RotaryCraft.Auxiliary.Interfaces.HandbookEntry;
import Reika.RotaryCraft.GUIs.GuiHandbook;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiElectriBook
extends GuiHandbook {
    private static final Random rand = new Random();
    private TileEntityResistor.ColorBand resistorB1 = TileEntityResistor.ColorBand.BLACK;
    private TileEntityResistor.ColorBand resistorB2 = TileEntityResistor.ColorBand.BLACK;
    private TileEntityResistor.ColorBand resistorB3 = TileEntityResistor.ColorBand.BLACK;
    private int guiTick;

    public GuiElectriBook(EntityPlayer p5ep, World world, int s, int p) {
        super(p5ep, world, s, p);
    }

    protected void reloadXMLData() {
        ElectriDescriptions.reload();
    }

    protected void addTabButtons(int j, int k) {
        ElectriBook.addRelevantButtons(j, k, this.screen, this.field_146292_n);
    }

    public int getMaxScreen() {
        return ElectriBook.MODDESC.getScreen() + ElectriBook.MODDESC.getNumberChildren() / 8;
    }

    public int getMaxSubpage() {
        ElectriBook h = ElectriBook.getFromScreenAndPage(this.screen, this.page);
        return h.isMachine() ? 1 : 0;
    }

    protected int getNewScreenByTOCButton(int id) {
        switch (id) {
            case 1: {
                return ElectriBook.INTRO.getScreen();
            }
            case 2: {
                return ElectriBook.CONVDESC.getScreen();
            }
            case 3: {
                return ElectriBook.TRANSDESC.getScreen();
            }
            case 4: {
                return ElectriBook.STORAGEDESC.getScreen();
            }
            case 5: {
                return ElectriBook.UTILDESC.getScreen();
            }
            case 6: {
                return ElectriBook.MODDESC.getScreen();
            }
        }
        return 0;
    }

    protected boolean isOnTOC() {
        return this.getEntry() == ElectriBook.TOC;
    }

    protected void drawAuxData(int posX, int posY) {
        ArrayList out;
        ++this.guiTick;
        ElectriBook h = (ElectriBook)this.getEntry();
        if (h.isMachine()) {
            out = h.getItems(this.subpage);
            if (out == null || out.size() <= 0) {
                return;
            }
            if (h == ElectriBook.WIRES) {
                out.clear();
                WireType type = WireType.wireList[(int)(System.currentTimeMillis() / 4000L) % WireType.wireList.length];
                ItemStack is = System.currentTimeMillis() % 4000L >= 2000L ? type.getCraftedInsulatedProduct() : type.getCraftedProduct();
                out.add(is);
            }
            ReikaGuiAPI.instance.drawCustomRecipes(ri, this.field_146289_q, (List)out, HandbookAuxData.getWorktable(), posX + 72 - 18, posY + 18, posX - 1620, posY + 32);
        }
        if (this.getGuiLayout() == GuiHandbook.PageType.CRAFTING) {
            out = ReikaJavaLibrary.makeListFrom((Object)h.getItem().getStackOf());
            if (out == null || out.size() <= 0) {
                return;
            }
            ReikaGuiAPI.instance.drawCustomRecipes(ri, this.field_146289_q, (List)out, CraftingManager.func_77594_a().func_77592_b(), posX + 72, posY + 18, posX + 162, posY + 32);
        }
    }

    protected void doRenderMachine(double x, double y, HandbookEntry he) {
        ElectriBook h = (ElectriBook)he;
        ElectriTiles et = h.getMachine();
        if (et != null) {
            TileEntity te = et.createTEInstanceForRender();
            double sc = 48.0;
            int r = (int)(System.nanoTime() / 20000000L) % 360;
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            if (et.isWiring()) {
                double dx = -x;
                double dy = -y - 21.0;
                double dz = 0.0;
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)sc, (double)(-sc), (double)sc);
                GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)a, (double)b, (double)c);
                if (te instanceof TileEntityWire) {
                    TileEntityWire tw = (TileEntityWire)te;
                    tw.setBlockMetadata((int)(System.currentTimeMillis() / 4000L) % WireType.wireList.length);
                    tw.insulated = System.currentTimeMillis() % 4000L >= 2000L;
                }
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, -0.5, 0.0, -0.5, 0.0f);
                GL11.glTranslated((double)(-a), (double)(-b), (double)(-c));
                GL11.glRotatef((float)(-r), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderq), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)(1.0 / sc), (double)(-1.0 / sc), (double)(1.0 / sc));
            } else if (et.hasRender() && et.getBlock().func_149645_b() != 0) {
                TileEntityResistor tr;
                double dx = -x;
                double dy = -y - 21.0;
                double dz = 0.0;
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)sc, (double)(-sc), (double)sc);
                GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)a, (double)b, (double)c);
                if (te instanceof TileEntityResistor) {
                    tr = (TileEntityResistor)te;
                    if (this.guiTick % 100 == 0) {
                        this.recalcResistorColors();
                    }
                    tr.setColor(this.resistorB1, 1);
                    tr.setColor(this.resistorB2, 2);
                    tr.setColor(this.resistorB3, 3);
                }
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, -0.5, 0.0, -0.5, 0.0f);
                if (te instanceof TileEntityResistor) {
                    tr = (TileEntityResistor)te;
                    tr.setColor(TileEntityResistor.ColorBand.BLACK, 1);
                    tr.setColor(TileEntityResistor.ColorBand.BLACK, 2);
                    tr.setColor(TileEntityResistor.ColorBand.BLACK, 3);
                }
                GL11.glTranslated((double)(-a), (double)(-b), (double)(-c));
                GL11.glRotatef((float)(-r), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderq), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
                GL11.glScaled((double)(1.0 / sc), (double)(-1.0 / sc), (double)(1.0 / sc));
            } else {
                double dx = x;
                double dy = y;
                double dz = 0.0;
                GL11.glTranslated((double)dx, (double)dy, (double)dz);
                GL11.glScaled((double)sc, (double)(-sc), (double)sc);
                GL11.glRotatef((float)this.renderq, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glTranslated((double)a, (double)b, (double)c);
                int meta = et.getBlockMetadata();
                if (et == ElectriTiles.BATTERY) {
                    meta = (int)(-1L + System.currentTimeMillis() / 2000L) % BatteryType.batteryList.length;
                }
                rb.func_147800_a(et.getBlockInstance(), meta, 1.0f);
                GL11.glTranslated((double)(-a), (double)(-b), (double)(-c));
                GL11.glRotatef((float)(-r), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderq), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScaled((double)(1.0 / sc), (double)(-1.0 / sc), (double)(1.0 / sc));
                GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
            }
        }
    }

    private void recalcResistorColors() {
        this.resistorB1 = TileEntityResistor.ColorBand.bandList[rand.nextInt(TileEntityResistor.ColorBand.bandList.length)];
        this.resistorB2 = TileEntityResistor.ColorBand.bandList[rand.nextInt(TileEntityResistor.ColorBand.bandList.length)];
        this.resistorB3 = TileEntityResistor.ColorBand.bandList[rand.nextInt(TileEntityResistor.ColorBand.GRAY.ordinal())];
    }

    protected void drawAuxGraphics(int posX, int posY, float ptick) {
        ElectriBook h = (ElectriBook)this.getEntry();
        ReikaGuiAPI api = ReikaGuiAPI.instance;
    }

    protected HandbookEntry getEntry() {
        return ElectriBook.getFromScreenAndPage(this.screen, this.page);
    }

    public boolean isLimitedView() {
        return false;
    }

    protected GuiHandbook.PageType getGuiLayout() {
        ElectriBook h = (ElectriBook)this.getEntry();
        if (h.isParent()) {
            return GuiHandbook.PageType.PLAIN;
        }
        if (this.subpage == 1) {
            return GuiHandbook.PageType.PLAIN;
        }
        if (h.isMachine()) {
            return GuiHandbook.PageType.MACHINERENDER;
        }
        return GuiHandbook.PageType.PLAIN;
    }

    protected void bindTexture() {
        ElectriBook h = (ElectriBook)this.getEntry();
        super.bindTexture();
    }

    public List<HandbookEntry> getAllTabsOnScreen() {
        List<ElectriBook> li = ElectriBook.getEntriesForScreen(this.screen);
        return new ArrayList<HandbookEntry>(li);
    }
}

