/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.ElectriCraft.Auxiliary.ElectriNetworkEvent;
import Reika.ElectriCraft.NetworkObject;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ElectriNetworkManager
implements TickRegistry.TickHandler {
    public static final ElectriNetworkManager instance = new ElectriNetworkManager();
    private final Collection<NetworkObject> networks = new ArrayList<NetworkObject>();
    private final Collection<NetworkObject> discard = new ArrayList<NetworkObject>();

    private ElectriNetworkManager() {
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        block5: {
            WorldServer world;
            TickEvent.Phase phase;
            block4: {
                phase = (TickEvent.Phase)tickData[0];
                world = DimensionManager.getWorld((int)0);
                if (phase != TickEvent.Phase.START) break block4;
                if (!this.discard.isEmpty()) {
                    this.networks.removeAll(this.discard);
                    this.discard.clear();
                }
                if (world == null) break block5;
                ElectriNetworkEvent.ElectriNetworkTickEvent evt = new ElectriNetworkEvent.ElectriNetworkTickEvent((World)world);
                for (NetworkObject net : this.networks) {
                    net.tick(evt);
                }
                break block5;
            }
            if (phase == TickEvent.Phase.END && world != null) {
                ElectriNetworkEvent.ElectriNetworkRepathEvent evt = new ElectriNetworkEvent.ElectriNetworkRepathEvent((World)world);
                for (NetworkObject net : this.networks) {
                    net.repath(evt);
                }
            }
        }
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.SERVER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START || p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "Electri Network";
    }

    public void addNetwork(NetworkObject net) {
        this.networks.add(net);
    }

    public void scheduleNetworkDiscard(NetworkObject net) {
        this.discard.add(net);
    }
}

