/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.TextureFetcher;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.Auxiliary.ElectriRenderList;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.TileEntities.TileEntityBattery;
import Reika.ElectriCraft.TileEntities.TileEntityWire;
import Reika.RotaryCraft.API.Interfaces.Transducerable;
import Reika.RotaryCraft.API.Power.ShaftMachine;
import java.util.ArrayList;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ElectriTileEntity
extends TileEntityBase
implements RenderFetcher,
Transducerable {
    protected ForgeDirection[] dirs = ForgeDirection.values();
    public float phi;
    public boolean isFlipped = false;

    public final TextureFetcher getRenderer() {
        if (ElectriTiles.TEList[this.getIndex()].hasRender()) {
            return ElectriRenderList.getRenderForMachine(ElectriTiles.TEList[this.getIndex()]);
        }
        return null;
    }

    public final boolean allowTickAcceleration() {
        return false;
    }

    public Block getTileEntityBlockID() {
        return ElectriTiles.TEList[this.getIndex()].getBlock();
    }

    public abstract ElectriTiles getMachine();

    protected String getTEName() {
        return ElectriTiles.TEList[this.getIndex()].getName();
    }

    public final int getIndex() {
        return this.getMachine().ordinal();
    }

    public int getTextureState(ForgeDirection side) {
        return 0;
    }

    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("flip", this.isFlipped);
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isFlipped = NBT.func_74767_n("flip");
    }

    public boolean isThisTE(Block id, int meta) {
        return id == this.getTileEntityBlockID() && meta == this.getIndex();
    }

    public boolean shouldRenderInPass(int pass) {
        ElectriTiles r = ElectriTiles.TEList[this.getIndex()];
        return pass == 0 || (r.renderInPass1() || this instanceof ShaftMachine) && pass == 1;
    }

    public final ArrayList<String> getMessages(World world, int x, int y, int z, int side) {
        ArrayList<String> li = new ArrayList<String>();
        if (this instanceof TileEntityWire) {
            TileEntityWire wire = (TileEntityWire)this;
            li.add(String.format("Point Voltage: %dV", wire.getWireVoltage()));
            li.add(String.format("Point Current: %dA", wire.getWireCurrent()));
        }
        if (this instanceof TileEntityBattery) {
            TileEntityBattery b = (TileEntityBattery)this;
            double max = b.getMaxEnergy();
            li.add(String.format("Stored Energy: %s/%s", b.getDisplayEnergy(), b.getBatteryType().getFormattedCapacity()));
        }
        return li;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    protected final Visibility getOCNetworkVisibility() {
        return this.getMachine().isWiring() ? Visibility.Neighbors : Visibility.Network;
    }
}

