/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Event.Client.ResourceReloadEvent;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Registry.BatteryType;
import Reika.ElectriCraft.Registry.ElectriBook;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Registry.WireType;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraftforge.common.MinecraftForge;

public final class ElectriDescriptions {
    private static String PARENT = ElectriDescriptions.getParent();
    public static final String DESC_SUFFIX = ":desc";
    public static final String NOTE_SUFFIX = ":note";
    private static HashMap<ElectriBook, String> data = new HashMap();
    private static HashMap<ElectriBook, String> notes = new HashMap();
    private static HashMap<ElectriTiles, Object[]> machineData = new HashMap();
    private static HashMap<ElectriTiles, Object[]> machineNotes = new HashMap();
    private static HashMap<ElectriBook, Object[]> miscData = new HashMap();
    private static ArrayList<ElectriBook> categories = new ArrayList();
    private static final boolean mustLoad = !ReikaObfuscationHelper.isDeObfEnvironment();
    private static final XMLInterface parents = new XMLInterface(ElectriCraft.class, PARENT + "categories.xml", mustLoad);
    private static final XMLInterface machines = new XMLInterface(ElectriCraft.class, PARENT + "machines.xml", mustLoad);
    private static final XMLInterface infos = new XMLInterface(ElectriCraft.class, PARENT + "info.xml", mustLoad);

    private static String getParent() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.func_135034_a();
        if (ElectriDescriptions.hasLocalizedFor(language) && !"en_US".equals(lang)) {
            return "Resources/" + lang + "/";
        }
        return "Resources/";
    }

    private static boolean hasLocalizedFor(Language language) {
        String lang = language.func_135034_a();
        InputStream o = ElectriCraft.class.getResourceAsStream("Resources/" + lang + "/categories.xml");
        return o != null;
    }

    public static String getTOC() {
        List<ElectriBook> toctabs = ElectriBook.getTOCTabs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toctabs.size(); ++i) {
            ElectriBook h = toctabs.get(i);
            sb.append("Page ");
            sb.append(h.getScreen());
            sb.append(" - ");
            sb.append(h.getTitle());
            if (i >= toctabs.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void addData(ElectriTiles m, Object ... data) {
        machineData.put(m, data);
    }

    private static void addData(ElectriBook h, Object ... data) {
        miscData.put(h, data);
    }

    private static void addData(ElectriBook h, int[] data) {
        Object[] o = new Object[data.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = data[i];
        }
        miscData.put(h, o);
    }

    private static void addNotes(ElectriTiles m, Object ... data) {
        machineNotes.put(m, data);
    }

    public static void reload() {
        PARENT = ElectriDescriptions.getParent();
        data.clear();
        ElectriDescriptions.loadNumericalData();
        machines.reread();
        infos.reread();
        parents.reread();
        ElectriDescriptions.loadData();
    }

    private static void addEntry(ElectriBook h, String sg) {
        data.put(h, sg);
    }

    public static void loadData() {
        String desc;
        ElectriBook h;
        int i;
        List<ElectriBook> parenttabs = ElectriBook.getCategoryTabs();
        List<ElectriBook> machinetabs = ElectriBook.getMachineTabs();
        ElectriBook[] infotabs = ElectriBook.getInfoTabs();
        for (i = 0; i < parenttabs.size(); ++i) {
            h = parenttabs.get(i);
            desc = parents.getValueAtNode("categories:" + h.name().toLowerCase(Locale.ENGLISH));
            ElectriDescriptions.addEntry(h, desc);
        }
        for (i = 0; i < machinetabs.size(); ++i) {
            h = machinetabs.get(i);
            ElectriTiles m = h.getMachine();
            String desc2 = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
            String aux = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
            desc2 = String.format(desc2, machineData.get((Object)m));
            aux = String.format(aux, machineNotes.get((Object)m));
            if ("#NULL!".equals(desc2)) {
                desc2 = "There is no handbook data for this machine yet.";
            }
            if (m.isDummiedOut()) {
                desc2 = desc2 + "\nThis machine is currently unavailable.";
                aux = aux + "\nNote: Dummied Out";
            }
            ElectriDescriptions.addEntry(h, desc2);
            notes.put(h, aux);
        }
        for (i = 0; i < infotabs.length; ++i) {
            h = infotabs[i];
            desc = infos.getValueAtNode("info:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get((Object)h));
            ElectriDescriptions.addEntry(h, desc);
        }
    }

    public static String getData(ElectriBook h) {
        if (!data.containsKey((Object)h)) {
            return "";
        }
        return data.get((Object)h);
    }

    public static String getNotes(ElectriBook h) {
        if (!notes.containsKey((Object)h)) {
            return "";
        }
        return notes.get((Object)h);
    }

    private static void loadNumericalData() {
        ElectriDescriptions.addData(ElectriBook.LIMITS, WireType.getLimitsForDisplay());
        ElectriDescriptions.addNotes(ElectriTiles.GENERATOR, 8, 8);
        ElectriDescriptions.addData(ElectriTiles.TRANSFORMER, 1000, 4096);
        ElectriDescriptions.addData(ElectriTiles.RFBATTERY, 60000000000000L);
        ElectriDescriptions.addData(ElectriTiles.EUBATTERY, 6.0E8);
        ElectriDescriptions.addNotes(ElectriTiles.BATTERY, BatteryType.getDataForDisplay());
    }

    static {
        ElectriDescriptions.loadNumericalData();
        MinecraftForge.EVENT_BUS.register((Object)new ReloadListener());
    }

    public static class ReloadListener {
        @SubscribeEvent
        public void reload(ResourceReloadEvent evt) {
            ElectriDescriptions.reload();
        }
    }
}

