/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.compat.ILaserTargetHelper;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IEnchantableTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLaser
extends APowerTile
implements IEnchantableTile {
    public Position[] lasers;
    private final List<Object> laserTargets = new ArrayList<Object>();
    protected byte unbreaking;
    protected byte fortune;
    protected byte efficiency;
    protected boolean silktouch;
    private double pa;
    private long from = 38669L;
    private final double[] tp = new double[100];
    private int pi = 0;
    public static final ResourceLocation[] LASER_TEXTURES = new ResourceLocation[]{new ResourceLocation("yogpstop_qp", "textures/entities/laser_1.png"), new ResourceLocation("yogpstop_qp", "textures/entities/laser_2.png"), new ResourceLocation("yogpstop_qp", "textures/entities/laser_3.png"), new ResourceLocation("yogpstop_qp", "textures/entities/laser_4.png"), new ResourceLocation("yogpstop_qp", "textures/entities/stripes.png")};

    public TileLaser() {
        PowerManager.configureL(this, this.efficiency, this.unbreaking);
    }

    @Override
    public void func_145845_h() {
        int i;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isValidTable() && this.field_145850_b.func_72820_D() % 100L == this.from % 100L) {
            this.findTable();
        }
        if (!this.isValidTable() || this.getStoredEnergy() == 0.0) {
            this.removeLaser();
            return;
        }
        if (!this.isValidLaser()) {
            for (i = 0; i < this.lasers.length; ++i) {
                this.lasers[i] = new Position();
                this.from = this.field_145850_b.func_72820_D();
            }
        }
        if (this.isValidLaser() && this.field_145850_b.func_72820_D() % 10L == this.from % 10L) {
            for (i = 0; i < this.laserTargets.size(); ++i) {
                this.lasers[i].x = (double)ILaserTargetHelper.getXCoord(this.laserTargets.get(i)) + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0;
                this.lasers[i].y = (float)ILaserTargetHelper.getYCoord(this.laserTargets.get(i)) + 0.5625f;
                this.lasers[i].z = (double)ILaserTargetHelper.getZCoord(this.laserTargets.get(i)) + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0;
            }
        }
        double power = PowerManager.useEnergyL(this, this.unbreaking, this.fortune, this.silktouch, this.efficiency);
        for (Object lt : this.laserTargets) {
            ILaserTargetHelper.receiveLaserEnergy(lt, 10.0 * power / (double)this.laserTargets.size());
        }
        this.pushPower(10.0 * power / (double)this.laserTargets.size());
        if (this.field_145850_b.func_72820_D() % 20L == 7L) {
            PacketHandler.sendPacketToAround(new YogpstopPacket(this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean isValidLaser() {
        for (Position laser : this.lasers) {
            if (laser != null) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidTable() {
        if (this.laserTargets.size() == 0) {
            return false;
        }
        for (Object lt : this.laserTargets) {
            if (lt != null && ILaserTargetHelper.isValid(lt)) continue;
            return false;
        }
        return true;
    }

    protected void findTable() {
        this.removeLaser();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int minX = this.field_145851_c - 5 * (this.fortune + 1);
        int minY = this.field_145848_d - 5 * (this.fortune + 1);
        int minZ = this.field_145849_e - 5 * (this.fortune + 1);
        int maxX = this.field_145851_c + 5 * (this.fortune + 1);
        int maxY = this.field_145848_d + 5 * (this.fortune + 1);
        int maxZ = this.field_145849_e + 5 * (this.fortune + 1);
        switch (ForgeDirection.values()[meta]) {
            case WEST: {
                maxX = this.field_145851_c;
                break;
            }
            case EAST: {
                minX = this.field_145851_c;
                break;
            }
            case DOWN: {
                maxY = this.field_145848_d;
                break;
            }
            case UP: {
                minY = this.field_145848_d;
                break;
            }
            case NORTH: {
                maxZ = this.field_145849_e;
                break;
            }
            default: {
                minZ = this.field_145849_e;
            }
        }
        this.laserTargets.clear();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                    if (!ILaserTargetHelper.isInstance(tile) || !ILaserTargetHelper.isValid(tile)) continue;
                    this.laserTargets.add(tile);
                }
            }
        }
        if (this.laserTargets.isEmpty()) {
            return;
        }
        if (!this.silktouch) {
            Object laserTarget = this.laserTargets.get(this.field_145850_b.field_73012_v.nextInt(this.laserTargets.size()));
            this.laserTargets.clear();
            this.laserTargets.add(laserTarget);
        }
        this.lasers = new Position[this.laserTargets.size()];
    }

    protected void removeLaser() {
        if (this.lasers != null) {
            for (int i = 0; i < this.lasers.length; ++i) {
                this.lasers[i] = null;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendPacketToAround(new YogpstopPacket(this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void pushPower(double received) {
        this.pa -= this.tp[this.pi];
        this.pa += received;
        this.tp[this.pi] = received;
        ++this.pi;
        if (this.pi == this.tp.length) {
            this.pi = 0;
        }
    }

    public ResourceLocation getTexture() {
        double avg = this.pa / 100.0;
        if (avg <= 1.0) {
            return LASER_TEXTURES[0];
        }
        if (avg <= 2.0) {
            return LASER_TEXTURES[1];
        }
        if (avg <= 3.0) {
            return LASER_TEXTURES[2];
        }
        return LASER_TEXTURES[3];
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.fortune = nbttc.func_74771_c("fortune");
        this.efficiency = nbttc.func_74771_c("efficiency");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        this.silktouch = nbttc.func_74767_n("silktouch");
        PowerManager.configureL(this, this.efficiency, this.unbreaking);
        this.pa = nbttc.func_74769_h("pa");
        NBTTagList nbttl = nbttc.func_150295_c("lasers", 10);
        if (this.lasers == null || this.lasers.length != nbttl.func_74745_c()) {
            this.lasers = new Position[nbttl.func_74745_c()];
        }
        for (int i = 0; i < nbttl.func_74745_c(); ++i) {
            if (this.lasers[i] == null) {
                this.lasers[i] = new Position();
            }
            NBTTagCompound lc = nbttl.func_150305_b(i);
            this.lasers[i].x = lc.func_74769_h("x");
            this.lasers[i].y = lc.func_74769_h("y");
            this.lasers[i].z = lc.func_74769_h("z");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("efficiency", this.efficiency);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        nbttc.func_74757_a("silktouch", this.silktouch);
        nbttc.func_74780_a("pa", this.pa);
        NBTTagList nbttl = new NBTTagList();
        if (this.lasers != null) {
            for (Position l : this.lasers) {
                if (l == null) continue;
                NBTTagCompound lc = new NBTTagCompound();
                lc.func_74780_a("x", l.x);
                lc.func_74780_a("y", l.y);
                lc.func_74780_a("z", l.z);
                nbttl.func_74742_a((NBTBase)lc);
            }
        }
        nbttc.func_74782_a("lasers", (NBTBase)nbttl);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeLaser();
    }

    @Override
    public Map<Integer, Byte> get() {
        HashMap<Integer, Byte> ret = new HashMap<Integer, Byte>();
        if (this.efficiency > 0) {
            ret.put(Enchantment.field_77349_p.field_77352_x, this.efficiency);
        }
        if (this.fortune > 0) {
            ret.put(Enchantment.field_77346_s.field_77352_x, this.fortune);
        }
        if (this.unbreaking > 0) {
            ret.put(Enchantment.field_77347_r.field_77352_x, this.unbreaking);
        }
        if (this.silktouch) {
            ret.put(Enchantment.field_77348_q.field_77352_x, (byte)1);
        }
        return ret;
    }

    @Override
    public void set(int id, byte val) {
        if (id == Enchantment.field_77349_p.field_77352_x) {
            this.efficiency = val;
        } else if (id == Enchantment.field_77346_s.field_77352_x) {
            this.fortune = val;
        } else if (id == Enchantment.field_77347_r.field_77352_x) {
            this.unbreaking = val;
        } else if (id == Enchantment.field_77348_q.field_77352_x && val > 0) {
            this.silktouch = true;
        }
    }

    @Override
    public void G_reinit() {
        PowerManager.configureL(this, this.efficiency, this.unbreaking);
    }

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        if (this.lasers != null) {
            for (Position p : this.lasers) {
                if (p == null) continue;
                double xn = p.x - 0.0625;
                double xx = xn + 0.125;
                double zn = p.z - 0.0625;
                double zx = zn + 0.125;
                if (xn < aabb.field_72340_a) {
                    aabb.field_72340_a = xn;
                }
                if (xx > aabb.field_72336_d) {
                    aabb.field_72336_d = xx;
                }
                if (p.y < aabb.field_72338_b) {
                    aabb.field_72338_b = p.y;
                }
                if (p.y > aabb.field_72337_e) {
                    aabb.field_72337_e = p.y;
                }
                if (zn < aabb.field_72339_c) {
                    aabb.field_72339_c = zn;
                }
                if (!(zx > aabb.field_72334_f)) continue;
                aabb.field_72334_f = zx;
            }
        }
        return aabb;
    }

    public static class Position {
        public double x;
        public double y;
        public double z;
    }
}

