/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.inventory.IInventoryConnection;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.InvUtils;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.ReflectionHelper;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TilePump;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.inventory.IInventoryConnection", modid="CoFHAPI|inventory")
public abstract class TileBasic
extends APowerTile
implements IEnchantableTile,
IInventory,
IInventoryConnection {
    protected ForgeDirection pump = ForgeDirection.UNKNOWN;
    public final List<QuarryPlusI.BlockData> fortuneList = new ArrayList<QuarryPlusI.BlockData>();
    public final List<QuarryPlusI.BlockData> silktouchList = new ArrayList<QuarryPlusI.BlockData>();
    public boolean fortuneInclude;
    public boolean silktouchInclude;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    protected final LinkedList<ItemStack> cacheItems = new LinkedList();
    public static final Method createStackedBlock = ReflectionHelper.getMethod(Block.class, new String[]{"func_149644_j", "createStackedBlock"}, new Class[][]{{Integer.TYPE}});

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
        switch (id) {
            case 10: {
                this.fortuneList.remove(new QuarryPlusI.BlockData(badi.readUTF(), badi.readInt()));
                break;
            }
            case 11: {
                this.silktouchList.remove(new QuarryPlusI.BlockData(badi.readUTF(), badi.readInt()));
                break;
            }
            case 12: {
                this.fortuneInclude = !this.fortuneInclude;
                break;
            }
            case 13: {
                this.silktouchInclude = !this.silktouchInclude;
            }
        }
    }

    public abstract void G_renew_powerConfigure();

    protected abstract void G_destroy();

    @Override
    public final void onChunkUnload() {
        this.G_destroy();
        super.onChunkUnload();
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    protected void S_pollItems() {
        ItemStack is;
        while (null != (is = this.cacheItems.poll())) {
            InvUtils.injectToNearTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, is);
            if (is.field_77994_a <= 0) continue;
            this.cacheItems.add(is);
            break;
        }
    }

    protected boolean S_breakBlock(int x, int y, int z) {
        LinkedList<ItemStack> dropped = new LinkedList<ItemStack>();
        Block b = this.field_145850_b.func_72863_F().func_73158_c(x >> 4, z >> 4).func_150810_a(x & 0xF, y, z & 0xF);
        if (b == null || b.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            return true;
        }
        if (TilePump.isLiquid(b, false, null, 0, 0, 0, 0)) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.pump.offsetX, this.field_145848_d + this.pump.offsetY, this.field_145849_e + this.pump.offsetZ);
            if (!(te instanceof TilePump)) {
                this.pump = ForgeDirection.UNKNOWN;
                this.G_renew_powerConfigure();
                return true;
            }
            return ((TilePump)te).S_removeLiquids(this, x, y, z);
        }
        if (!PowerManager.useEnergyB(this, b.func_149712_f(this.field_145850_b, x, y, z), this.S_addDroppedItems(dropped, b, x, y, z), this.unbreaking)) {
            return false;
        }
        this.cacheItems.addAll(dropped);
        this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)b) | this.field_145850_b.func_72805_g(x, y, z) << 12);
        this.field_145850_b.func_147468_f(x, y, z);
        return true;
    }

    boolean S_connect(ForgeDirection fd) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.pump.offsetX, this.field_145848_d + this.pump.offsetY, this.field_145849_e + this.pump.offsetZ);
        if (te instanceof TilePump && this.pump != fd) {
            return false;
        }
        this.pump = fd;
        this.G_renew_powerConfigure();
        return true;
    }

    private byte S_addDroppedItems(Collection<ItemStack> list, Block b, int x, int y, int z) {
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (b.canSilkHarvest(this.field_145850_b, null, x, y, z, meta) && this.silktouch && this.silktouchList.contains(new QuarryPlusI.BlockData(GameData.getBlockRegistry().func_148750_c((Object)b), meta)) == this.silktouchInclude) {
            list.add((ItemStack)ReflectionHelper.invoke(createStackedBlock, b, new Integer(meta)));
            return -1;
        }
        if (this.fortuneList.contains(new QuarryPlusI.BlockData(GameData.getBlockRegistry().func_148750_c((Object)b), meta)) == this.fortuneInclude) {
            list.addAll(b.getDrops(this.field_145850_b, x, y, z, meta, (int)this.fortune));
            return this.fortune;
        }
        list.addAll(b.getDrops(this.field_145850_b, x, y, z, meta, 0));
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.silktouch = nbttc.func_74767_n("silktouch");
        this.fortune = nbttc.func_74771_c("fortune");
        this.efficiency = nbttc.func_74771_c("efficiency");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        this.fortuneInclude = nbttc.func_74767_n("fortuneInclude");
        this.silktouchInclude = nbttc.func_74767_n("silktouchInclude");
        TileBasic.readLongCollection(nbttc.func_150295_c("fortuneList", 10), this.fortuneList);
        TileBasic.readLongCollection(nbttc.func_150295_c("silktouchList", 10), this.silktouchList);
    }

    private static void readLongCollection(NBTTagList nbttl, Collection<QuarryPlusI.BlockData> target) {
        target.clear();
        for (int i = 0; i < nbttl.func_74745_c(); ++i) {
            NBTTagCompound c = nbttl.func_150305_b(i);
            target.add(new QuarryPlusI.BlockData(c.func_74779_i("name"), c.func_74762_e("meta")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74757_a("silktouch", this.silktouch);
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("efficiency", this.efficiency);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        nbttc.func_74757_a("fortuneInclude", this.fortuneInclude);
        nbttc.func_74757_a("silktouchInclude", this.silktouchInclude);
        nbttc.func_74782_a("fortuneList", (NBTBase)TileBasic.writeLongCollection(this.fortuneList));
        nbttc.func_74782_a("silktouchList", (NBTBase)TileBasic.writeLongCollection(this.silktouchList));
    }

    private static NBTTagList writeLongCollection(Collection<QuarryPlusI.BlockData> target) {
        NBTTagList nbttl = new NBTTagList();
        for (QuarryPlusI.BlockData l : target) {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74778_a("name", l.name);
            c.func_74768_a("meta", l.meta);
            nbttl.func_74742_a((NBTBase)c);
        }
        return nbttl;
    }

    @Override
    public Map<Integer, Byte> get() {
        HashMap<Integer, Byte> ret = new HashMap<Integer, Byte>();
        if (this.efficiency > 0) {
            ret.put(Enchantment.field_77349_p.field_77352_x, this.efficiency);
        }
        if (this.fortune > 0) {
            ret.put(Enchantment.field_77346_s.field_77352_x, this.fortune);
        }
        if (this.unbreaking > 0) {
            ret.put(Enchantment.field_77347_r.field_77352_x, this.unbreaking);
        }
        if (this.silktouch) {
            ret.put(Enchantment.field_77348_q.field_77352_x, (byte)1);
        }
        return ret;
    }

    @Override
    public void set(int id, byte val) {
        if (id == Enchantment.field_77349_p.field_77352_x) {
            this.efficiency = val;
        } else if (id == Enchantment.field_77346_s.field_77352_x) {
            this.fortune = val;
        } else if (id == Enchantment.field_77347_r.field_77352_x) {
            this.unbreaking = val;
        } else if (id == Enchantment.field_77348_q.field_77352_x && val > 0) {
            this.silktouch = true;
        }
    }

    public int func_70302_i_() {
        return Math.max(1, this.cacheItems.size());
    }

    public ItemStack func_70301_a(int i) {
        return i < 0 || i >= this.cacheItems.size() ? new ItemStack(Blocks.field_150347_e, 0) : this.cacheItems.get(i);
    }

    public ItemStack func_70298_a(int i, int a) {
        if (i < 0 || i >= this.cacheItems.size()) {
            return null;
        }
        ItemStack from = this.cacheItems.get(i);
        ItemStack res = new ItemStack(from.func_77973_b(), Math.min(a, from.field_77994_a), from.func_77960_j());
        if (from.field_77990_d != null) {
            res.field_77990_d = (NBTTagCompound)from.field_77990_d.func_74737_b();
        }
        from.field_77994_a -= res.field_77994_a;
        if (from.field_77994_a == 0) {
            this.cacheItems.remove(i);
        }
        return res;
    }

    public ItemStack func_70304_b(int i) {
        return i < 0 || i >= this.cacheItems.size() ? new ItemStack(Blocks.field_150347_e, 0) : this.cacheItems.get(i);
    }

    public void func_70299_a(int i, ItemStack is) {
        if (is != null && is.field_77994_a > 0) {
            System.err.println("QuarryPlus WARN: call setInventorySlotContents with non null ItemStack.");
        }
        if (i >= 0 && i < this.cacheItems.size()) {
            this.cacheItems.remove(i);
        }
    }

    public String func_145825_b() {
        return "container.yog.basic";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Optional.Method(modid="CoFHAPI|inventory")
    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection arg0) {
        return IInventoryConnection.ConnectionType.FORCE;
    }
}

