/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.energy.IEnergyHandler;
import com.yogpc.qp.tile.APacketTile;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2API")})
public abstract class APowerTile
extends APacketTile
implements IEnergyHandler,
IEnergySink {
    private double all;
    private double maxGot;
    private double max;
    private double got;
    private boolean ic2ok = false;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.ic2ok && !this.field_145850_b.field_72995_K) {
            if (ModAPIManager.INSTANCE.hasAPI("IC2API")) {
                try {
                    APowerTile.ic2load(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ic2ok = true;
        }
        this.all += this.got;
        this.got = 0.0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.ic2ok && !this.field_145850_b.field_72995_K) {
            try {
                APowerTile.ic2unload(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ic2ok = false;
        }
    }

    @Optional.Method(modid="IC2API")
    public static final void ic2load(IEnergySink i) {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)i));
    }

    @Optional.Method(modid="IC2API")
    public static final void ic2unload(IEnergySink i) {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)i));
    }

    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.all = nbttc.func_74769_h("storedEnergy");
        this.max = nbttc.func_74769_h("MAX_stored");
        this.maxGot = nbttc.func_74769_h("MAX_receive");
    }

    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74780_a("storedEnergy", this.all);
        nbttc.func_74780_a("MAX_stored", this.max);
        nbttc.func_74780_a("MAX_receive", this.maxGot);
    }

    public final double useEnergy(double n, double x, boolean real) {
        double res = 0.0;
        if (this.all >= n) {
            if (this.all <= x) {
                res = this.all;
                if (real) {
                    this.all = 0.0;
                }
            } else {
                res = x;
                if (real) {
                    this.all -= x;
                }
            }
        }
        return res;
    }

    private final double getEnergy(double a, boolean r) {
        double ret = Math.min(Math.min(this.maxGot - this.got, this.max - this.all - this.got), a);
        if (r) {
            this.got += ret;
        }
        return ret;
    }

    public final double getStoredEnergy() {
        return this.all;
    }

    public final double getMaxStored() {
        return this.max;
    }

    public final void configure(double x, double maxstored) {
        this.maxGot = x;
        this.max = maxstored;
    }

    public final int getEnergyStored(ForgeDirection d) {
        return (int)(this.all * 10.0);
    }

    public final int getMaxEnergyStored(ForgeDirection d) {
        return (int)(this.max * 10.0);
    }

    public final int receiveEnergy(ForgeDirection d, int am, boolean sim) {
        return (int)this.getEnergy((double)am / 10.0, !sim) * 10;
    }

    public final double getDemandedEnergy() {
        return Math.min(this.maxGot - this.got, this.max - this.all - this.got) * 2.5;
    }

    public final double injectEnergy(ForgeDirection d, double am, double v) {
        return am - this.getEnergy(am / 2.5, true) * 2.5;
    }

    public final int getSinkTier() {
        return 3;
    }

    public final int extractEnergy(ForgeDirection d, int am, boolean sim) {
        return 0;
    }

    public final boolean canConnectEnergy(ForgeDirection d) {
        return true;
    }

    public final boolean acceptsEnergyFrom(TileEntity te, ForgeDirection d) {
        return true;
    }
}

