/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.tile.TileRefinery;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderRefinery
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation TEXTURE = new ResourceLocation("yogpstop_qp", "textures/blocks/refinery.png");
    private static final float pixel = 0.0625f;
    private static final RenderBlocks renderBlocks = new RenderBlocks();
    public static final RenderRefinery INSTANCE = new RenderRefinery();
    private final ModelRenderer tank;
    private final ModelRenderer[] magnet = new ModelRenderer[4];
    private final ModelBase model = new ModelBase(){};
    private static final Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();

    private RenderRefinery() {
        this.tank = new ModelRenderer(this.model, 0, 0);
        this.tank.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 16, 8);
        this.tank.field_78800_c = 8.0f;
        this.tank.field_78797_d = 8.0f;
        this.tank.field_78798_e = 8.0f;
        for (int i = 0; i < 4; ++i) {
            this.magnet[i] = new ModelRenderer(this.model, 32, i * 8);
            this.magnet[i].func_78789_a(0.0f, -8.0f, -8.0f, 8, 4, 4);
            this.magnet[i].field_78800_c = 8.0f;
            this.magnet[i].field_78797_d = 8.0f;
            this.magnet[i].field_78798_e = 8.0f;
        }
    }

    private static final void setColor(int i) {
        GL11.glColor4b((byte)((byte)(i >> 16)), (byte)((byte)(i >> 8)), (byte)((byte)i), (byte)127);
    }

    private void render(TileRefinery tile, double x, double y, double z) {
        float trans2;
        float trans1;
        float anim = 0.0f;
        int angle = 0;
        ModelRenderer theMagnet = this.magnet[0];
        if (tile != null) {
            anim = tile.getAnimationStage();
            angle = 0;
            switch (tile.func_145831_w().func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                case 2: {
                    angle = 90;
                    break;
                }
                case 3: {
                    angle = 270;
                    break;
                }
                case 4: {
                    angle = 180;
                    break;
                }
                case 5: {
                    angle = 0;
                }
            }
            theMagnet = tile.animationSpeed <= 1.0f ? this.magnet[0] : ((double)tile.animationSpeed <= 2.5 ? this.magnet[1] : ((double)tile.animationSpeed <= 4.5 ? this.magnet[2] : this.magnet[3]));
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TEXTURE);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)-0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.25f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.25f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)-0.25f);
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
        this.tank.func_78785_a(0.0625f);
        GL11.glTranslatef((float)-0.25f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (anim <= 100.0f) {
            trans1 = 0.75f * anim / 100.0f;
            trans2 = 0.0f;
        } else if (anim <= 200.0f) {
            trans1 = 0.75f - 0.75f * (anim - 100.0f) / 100.0f;
            trans2 = 0.75f * (anim - 100.0f) / 100.0f;
        } else {
            trans1 = 0.75f * (anim - 200.0f) / 100.0f;
            trans2 = 0.75f - 0.75f * (anim - 200.0f) / 100.0f;
        }
        RenderRefinery.renderMagnet(trans1, theMagnet, 0.0f);
        RenderRefinery.renderMagnet(trans2, theMagnet, 0.75f);
        if (tile != null) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glScalef((float)0.5f, (float)1.0f, (float)0.5f);
            this.renderFluid(tile.src[0], 0.0f, 0.0f, 0.0f, tile.buf);
            this.renderFluid(tile.src[1], 0.0f, 0.0f, 1.0f, tile.buf);
            this.renderFluid(tile.res, 1.0f, 0.0f, 0.5f, tile.buf);
            GL11.glPopAttrib();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static void renderMagnet(float trans, ModelRenderer magnet, float offset) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslatef((float)-0.51f, (float)(trans - 0.5f), (float)(offset - 0.5f));
        magnet.func_78785_a(0.0625f);
        GL11.glPopMatrix();
    }

    private void renderFluid(FluidStack liquid, float tx, float ty, float tz, float buf) {
        int[] list;
        if (liquid != null && liquid.amount > 0 && (list = RenderRefinery.getFluidDisplayLists(liquid)) != null) {
            if (tx != 0.0f || ty != 0.0f || tz != 0.0f) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)tx, (float)ty, (float)tz);
            }
            this.func_147499_a(TextureMap.field_110575_b);
            RenderRefinery.setColor(liquid.getFluid().getColor(liquid));
            GL11.glCallList((int)list[(int)((float)liquid.amount / buf * 99.0f)]);
            if (tx != 0.0f || ty != 0.0f || tz != 0.0f) {
                GL11.glPopMatrix();
            }
        }
    }

    private static int[] getFluidDisplayLists(FluidStack fluidStack) {
        IIcon texture;
        Block baseBlock;
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (fluid.getBlock() != null) {
            baseBlock = fluid.getBlock();
            texture = fluid.getStillIcon();
        } else {
            baseBlock = Blocks.field_150355_j;
            texture = fluid.getStillIcon();
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            renderBlocks.func_147782_a(0.01, 0.0, 0.01, 0.99, (double)((float)s / 100.0f), 0.99);
            renderBlocks.func_147768_a(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(0));
            renderBlocks.func_147806_b(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(1));
            renderBlocks.func_147761_c(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(2));
            renderBlocks.func_147734_d(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(3));
            renderBlocks.func_147798_e(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(4));
            renderBlocks.func_147764_f(baseBlock, 0.0, 0.0, 0.0, texture != null ? texture : baseBlock.func_149733_h(5));
            tessellator.func_78381_a();
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        cache.put(fluid, diplayLists);
        return diplayLists;
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.render((TileRefinery)tileentity, x, y, z);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (block.func_149645_b() != this.getRenderId()) {
            return;
        }
        this.render(null, -0.5, -0.5, -0.5);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return true;
    }

    public boolean shouldRender3DInInventory(int arg0) {
        return true;
    }

    public int getRenderId() {
        return QuarryPlusI.refineryRenderID;
    }
}

