/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.item;

import cofh.api.energy.IEnergyContainerItem;
import com.yogpc.qp.ElectricItemManager;
import com.yogpc.qp.ProxyCommon;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.ReflectionHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.item.IElectricItem", modid="IC2API")})
public class ItemArmorElectric
extends ItemArmor
implements ISpecialArmor,
IElectricItem,
IEnergyContainerItem {
    private static final Field f = ReflectionHelper.getField(NetHandlerPlayServer.class, "field_147365_f", "floatingTickCount");
    private static final double maxFallSpeedOnHover = 0.35;

    public ItemArmorElectric() {
        super(EnumHelper.addArmorMaterial((String)"ELECTRIC", (int)33, (int[])new int[]{3, 8, 6, 3}, (int)0), QuarryPlus.proxy.addNewArmourRendererPrefix("electric"), 1);
        this.func_77655_b("electric_armor");
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_111206_d("yogpstop_qp:elecArmor");
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.func_77637_a(QuarryPlusI.ct);
    }

    public String getArmorTexture(ItemStack i, Entity e, int s, String t) {
        return "yogpstop_qp:textures/models/armor/elecArmor_layer_1.png";
    }

    private void useJetpack(EntityPlayer p, ItemStack jetpack, boolean hover) {
        boolean jumping = QuarryPlus.proxy.getKey(p, ProxyCommon.Key.jump);
        if (jumping || hover && p.field_70181_x < -0.35) {
            int maxFlightHeight;
            double y;
            double charge = ElectricItemManager.getCharge(jetpack);
            if (charge <= 0.0) {
                return;
            }
            float power = 0.7f;
            if (charge / this.getMaxCharge(jetpack) <= (double)0.05f) {
                power = (float)((double)power * (charge / this.getMaxCharge(jetpack) * 0.05));
            }
            if (QuarryPlus.proxy.getKey(p, ProxyCommon.Key.forward) && power > 0.0f) {
                p.func_70060_a(0.0f, 0.4f * power * (hover ? 0.65f : 0.3f) * 2.0f, 0.02f);
            }
            if ((y = p.field_70163_u) > (double)(maxFlightHeight = (int)((float)p.field_70170_p.func_72800_K() / 1.28f))) {
                if (y > (double)maxFlightHeight) {
                    y = maxFlightHeight;
                }
                power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
            }
            double prevmotion = p.field_70181_x;
            p.field_70181_x = Math.min(p.field_70181_x + (double)(power * 0.2f), (double)0.6f);
            if (hover) {
                float maxHoverY;
                float f = maxHoverY = jumping ? 0.1f : -0.1f;
                if (p.field_70181_x > (double)maxHoverY) {
                    p.field_70181_x = maxHoverY;
                    if (prevmotion > p.field_70181_x) {
                        p.field_70181_x = prevmotion;
                    }
                }
            }
            ElectricItemManager.discharge(jetpack, hover ? 7.0 : 8.0, this.getMaxCharge(jetpack));
            p.field_70143_R = 0.0f;
            p.field_70140_Q = 0.0f;
            if (p instanceof EntityPlayerMP) {
                try {
                    f.setInt(((EntityPlayerMP)p).field_71135_a, 0);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            p.field_71069_bz.func_75142_b();
        }
    }

    private static boolean toggleHover(EntityPlayer p, ItemStack itemStack) {
        NBTTagCompound nbtData = itemStack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            itemStack.func_77982_d(nbtData);
        }
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (QuarryPlus.proxy.getKey(p, ProxyCommon.Key.jump) && QuarryPlus.proxy.getKey(p, ProxyCommon.Key.mode) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    p.func_145747_a((IChatComponent)new ChatComponentTranslation("yog.armor.hover.on", new Object[0]));
                } else {
                    p.func_145747_a((IChatComponent)new ChatComponentTranslation("yog.armor.hover.off", new Object[0]));
                }
            }
        }
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        return hoverMode;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack is) {
        if (ElectricItem.manager != null) {
            ElectricItemManager.charge(is, ElectricItem.manager.discharge(is, Double.MAX_VALUE, Integer.MAX_VALUE, true, false, false), this.getMaxCharge(is));
        }
        if (player.field_71071_by.field_70460_b[2] != is) {
            return;
        }
        this.useJetpack(player, is, ItemArmorElectric.toggleHover(player, is));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItemManager.charge(charged, Double.POSITIVE_INFINITY, this.getMaxCharge(charged));
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int damageLimit = (int)Math.min(2.147483647E9, 25.0 * ElectricItemManager.getCharge(armor) / 5000.0);
        return new ISpecialArmor.ArmorProperties(0, 0.36000000000000004, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItemManager.getCharge(armor) >= 5000.0) {
            return (int)Math.round(7.2);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack is, DamageSource source, int damage, int slot) {
        ElectricItemManager.discharge(is, damage * 5000, this.getMaxCharge(is));
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 2.0E7;
    }

    public int getTier(ItemStack itemStack) {
        return 4;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 2500.0;
    }

    public int extractEnergy(ItemStack is, int am, boolean sim) {
        return 0;
    }

    public int getEnergyStored(ItemStack is) {
        return (int)(ElectricItemManager.getCharge(is) * 4.0);
    }

    public int getMaxEnergyStored(ItemStack is) {
        return (int)(this.getMaxCharge(is) * 4.0);
    }

    public int receiveEnergy(ItemStack is, int am, boolean sim) {
        return (int)(ElectricItemManager.charge(is, Math.min((double)am / 4.0, this.getTransferLimit(is)), this.getMaxCharge(is)) * 4.0);
    }
}

