/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.container;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.SlotUnlimited;
import com.yogpc.qp.SlotWorkbench;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.container.IPacketContainer;
import com.yogpc.qp.tile.TileWorkbench;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerWorkbench
extends Container
implements IPacketContainer {
    private final TileWorkbench tile;
    private int precipe;
    private short ppower;
    private int field_94535_f = -1;
    private int drag_state;
    private final Set<Slot> dragged = new HashSet<Slot>();

    private static final ItemStack readItemStack(ByteArrayDataInput bb) throws IOException {
        short id = bb.readShort();
        if (id < 0) {
            return null;
        }
        ItemStack is = new ItemStack(Item.func_150899_d((int)id), bb.readInt(), (int)bb.readShort());
        short nbtlen = bb.readShort();
        if (nbtlen >= 0) {
            byte[] ba = new byte[nbtlen];
            bb.readFully(ba);
            is.func_77982_d(CompressedStreamTools.func_152457_a((byte[])ba, (NBTSizeTracker)NBTSizeTracker.field_152451_a));
        }
        return is;
    }

    private static final void writeItemStack(ItemStack is, DataOutputStream bb) throws IOException {
        if (is == null) {
            bb.writeShort(-1);
            return;
        }
        bb.writeShort((short)Item.func_150891_b((Item)is.func_77973_b()));
        bb.writeInt(is.field_77994_a);
        bb.writeShort((short)is.func_77960_j());
        NBTTagCompound nbttagcompound = null;
        if (is.func_77973_b().func_77645_m() || is.func_77973_b().func_77651_p()) {
            nbttagcompound = is.field_77990_d;
        }
        if (nbttagcompound != null) {
            byte[] ba = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            bb.writeShort((short)ba.length);
            bb.write(ba);
        } else {
            bb.writeShort(-1);
        }
    }

    public ContainerWorkbench(IInventory pi, TileWorkbench tw) {
        int col;
        int row;
        this.tile = tw;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotUnlimited(tw, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotWorkbench(tw, col + row * 9 + 27, 8 + col * 18, 90 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot(pi, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot(pi, col, 8 + col * 18, 198));
        }
    }

    public boolean func_75145_c(EntityPlayer ep) {
        return this.tile.func_70300_a(ep);
    }

    public ItemStack func_82846_b(EntityPlayer ep, int i) {
        if (27 <= i && i < 45) {
            return null;
        }
        ItemStack src = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (i < 27 ? !this.func_75135_a(remain, 45, 81, true) : !this.func_75135_a(remain, 0, 27, false)) {
                return null;
            }
            if (remain.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (remain.field_77994_a == src.field_77994_a) {
                return null;
            }
            slot.func_82870_a(ep, remain);
        }
        return src;
    }

    public void func_75132_a(ICrafting p_75132_1_) {
        if (this.field_75149_d.contains(p_75132_1_)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(p_75132_1_);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                dos.writeByte(i);
                ContainerWorkbench.writeItemStack(((Slot)this.field_75151_b.get(i)).func_75211_c(), dos);
            }
            dos.writeByte(101);
            dos.writeShort(this.tile.cpower);
            dos.writeByte(102);
            dos.writeByte(this.tile.cur_recipe);
            dos.writeByte(-1);
            PacketHandler.sendPacketToPlayer(new YogpstopPacket(this, bos.toByteArray()), (EntityPlayer)p_75132_1_);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.func_75142_b();
    }

    public void func_75142_b() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < this.field_75151_b.size(); ++i) {
                ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
                if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                itemstack1 = itemstack == null ? null : itemstack.func_77946_l();
                this.field_75153_a.set(i, itemstack1);
                dos.writeByte(i);
                ContainerWorkbench.writeItemStack(itemstack1, dos);
            }
            if (this.ppower != this.tile.cpower) {
                this.ppower = this.tile.cpower;
                dos.writeByte(101);
                dos.writeShort(this.tile.cpower);
            }
            if (this.precipe != this.tile.cur_recipe) {
                this.precipe = this.tile.cur_recipe;
                dos.writeByte(102);
                dos.writeByte(this.tile.cur_recipe);
            }
            if (dos.size() > 0) {
                dos.writeByte(-1);
                for (int j = 0; j < this.field_75149_d.size(); ++j) {
                    PacketHandler.sendPacketToPlayer(new YogpstopPacket(this, bos.toByteArray()), (EntityPlayer)this.field_75149_d.get(j));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void receivePacket(byte[] ba) throws IOException {
        byte slot;
        ByteArrayDataInput bb = ByteStreams.newDataInput((byte[])ba);
        while ((slot = bb.readByte()) >= 0) {
            if (slot == 101) {
                this.tile.cpower = bb.readShort();
                continue;
            }
            if (slot == 102) {
                this.tile.cur_recipe = bb.readByte();
                continue;
            }
            this.func_75139_a(slot).func_75215_d(ContainerWorkbench.readItemStack(bb));
        }
    }

    protected void func_94533_d() {
        this.drag_state = 0;
        this.dragged.clear();
    }

    public static boolean canDrag(Slot slot, ItemStack is, boolean always_true) {
        boolean can;
        boolean bl = can = slot == null || !slot.func_75216_d();
        if (slot != null && slot.func_75216_d() && is != null && is.func_77969_a(slot.func_75211_c()) && ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)is)) {
            int i = always_true ? 0 : is.field_77994_a;
            can |= slot.func_75211_c().field_77994_a + i <= (slot instanceof SlotUnlimited ? slot.func_75219_a() : is.func_77976_d());
        }
        return can;
    }

    public ItemStack func_75144_a(int i, int param, int type, EntityPlayer ep) {
        Slot c;
        if (0 < i && i <= this.field_75151_b.size() && (c = (Slot)this.field_75151_b.get(i)) instanceof SlotWorkbench) {
            if (type == 0 && c.func_75216_d()) {
                this.tile.cur_recipe = c.getSlotIndex();
                this.tile.func_70296_d();
            }
            return null;
        }
        ItemStack ret = null;
        InventoryPlayer player_inv = ep.field_71071_by;
        if (type == 5) {
            int prev_drag_state = this.drag_state;
            this.drag_state = ContainerWorkbench.func_94532_c((int)param);
            if ((prev_drag_state != 1 || this.drag_state != 2) && prev_drag_state != this.drag_state) {
                this.func_94533_d();
            } else if (player_inv.func_70445_o() == null) {
                this.func_94533_d();
            } else if (this.drag_state == 0) {
                this.field_94535_f = ContainerWorkbench.func_94529_b((int)param);
                if (ContainerWorkbench.func_94528_d((int)this.field_94535_f)) {
                    this.drag_state = 1;
                    this.dragged.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.drag_state == 1) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot != null && ContainerWorkbench.canDrag(slot, player_inv.func_70445_o(), true) && slot.func_75214_a(player_inv.func_70445_o()) && player_inv.func_70445_o().field_77994_a > this.dragged.size() && this.func_94531_b(slot)) {
                    this.dragged.add(slot);
                }
            } else if (this.drag_state == 2) {
                if (!this.dragged.isEmpty()) {
                    ItemStack player_stack = player_inv.func_70445_o().func_77946_l();
                    int i1 = player_inv.func_70445_o().field_77994_a;
                    for (Slot slot : this.dragged) {
                        if (slot == null || !ContainerWorkbench.canDrag(slot, player_inv.func_70445_o(), true) || !slot.func_75214_a(player_inv.func_70445_o()) || player_inv.func_70445_o().field_77994_a < this.dragged.size() || !this.func_94531_b(slot)) continue;
                        ItemStack slot_stack = player_stack.func_77946_l();
                        int j1 = slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
                        ContainerWorkbench.func_94525_a(this.dragged, (int)this.field_94535_f, (ItemStack)slot_stack, (int)j1);
                        if (!(slot instanceof SlotUnlimited) && slot_stack.field_77994_a > slot_stack.func_77976_d()) {
                            slot_stack.field_77994_a = slot_stack.func_77976_d();
                        }
                        if (slot_stack.field_77994_a > slot.func_75219_a()) {
                            slot_stack.field_77994_a = slot.func_75219_a();
                        }
                        i1 -= slot_stack.field_77994_a - j1;
                        slot.func_75215_d(slot_stack);
                    }
                    player_stack.field_77994_a = i1;
                    if (player_stack.field_77994_a <= 0) {
                        player_stack = null;
                    }
                    player_inv.func_70437_b(player_stack);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.drag_state != 0) {
            this.func_94533_d();
        } else if (!(type != 0 && type != 1 || param != 0 && param != 1)) {
            if (i == -999) {
                if (player_inv.func_70445_o() != null && i == -999) {
                    if (param == 0) {
                        ep.func_71019_a(player_inv.func_70445_o(), true);
                        player_inv.func_70437_b(null);
                    }
                    if (param == 1) {
                        ep.func_71019_a(player_inv.func_70445_o().func_77979_a(1), true);
                        if (player_inv.func_70445_o().field_77994_a == 0) {
                            player_inv.func_70437_b(null);
                        }
                    }
                }
            } else if (type == 1) {
                ItemStack itemstack3;
                if (i < 0) {
                    return null;
                }
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot != null && slot.func_82869_a(ep) && (itemstack3 = this.func_82846_b(ep, i)) != null) {
                    Item item = itemstack3.func_77973_b();
                    ret = itemstack3.func_77946_l();
                    if (slot.func_75211_c() != null && slot.func_75211_c().func_77973_b() == item) {
                        this.func_75133_b(i, param, true, ep);
                    }
                }
            } else {
                if (i < 0) {
                    return null;
                }
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot != null) {
                    ItemStack slot_stack = slot.func_75211_c();
                    ItemStack player_stack = player_inv.func_70445_o();
                    if (slot_stack != null) {
                        ret = slot_stack.func_77946_l();
                    }
                    if (slot_stack == null) {
                        if (player_stack != null && slot.func_75214_a(player_stack)) {
                            int l1;
                            int n = l1 = param == 0 ? player_stack.field_77994_a : 1;
                            if (l1 > slot.func_75219_a()) {
                                l1 = slot.func_75219_a();
                            }
                            if (player_stack.field_77994_a >= l1) {
                                slot.func_75215_d(player_stack.func_77979_a(l1));
                            }
                            if (player_stack.field_77994_a == 0) {
                                player_inv.func_70437_b(null);
                            }
                        }
                    } else if (slot.func_82869_a(ep)) {
                        int add2player;
                        if (player_stack == null) {
                            int l1 = param == 0 ? slot_stack.field_77994_a : (slot_stack.field_77994_a + 1) / 2;
                            player_inv.func_70437_b(slot.func_75209_a(l1));
                            if (slot_stack.field_77994_a == 0) {
                                slot.func_75215_d(null);
                            }
                            slot.func_82870_a(ep, player_inv.func_70445_o());
                        } else if (slot.func_75214_a(player_stack)) {
                            if (slot_stack.func_77973_b() == player_stack.func_77973_b() && slot_stack.func_77960_j() == player_stack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slot_stack, (ItemStack)player_stack)) {
                                int player2slot;
                                int n = player2slot = param == 0 ? player_stack.field_77994_a : 1;
                                if (player2slot > slot.func_75219_a() - slot_stack.field_77994_a) {
                                    player2slot = slot.func_75219_a() - slot_stack.field_77994_a;
                                }
                                if (!(slot instanceof SlotUnlimited) && player2slot > player_stack.func_77976_d() - slot_stack.field_77994_a) {
                                    player2slot = player_stack.func_77976_d() - slot_stack.field_77994_a;
                                }
                                player_stack.field_77994_a -= player2slot;
                                if (player_stack.field_77994_a == 0) {
                                    player_inv.func_70437_b(null);
                                }
                                slot_stack.field_77994_a += player2slot;
                            } else if (player_stack.field_77994_a <= slot.func_75219_a()) {
                                slot.func_75215_d(player_stack);
                                player_inv.func_70437_b(slot_stack);
                            }
                        } else if (slot_stack.func_77973_b() == player_stack.func_77973_b() && player_stack.func_77976_d() > 1 && (!slot_stack.func_77981_g() || slot_stack.func_77960_j() == player_stack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slot_stack, (ItemStack)player_stack) && (add2player = slot_stack.field_77994_a) > 0 && add2player + player_stack.field_77994_a <= player_stack.func_77976_d()) {
                            player_stack.field_77994_a += add2player;
                            slot_stack = slot.func_75209_a(add2player);
                            if (slot_stack.field_77994_a == 0) {
                                slot.func_75215_d(null);
                            }
                            slot.func_82870_a(ep, player_inv.func_70445_o());
                        }
                    }
                    slot.func_75218_e();
                }
            }
        } else if (type == 2 && param >= 0 && param < 9) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot.func_82869_a(ep)) {
                ItemStack player_stack = player_inv.func_70301_a(param);
                boolean can2player = player_stack == null || slot.field_75224_c == player_inv && slot.func_75214_a(player_stack);
                int first_empty = -1;
                if (!can2player) {
                    first_empty = player_inv.func_70447_i();
                    can2player |= first_empty > -1;
                }
                if (slot.func_75216_d() && can2player) {
                    ItemStack slot_stack = slot.func_75211_c();
                    player_inv.func_70299_a(param, slot_stack.func_77946_l());
                    if (!(slot.field_75224_c == player_inv && slot.func_75214_a(player_stack) || player_stack == null)) {
                        if (first_empty > -1) {
                            player_inv.func_70441_a(player_stack);
                            slot.func_75209_a(slot_stack.field_77994_a);
                            slot.func_75215_d(null);
                            slot.func_82870_a(ep, slot_stack);
                        }
                    } else {
                        slot.func_75209_a(slot_stack.field_77994_a);
                        slot.func_75215_d(player_stack);
                        slot.func_82870_a(ep, slot_stack);
                    }
                } else if (!slot.func_75216_d() && player_stack != null && slot.func_75214_a(player_stack)) {
                    player_inv.func_70299_a(param, null);
                    slot.func_75215_d(player_stack);
                }
            }
        } else if (type == 3 && ep.field_71075_bZ.field_75098_d && player_inv.func_70445_o() == null && i >= 0) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot != null && slot.func_75216_d()) {
                ItemStack player_stack = slot.func_75211_c().func_77946_l();
                player_stack.field_77994_a = player_stack.func_77976_d();
                player_inv.func_70437_b(player_stack);
            }
        } else if (type == 4 && player_inv.func_70445_o() == null && i >= 0) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot != null && slot.func_75216_d() && slot.func_82869_a(ep)) {
                ItemStack drop_stack = slot.func_75209_a(param == 0 ? 1 : slot.func_75211_c().field_77994_a);
                slot.func_82870_a(ep, drop_stack);
                ep.func_71019_a(drop_stack, true);
            }
        } else if (type == 6 && i >= 0) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack player_stack = player_inv.func_70445_o();
            if (!(player_stack == null || slot != null && slot.func_75216_d() && slot.func_82869_a(ep))) {
                int i1 = param == 0 ? 0 : this.field_75151_b.size() - 1;
                int l1 = param == 0 ? 1 : -1;
                for (int i2 = 0; i2 < 2; ++i2) {
                    for (int j2 = i1; j2 >= 0 && j2 < this.field_75151_b.size() && player_stack.field_77994_a < player_stack.func_77976_d(); j2 += l1) {
                        Slot slot3 = (Slot)this.field_75151_b.get(j2);
                        if (!slot3.func_75216_d() || !ContainerWorkbench.canDrag(slot3, player_stack, true) || !slot3.func_82869_a(ep) || !this.func_94530_a(player_stack, slot3) || i2 == 0 && slot3.func_75211_c().field_77994_a == slot3.func_75211_c().func_77976_d()) continue;
                        int k1 = Math.min(player_stack.func_77976_d() - player_stack.field_77994_a, slot3.func_75211_c().field_77994_a);
                        ItemStack itemstack2 = slot3.func_75209_a(k1);
                        player_stack.field_77994_a += k1;
                        if (itemstack2.field_77994_a <= 0) {
                            slot3.func_75215_d(null);
                        }
                        slot3.func_82870_a(ep, itemstack2);
                    }
                }
            }
            this.func_75142_b();
        }
        return ret;
    }

    protected boolean func_75135_a(ItemStack is, int from, int to, boolean invert) {
        ItemStack slot_stack;
        Slot slot;
        int k;
        boolean changed = false;
        int n = k = invert ? to - 1 : from;
        if (is.func_77985_e()) {
            while (is.field_77994_a > 0 && (!invert && k < to || invert && k >= from)) {
                slot = (Slot)this.field_75151_b.get(k);
                slot_stack = slot.func_75211_c();
                if (slot_stack != null && slot_stack.func_77973_b() == is.func_77973_b() && (!is.func_77981_g() || is.func_77960_j() == slot_stack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)slot_stack)) {
                    int total = slot_stack.field_77994_a + is.field_77994_a;
                    if (!(slot instanceof SlotUnlimited) && total > slot_stack.func_77976_d()) {
                        total = slot_stack.func_77976_d();
                    }
                    if (total > slot.func_75219_a()) {
                        total = slot.func_75219_a();
                    }
                    if (total > slot_stack.field_77994_a) {
                        is.field_77994_a = slot_stack.field_77994_a + is.field_77994_a - total;
                        slot_stack.field_77994_a = total;
                        slot.func_75218_e();
                        changed = true;
                    }
                }
                if (invert) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        int n2 = k = invert ? to - 1 : from;
        while (is.field_77994_a > 0 && (!invert && k < to || invert && k >= from)) {
            slot = (Slot)this.field_75151_b.get(k);
            if (slot.func_75211_c() == null) {
                slot_stack = is.func_77946_l();
                if (!(slot instanceof SlotUnlimited) && slot_stack.field_77994_a > slot_stack.func_77976_d()) {
                    slot_stack.field_77994_a = slot_stack.func_77976_d();
                }
                if (slot_stack.field_77994_a > slot.func_75219_a()) {
                    slot_stack.field_77994_a = slot.func_75219_a();
                }
                slot.func_75215_d(slot_stack);
                slot.func_75218_e();
                is.field_77994_a -= slot_stack.field_77994_a;
                changed = true;
            }
            if (invert) {
                --k;
                continue;
            }
            ++k;
        }
        return changed;
    }
}

