/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WorkbenchRecipe {
    public static double difficulty;
    private static final List<WorkbenchRecipe> recipes;
    public final WBIS[] input;
    public final ItemStack output;
    public final double power;

    private WorkbenchRecipe(ItemStack out, double p, ItemStack ... in) {
        this.input = WBIS.convert(in);
        this.output = out;
        this.power = p;
    }

    public static void addRecipe(ItemStack out, double p, ItemStack ... in) {
        recipes.add(new WorkbenchRecipe(out, p, in));
    }

    public static List<WorkbenchRecipe> getRecipes() {
        return recipes;
    }

    public boolean check(ItemStack[] sinv) {
        for (WBIS raw : this.input) {
            int miss = raw.getAmount();
            for (int i = 0; i < 27 && miss > 0; ++i) {
                ItemStack is = sinv[i];
                if (is == null || is.field_77994_a <= 0 || is.func_77973_b() != raw.item || is.func_77960_j() != raw.meta || is.field_77990_d == null && raw.tag != null || is.field_77990_d != null && !is.field_77990_d.equals((Object)raw.tag)) continue;
                int toMove = Math.min(is.field_77994_a, miss);
                is.field_77994_a -= toMove;
                miss -= toMove;
            }
            if (miss <= 0) continue;
            return false;
        }
        return true;
    }

    public static int getRecipes(ItemStack[] inv, WorkbenchRecipe[] rs, int p) {
        WorkbenchRecipe prev = p > 0 ? rs[p] : null;
        Arrays.fill(rs, null);
        Arrays.fill(inv, 27, 45, null);
        int cur = 27;
        for (WorkbenchRecipe r : recipes) {
            ItemStack[] sinv = new ItemStack[27];
            for (int i = 0; i < sinv.length; ++i) {
                if (inv[i] == null) continue;
                sinv[i] = inv[i].func_77946_l();
            }
            if (!r.check(sinv)) continue;
            inv[cur] = r.output.func_77946_l();
            rs[cur] = r;
            ++cur;
        }
        if (prev != null) {
            for (int i = 27; i < 45; ++i) {
                if (rs[i] != prev) continue;
                return i;
            }
        }
        return -1;
    }

    static {
        recipes = new ArrayList<WorkbenchRecipe>();
    }

    public static final class WBIS {
        public final double weight;
        public final Item item;
        public final NBTTagCompound tag;
        public final int meta;

        private WBIS(ItemStack is) {
            this.weight = (double)is.field_77994_a / 50.0;
            this.item = is.func_77973_b();
            this.tag = is.field_77990_d != null ? (NBTTagCompound)is.field_77990_d.func_74737_b() : null;
            this.meta = is.func_77960_j();
        }

        static WBIS[] convert(ItemStack[] s) {
            WBIS[] r = new WBIS[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = new WBIS(s[i]);
            }
            return r;
        }

        public int getAmount() {
            return (int)Math.floor(difficulty * this.weight);
        }

        public ItemStack getItemStack() {
            ItemStack ret = new ItemStack(this.item, this.getAmount(), this.meta);
            ret.func_77982_d(this.tag);
            return ret;
        }
    }
}

