/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.TileMiningWell;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PowerManager {
    private static double B_CF;
    private static double B_CS;
    private static double W_CF;
    private static double W_CS;
    private static double B_BP;
    private static double B_CE;
    private static double B_CU;
    private static double B_XR;
    private static double B_MS;
    private static double F_BP;
    private static double F_CE;
    private static double F_CU;
    private static double F_XR;
    private static double F_MS;
    private static double W_BP;
    private static double W_CE;
    private static double W_CU;
    private static double W_XR;
    private static double W_MS;
    private static double L_BP;
    private static double L_CE;
    private static double L_CU;
    private static double L_XR;
    private static double L_MS;
    private static double L_CF;
    private static double L_CS;
    private static double R_CE;
    private static double R_CU;
    private static double R_XR;
    private static double R_MS;
    private static double PF_BP;
    private static double PF_CU;
    private static double PL_BP;
    private static double PL_CU;
    private static double H_BP;
    private static double H_CU;

    private static double get(ConfigCategory c, String name, double def) {
        if (c.containsKey(name)) {
            Property prop = c.get(name);
            if (prop.getType() == null) {
                prop = new Property(prop.getName(), prop.getString(), Property.Type.DOUBLE);
                c.put(name, prop);
            }
            return prop.getDouble(def);
        }
        Property prop = new Property(name, Double.toString(def), Property.Type.DOUBLE);
        c.put(name, prop);
        return prop.getDouble(def);
    }

    static void loadConfiguration(Configuration cg) throws RuntimeException {
        String cn = "general" + "." + "PowerSetting" + ".";
        String cn2 = cn + "Quarry" + ".";
        ConfigCategory c = cg.getCategory(cn2 + "BreakBlock");
        B_BP = PowerManager.get(c, "BasePower", 40.0);
        B_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        B_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        B_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        B_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        B_XR = PowerManager.get(c, "BaseMaxRecieve", 300.0);
        B_MS = PowerManager.get(c, "BaseMaxStored", 15000.0);
        c = cg.getCategory(cn2 + "BreakBlock" + "." + "MoveHead");
        H_BP = PowerManager.get(c, "BasePower", 200.0);
        H_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        F_BP = PowerManager.get(c, "BasePower", 25.0);
        F_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        F_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        F_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        F_MS = PowerManager.get(c, "BaseMaxStored", 15000.0);
        cn2 = cn + "Pump" + ".";
        c = cg.getCategory(cn2 + "DrainLiquid");
        PL_BP = PowerManager.get(c, "BasePower", 10.0);
        PL_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        PF_BP = PowerManager.get(c, "BasePower", 25.0);
        PF_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn + "MiningWell");
        W_BP = PowerManager.get(c, "BasePower", 40.0);
        W_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        W_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        W_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        W_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        W_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        W_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
        c = cg.getCategory(cn + "Laser");
        L_BP = PowerManager.get(c, "BasePower", 4.0);
        L_CE = PowerManager.get(c, "EfficiencyCoefficient", 2.0);
        L_CU = PowerManager.get(c, "UnbreakingCoefficient", 0.1);
        L_CF = PowerManager.get(c, "FortuneCoefficient", 1.05);
        L_CS = PowerManager.get(c, "SilktouchCoefficient", 1.1);
        L_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        L_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
        c = cg.getCategory(cn + "Refinery");
        R_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        R_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        R_XR = PowerManager.get(c, "BaseMaxRecieve", 100.0);
        R_MS = PowerManager.get(c, "BaseMaxStored", 1000.0);
        StringBuilder sb = new StringBuilder();
        if (B_BP < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.BasePower value is bad.\n");
        }
        if (B_CE < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.EfficiencyCoefficient value is bad.\n");
        }
        if (B_CU < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.UnbreakingCoefficient value is bad.\n");
        }
        if (B_CF < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.FortuneCoefficient value is bad.\n");
        }
        if (B_CS < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.SilktouchCoefficient value is bad.\n");
        }
        if (B_MS <= 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.BaseMaxStored value is bad.\n");
        }
        if (H_BP < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.MoveHead.BasePower value is bad.\n");
        }
        if (H_CU < 0.0) {
            sb.append("general.PowerSetting.Quarry.BreakBlock.MoveHead.UnbreakingCoefficient value is bad.\n");
        }
        if (F_BP < 0.0) {
            sb.append("general.PowerSetting.Quarry.MakeFrame.BasePower value is bad.\n");
        }
        if (F_CE < 0.0) {
            sb.append("general.PowerSetting.Quarry.MakeFrame.EfficiencyCoefficient value is bad.\n");
        }
        if (F_CU < 0.0) {
            sb.append("general.PowerSetting.Quarry.MakeFrame.UnbreakingCoefficient value is bad.\n");
        }
        if (F_MS <= 0.0) {
            sb.append("general.PowerSetting.Quarry.MakeFrame.BaseMaxStored value is bad.\n");
        }
        if (PL_BP < 0.0) {
            sb.append("general.PowerSetting.Pump.DrainLiquid.BasePower value is bad.\n");
        }
        if (PL_CU < 0.0) {
            sb.append("general.PowerSetting.Pump.DrainLiquid.UnbreakingCoefficient value is bad.\n");
        }
        if (PF_BP < 0.0) {
            sb.append("general.PowerSetting.Pump.MakeFrame.BasePower value is bad.\n");
        }
        if (PF_CU < 0.0) {
            sb.append("general.PowerSetting.Pump.MakeFrame.UnbreakingCoefficient value is bad.\n");
        }
        if (W_BP < 0.0) {
            sb.append("general.PowerSetting.MiningWell.BasePower value is bad.\n");
        }
        if (W_CE < 0.0) {
            sb.append("general.PowerSetting.MiningWell.EfficiencyCoefficient value is bad.\n");
        }
        if (W_CU < 0.0) {
            sb.append("general.PowerSetting.MiningWell.UnbreakingCoefficient value is bad.\n");
        }
        if (W_CF < 0.0) {
            sb.append("general.PowerSetting.MiningWell.FortuneCoefficient value is bad.\n");
        }
        if (W_CS < 0.0) {
            sb.append("general.PowerSetting.MiningWell.SilktouchCoefficient value is bad.\n");
        }
        if (W_MS <= 0.0) {
            sb.append("general.PowerSetting.MiningWell.BaseMaxStored value is bad.\n");
        }
        if (L_BP < 0.0) {
            sb.append("general.PowerSetting.Laser.BasePower value is bad.\n");
        }
        if (L_CE < 0.0) {
            sb.append("general.PowerSetting.Laser.EfficiencyCoefficient value is bad.\n");
        }
        if (L_CU < 0.0) {
            sb.append("general.PowerSetting.Laser.UnbreakingCoefficient value is bad.\n");
        }
        if (L_CF < 0.0) {
            sb.append("general.PowerSetting.Laser.FortuneCoefficient value is bad.\n");
        }
        if (L_CS < 0.0) {
            sb.append("general.PowerSetting.Laser.SilktouchCoefficient value is bad.\n");
        }
        if (L_MS <= 0.0) {
            sb.append("general.PowerSetting.Laser.BaseMaxStored value is bad.\n");
        }
        if (R_CE < 0.0) {
            sb.append("general.PowerSetting.Refinery.EfficiencyCoefficient value is bad.\n");
        }
        if (R_CU < 0.0) {
            sb.append("general.PowerSetting.Refinery.UnbreakingCoefficient value is bad.\n");
        }
        if (R_MS <= 0.0) {
            sb.append("general.PowerSetting.Refinery.BaseMaxStored value is bad.\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
    }

    public static void configure0(APowerTile pp) {
        pp.configure(0.0, pp.getMaxStored());
    }

    private static void configure(APowerTile pp, double CE, byte E, byte U, double CU, double XR, double MS, byte pump) {
        pp.configure(XR * Math.pow(CE, E) / ((double)U * CU + 1.0), MS * Math.pow(CE, E) / ((double)U * CU + 1.0) + (pump > 0 ? 65536.0 * PL_BP / ((double)pump * PL_CU + 1.0) + 1020.0 * PF_BP / ((double)pump * PF_CU + 1.0) : 0.0));
    }

    private static void configure15(APowerTile pp, double CE, byte E, byte U, double CU, double XR, double MS, byte pump) {
        pp.configure(XR * Math.pow(CE, E) / ((double)U * CU + 1.0), MS * Math.pow(CE, E) / ((double)U * CU + 1.0) + (pump > 0 ? 65536.0 * PL_BP / ((double)pump * PL_CU + 1.0) + 1020.0 * PF_BP / ((double)pump * PF_CU + 1.0) : 0.0));
    }

    public static void configureB(APowerTile pp, byte E, byte U, byte pump) {
        PowerManager.configure15(pp, B_CE, E, U, B_CU, B_XR, B_MS, pump);
    }

    public static void configureW(APowerTile pp, byte E, byte U, byte pump) {
        PowerManager.configure15(pp, W_CE, E, U, W_CU, W_XR, W_MS, pump);
    }

    public static void configureL(APowerTile pp, byte E, byte U) {
        PowerManager.configure(pp, L_CE, E, U, L_CU, L_XR, L_MS, (byte)0);
    }

    public static void configureF(APowerTile pp, byte E, byte U, byte pump) {
        PowerManager.configure(pp, F_CE, E, U, F_CU, F_XR, F_MS, pump);
    }

    public static void configureR(APowerTile pp, byte E, byte U) {
        PowerManager.configure(pp, R_CE, E, U, R_CU, R_XR, R_MS, (byte)0);
    }

    public static boolean useEnergyB(APowerTile pp, float H, byte SF, byte U) {
        double CSP;
        double CU;
        double BP;
        if (pp instanceof TileMiningWell) {
            BP = W_BP;
            CU = W_CU;
            CSP = SF < 0 ? W_CS : Math.pow(W_CF, SF);
        } else {
            BP = B_BP;
            CU = B_CU;
            CSP = SF < 0 ? B_CS : Math.pow(B_CF, SF);
        }
        double pw = BP * (double)H * CSP / ((double)U * CU + 1.0);
        if (pp.useEnergy(pw, pw, false) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true);
        return true;
    }

    public static boolean useEnergyP(APowerTile pp, byte U, long liquids, long frames) {
        double pw = PL_BP * (double)liquids / ((double)U * PL_CU + 1.0) + PF_BP * (double)frames / ((double)U * PF_CU + 1.0);
        if (pp.useEnergy(pw, pw, false) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true);
        return true;
    }

    private static boolean useEnergy(APowerTile pp, double BP, byte U, double CU, byte E, double CE) {
        double pw = BP / Math.pow(CE, E) / ((double)U * CU + 1.0);
        if (pp.useEnergy(pw, pw, false) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true);
        return true;
    }

    public static boolean useEnergyF(APowerTile pp, byte U) {
        return PowerManager.useEnergy(pp, F_BP, U, F_CU, (byte)0, 1.0);
    }

    public static boolean useEnergyR(APowerTile pp, double BP, byte U, byte E) {
        return PowerManager.useEnergy(pp, BP, U, R_CU, E, R_CE);
    }

    public static double useEnergyH(APowerTile pp, double dist, byte U) {
        double pw = Math.min(2.0 + pp.getStoredEnergy() / 500.0, (dist - 0.1) * H_BP / ((double)U * H_CU + 1.0));
        pw = pp.useEnergy(0.0, pw, true);
        return pw * ((double)U * H_CU + 1.0) / H_BP + 0.1;
    }

    public static double useEnergyL(APowerTile pp, byte U, byte F, boolean S, byte E) {
        double pw = L_BP * Math.pow(L_CF, F) * Math.pow(L_CE, E) / ((double)U * L_CU + 1.0);
        if (S) {
            pw *= L_CS;
        }
        pw = pp.useEnergy(0.0, pw, true);
        if (S) {
            pw /= L_CS;
        }
        return pw * ((double)U * L_CU + 1.0) / Math.pow(L_CF, F);
    }
}

