/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.parts.layers.InvSot;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class InvLayerData {
    private static final int[] NULL_SIDES = new int[0];
    private final int[][] sides;
    private final List<ISidedInventory> inventories;
    private final List<InvSot> slots;

    public InvLayerData(int[][] a, List<ISidedInventory> b, List<InvSot> c) {
        this.sides = a;
        this.inventories = b;
        this.slots = c;
    }

    ItemStack decreaseStackSize(int slot, int amount) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).decreaseStackSize(amount);
        }
        return null;
    }

    private boolean isSlotValid(int slot) {
        return this.slots != null && slot >= 0 && slot < this.slots.size();
    }

    int getSizeInventory() {
        if (this.slots == null) {
            return 0;
        }
        return this.slots.size();
    }

    ItemStack getStackInSlot(int slot) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).getStackInSlot();
        }
        return null;
    }

    boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).isItemValidForSlot(itemstack);
        }
        return false;
    }

    void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (this.isSlotValid(slot)) {
            this.slots.get(slot).setInventorySlotContents(itemstack);
        }
    }

    boolean canExtractItem(int slot, ItemStack itemstack, int side) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).canExtractItem(itemstack, side);
        }
        return false;
    }

    boolean canInsertItem(int slot, ItemStack itemstack, int side) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).canInsertItem(itemstack, side);
        }
        return false;
    }

    void markDirty() {
        if (this.inventories != null) {
            for (IInventory iInventory : this.inventories) {
                iInventory.func_70296_d();
            }
        }
    }

    int[] getAccessibleSlotsFromSide(int side) {
        if (this.sides == null || side < 0 || side > 5) {
            return NULL_SIDES;
        }
        return this.sides[side];
    }
}

