/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.worlddata.IWorldPlayerMapping;
import appeng.core.worlddata.PlayerMappingsInitializer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;

final class PlayerMapping
implements IWorldPlayerMapping {
    private final Map<Integer, UUID> mappings;

    public PlayerMapping(ConfigCategory category) {
        PlayerMappingsInitializer init = new PlayerMappingsInitializer(category);
        this.mappings = init.getPlayerMappings();
    }

    @Override
    @Nonnull
    public Optional<UUID> get(int id) {
        UUID maybe = this.mappings.get(id);
        return Optional.fromNullable((Object)maybe);
    }

    @Override
    public void put(int id, @Nonnull UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        this.mappings.put(id, uuid);
    }
}

