/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.util.AEColor;
import appeng.block.qnb.BlockQuantumBase;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.qnb.TileQuantumBridge;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderQNB
extends BaseBlockRender<BlockQuantumBase, TileQuantumBridge> {
    private static final float DEFAULT_RENDER_MIN = 0.125f;
    private static final float DEFAULT_RENDER_MAX = 0.875f;
    private static final float CORNER_POWERED_RENDER_MIN = 0.24375f;
    private static final float CORNER_POWERED_RENDER_MAX = 0.75625f;
    private static final float CENTER_POWERED_RENDER_MIN = -6.25E-4f;
    private static final float CENTER_POWERED_RENDER_MAX = 1.000625f;

    @Override
    public void renderInventory(BlockQuantumBase block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.func_147782_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        super.renderInventory(block, item, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(BlockQuantumBase block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileQuantumBridge tqb = (TileQuantumBridge)block.getTileEntity(world, x, y, z);
        if (tqb == null) {
            return false;
        }
        renderer.field_147837_f = true;
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        for (Block linkBlock : blocks.quantumLink().maybeBlock().asSet()) {
            if (tqb.func_145838_q() == linkBlock) {
                if (tqb.isFormed()) {
                    EnumSet<ForgeDirection> sides = tqb.getConnections();
                    Item transGlassCable = parts.cableGlass().item(AEColor.Transparent);
                    this.renderCableAt(0.11, world, x, y, z, block, renderer, transGlassCable.func_77650_f(parts.cableGlass().stack(AEColor.Transparent, 1)), 0.141, sides);
                    Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                    this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.func_77650_f(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.1875, sides);
                }
                renderer.func_147782_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.func_147784_q((Block)block, x, y, z);
                continue;
            }
            if (!tqb.isFormed()) {
                renderer.func_147782_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.func_147784_q((Block)block, x, y, z);
                continue;
            }
            if (tqb.isCorner()) {
                Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.func_77650_f(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.05, tqb.getConnections());
                renderer.func_147782_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.func_147784_q((Block)block, x, y, z);
                if (!tqb.isPowered()) continue;
                renderer.func_147782_a((double)0.24375f, (double)0.24375f, (double)0.24375f, (double)0.75625f, (double)0.75625f, (double)0.75625f);
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                int bn = 15;
                Tessellator.field_78398_a.func_78380_c(0xF000F0);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(x, y, z, block, ExtraBlockTextures.BlockQRingCornerLight.getIcon(), renderer, side);
                }
                continue;
            }
            renderer.func_147782_a(0.0, 0.125, 0.125, 1.0, 0.875, 0.875);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.func_147782_a(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.func_147782_a(0.125, 0.125, 0.0, 0.875, 0.875, 1.0);
            renderer.func_147784_q((Block)block, x, y, z);
            if (!tqb.isPowered()) continue;
            renderer.func_147782_a((double)-6.25E-4f, (double)-6.25E-4f, (double)-6.25E-4f, (double)1.000625f, (double)1.000625f, (double)1.000625f);
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            int bn = 15;
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.renderFace(x, y, z, block, ExtraBlockTextures.BlockQRingEdgeLight.getIcon(), renderer, side);
            }
        }
        renderer.field_147837_f = false;
        return true;
    }

    private void renderCableAt(double thickness, IBlockAccess world, int x, int y, int z, BlockQuantumBase block, RenderBlocks renderer, IIcon texture, double pull, Collection<ForgeDirection> connections) {
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (connections.contains(ForgeDirection.UNKNOWN)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.5 - thickness, 0.5 + thickness, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.WEST)) {
            renderer.func_147782_a(0.0, 0.5 - thickness, 0.5 - thickness, 0.5 - thickness - pull, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.EAST)) {
            renderer.func_147782_a(0.5 + thickness + pull, 0.5 - thickness, 0.5 - thickness, 1.0, 0.5 + thickness, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.NORTH)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.0, 0.5 + thickness, 0.5 + thickness, 0.5 - thickness - pull);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.SOUTH)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 - thickness, 0.5 + thickness + pull, 0.5 + thickness, 0.5 + thickness, 1.0);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.DOWN)) {
            renderer.func_147782_a(0.5 - thickness, 0.0, 0.5 - thickness, 0.5 + thickness, 0.5 - thickness - pull, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.UP)) {
            renderer.func_147782_a(0.5 - thickness, 0.5 + thickness + pull, 0.5 - thickness, 0.5 + thickness, 1.0, 0.5 + thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        block.getRendererInstance().setTemporaryRenderIcon(null);
    }
}

