/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.worldgen;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedWriter;
import java.util.Map;
import mrdimka.craft.conveyor.worldgen.BlockStack;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class IStructure {
    public abstract Map<ChunkCoordinates, BlockStack> getStructureMap();

    public abstract void setStructureMap(Map<ChunkCoordinates, BlockStack> var1);

    public abstract Map<ChunkCoordinates, NBTTagCompound> getNBTMap();

    public abstract void setNBTMap(Map<ChunkCoordinates, NBTTagCompound> var1);

    public abstract void build(World var1, int var2, int var3, int var4, Object ... var5);

    public static void writeToBuffer(IStructure structure, BufferedWriter writer) {
        try {
            Map<ChunkCoordinates, BlockStack> map = structure.getStructureMap();
            Map<ChunkCoordinates, NBTTagCompound> NBTmap = structure.getNBTMap();
            for (ChunkCoordinates coord : map.keySet()) {
                try {
                    String valueNBT;
                    String key = "pos_" + coord.field_71574_a + ", " + coord.field_71572_b + ", " + coord.field_71573_c;
                    GameRegistry.UniqueIdentifier ident = GameRegistry.findUniqueIdentifierFor((Block)map.get((Object)coord).blockIn);
                    String value = ident.modId + ":" + ident.name + "@" + map.get((Object)coord).metaIn;
                    writer.write(key + " = " + value);
                    writer.newLine();
                    NBTTagCompound nbt = NBTmap.get(coord);
                    String keyNBT = "nbt_" + coord.field_71574_a + ", " + coord.field_71572_b + ", " + coord.field_71573_c;
                    String string = valueNBT = nbt != null ? nbt.toString() : "";
                    if (nbt != null) {
                        writer.write(keyNBT + " = " + valueNBT);
                    }
                    if (nbt == null) continue;
                    writer.newLine();
                }
                catch (Throwable err) {}
            }
            writer.write("class = " + structure.getClass().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

