/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.common.utils;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static boolean areItemStacksEqualIgnoreStackSize(ItemStack s1, ItemStack s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.func_77973_b() == s2.func_77973_b() && s1.func_77960_j() == s2.func_77960_j() && (s1.field_77990_d == null && s2.field_77990_d == null || s1.field_77990_d != null && s2.field_77990_d != null && s1.field_77990_d.equals((Object)s2.field_77990_d));
    }

    public static boolean areItemStacksEqualIgnoreStackSize(ItemStack s1, ItemStack s2, boolean ignoreNBT, boolean ignoreMetadata, boolean includeOreDictionary) {
        boolean NBTMatches;
        boolean itemsMatches = s1 == null && s2 == null || s1 != null && s2 != null && s1.func_77973_b() == s2.func_77973_b();
        boolean metaMatches = ignoreMetadata || s1 == null && s2 == null || s1 != null && s2 != null && s1.func_77960_j() == s2.func_77960_j();
        boolean bl = NBTMatches = ignoreNBT || s1 == null && s2 == null || s1 != null && s2 != null && (s1.field_77990_d == null && s2.field_77990_d == null || s1.field_77990_d != null && s2.field_77990_d != null && s1.field_77990_d.equals((Object)s2.field_77990_d));
        boolean completeMach = (includeOreDictionary ? Util.itemsMatchViaOreDictionary(s1, s2) : itemsMatches) && metaMatches && NBTMatches;
        return completeMach;
    }

    public static boolean itemsMatchViaOreDictionary(ItemStack i1, ItemStack i2) {
        String[] oresI1 = Util.getOreNames(i1);
        String[] oresI2 = Util.getOreNames(i2);
        if (oresI1.length == 0 && oresI2.length == 0) {
            return true;
        }
        for (String o1 : oresI1) {
            for (String o2 : oresI2) {
                if (!o1.equalsIgnoreCase(o2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getOreNames(ItemStack stack) {
        int[] ores = OreDictionary.getOreIDs((ItemStack)stack);
        String[] oreS = new String[ores.length];
        for (int i = 0; i < ores.length; ++i) {
            oreS[i] = OreDictionary.getOreName((int)ores[i]);
            FMLLog.info((String)(stack.func_82833_r() + ": " + oreS[i]), (Object[])new Object[0]);
        }
        return oreS;
    }

    public static ItemStack copyItemStack(ItemStack stack, int stacksize) {
        if (stack != null) {
            ItemStack ret = stack.func_77946_l();
            ret.field_77994_a = stacksize;
            return ret;
        }
        return null;
    }

    public static NBTTagCompound writeStacksToNBT(NBTTagCompound nbt, ItemStack ... stacks) {
        nbt.func_74768_a("stack_length", stacks.length);
        for (int i = 0; i < stacks.length; ++i) {
            NBTTagCompound nbt_ = nbt.func_74775_l("slot_" + i);
            if (stacks[i] != null) {
                stacks[i].func_77955_b(nbt_);
            } else {
                nbt_.func_74757_a("isEmpty", true);
            }
            nbt.func_74782_a("slot_" + i, (NBTBase)nbt_);
        }
        return nbt;
    }

    public static ItemStack[] readStacksFromNBT(NBTTagCompound nbt) {
        ItemStack[] stacks = new ItemStack[nbt.func_74762_e("stack_length")];
        for (int i = 0; i < stacks.length; ++i) {
            NBTTagCompound slot = nbt.func_74775_l("slot_" + i);
            stacks[i] = slot.func_74767_n("isEmpty") ? null : ItemStack.func_77949_a((NBTTagCompound)slot);
        }
        return stacks;
    }

    public static NBTTagCompound writeTankToNBT(NBTTagCompound nbt, FluidTank tank) {
        try {
            tank.writeToNBT(nbt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nbt;
    }
}

