/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.common.tileent;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import mrdimka.common.utils.CommonTileEntity;
import mrdimka.craft.conveyor.common.blocks.fluids.BlockFluidGasoline;
import mrdimka.craft.conveyor.common.blocks.fluids.BlockFluidOil;
import mrdimka.craft.conveyor.network.PacketManager;
import mrdimka.craft.conveyor.network.packets.PacketRefinery;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRefinery
extends CommonTileEntity
implements IFluidHandler,
IEnergyHandler {
    public final EnergyStorage Capacitor = new EnergyStorage(1000, 200, 0);
    public FluidTank tank1 = new FluidTank(BlockFluidOil.oil, 0, 10000);
    public FluidTank tank2 = new FluidTank(BlockFluidGasoline.gasoline, 0, 10000);
    private static FluidStack addGasoline = new FluidStack(BlockFluidGasoline.gasoline, 1);
    public int lastTank1Amt = 0;
    public int lastTank2Amt = 0;
    public int hasChangedTimer = 0;
    public boolean hasChanged = false;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank1.getFluid() == null) {
            this.tank1.setFluid(new FluidStack(BlockFluidOil.oil, 0));
            this.hasChanged = true;
        }
        if (this.tank2.getFluid() == null) {
            this.tank2.setFluid(new FluidStack(BlockFluidGasoline.gasoline, 0));
            this.hasChanged = true;
        }
        if (this.tank1.getFluid().getFluid() == BlockFluidOil.oil && this.tank1.getFluidAmount() >= 2 && this.tank2.getCapacity() - 1 > this.tank2.getFluidAmount() && this.Capacitor.getEnergyStored() >= 40) {
            this.Capacitor.setEnergyStored(this.Capacitor.getEnergyStored() - 40);
            this.tank1.drain(2, true);
            this.tank2.fill(addGasoline, true);
        }
        if (this.tank1.getFluidAmount() != this.lastTank1Amt || this.tank2.getFluidAmount() != this.lastTank2Amt) {
            this.hasChanged = true;
        }
        if (this.hasChanged && this.hasChangedTimer++ >= 20) {
            this.hasChangedTimer = 0;
            this.hasChanged = false;
            PacketManager.misc_line.sendToDimension((IMessage)new PacketRefinery().setData(this), this.field_145850_b.field_73011_w.field_76574_g);
        }
        this.lastTank1Amt = this.tank1.getFluidAmount();
        this.lastTank2Amt = this.tank2.getFluidAmount();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.tank1.readFromNBT(nbt.func_74775_l("Oil"));
        this.tank2.readFromNBT(nbt.func_74775_l("Gasoline"));
        this.Capacitor.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagCompound oil = new NBTTagCompound();
        NBTTagCompound gasoline = new NBTTagCompound();
        this.tank1.writeToNBT(oil);
        this.tank2.writeToNBT(gasoline);
        this.Capacitor.writeToNBT(nbt);
        nbt.func_74782_a("Oil", (NBTBase)oil);
        nbt.func_74782_a("Gasoline", (NBTBase)gasoline);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank1.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource != null ? this.tank2.drain(resource.amount, doDrain) : new FluidStack(BlockFluidGasoline.gasoline, 0);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank2.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank1.getInfo(), this.tank2.getInfo()};
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.Capacitor.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.Capacitor.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.Capacitor.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.Capacitor.getMaxEnergyStored();
    }
}

