/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.common.tileent;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mrdimka.common.utils.BlockPos;
import mrdimka.common.utils.CommonTileEntity;
import mrdimka.craft.conveyor.common.utils.Util;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePump
extends CommonTileEntity
implements IEnergyHandler,
IFluidHandler {
    public final FluidTank reservoir = new FluidTank(2000);
    public final EnergyStorage storage = new EnergyStorage(8000, 200, 8000);
    public final ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
    public Map<Integer, Set<BlockPos>> scanned = new HashMap<Integer, Set<BlockPos>>();
    public float pipe = 0.0f;
    public int cooldown = 0;
    public int yLevel = -1;
    private int x;
    private int y;
    private int z;
    private ForgeDirection blk = ForgeDirection.UP;

    public void func_145845_h() {
        if (this.yLevel <= 0) {
            this.yLevel = this.field_145848_d - 1;
        }
        if (this.scanned.get(this.yLevel) == null) {
            this.scanned.put(this.yLevel, new HashSet());
        }
        if (this.yLevel > 0) {
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            Set<BlockPos> scan = this.scanned.get(this.yLevel);
            if (scan.size() >= 10000) {
                --this.yLevel;
                return;
            }
            for (ForgeDirection f : this.directions) {
                if (this.storage.getEnergyStored() <= 50) break;
                int x = this.x + f.offsetX;
                int y = this.y + f.offsetY;
                int z = this.z + f.offsetZ;
                if (scan.contains(BlockPos.getBlockPos(this.field_145850_b, x, y, z))) continue;
                if (this.field_145850_b.func_147439_a(x, y, z) instanceof BlockFluidBase && this.field_145850_b.func_72805_g(x, y, z) == 0) {
                    int fill = this.reservoir.fill(new FluidStack(((BlockFluidBase)this.field_145850_b.func_147439_a(x, y, z)).getFluid(), 1000), false);
                    if (fill < 1000) continue;
                    this.reservoir.fill(new FluidStack(((BlockFluidBase)this.field_145850_b.func_147439_a(x, y, z)).getFluid(), 1000), true);
                    this.field_145850_b.func_147468_f(x, y, z);
                    this.cooldown = 40;
                    this.x = x;
                    this.y = y;
                    this.z = z;
                    scan.add(BlockPos.getBlockPos(this.field_145850_b, x, y, z));
                    this.storage.extractEnergy(50, false);
                    break;
                }
                if (this.field_145850_b.func_147439_a(x, y, z) instanceof BlockLiquid && this.field_145850_b.func_72805_g(x, y, z) == 0) {
                    Fluid liquid = this.field_145850_b.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h ? FluidRegistry.WATER : (this.field_145850_b.func_147439_a(x, y, z).func_149688_o() == Material.field_151587_i ? FluidRegistry.LAVA : FluidRegistry.WATER);
                    int fill = this.reservoir.fill(new FluidStack(liquid, 1000), false);
                    if (fill < 1000) continue;
                    this.reservoir.fill(new FluidStack(liquid, 1000), true);
                    this.field_145850_b.func_147468_f(x, y, z);
                    this.cooldown = 40;
                    this.x = x;
                    this.y = y;
                    this.z = z;
                    scan.add(BlockPos.getBlockPos(this.field_145850_b, x, y, z));
                    this.storage.extractEnergy(50, false);
                    break;
                }
                scan.add(BlockPos.getBlockPos(this.field_145850_b, x, y, z));
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource != null && resource.isFluidEqual(this.reservoir.getFluid()) ? this.reservoir.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.reservoir.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ForgeDirection.getOrientation((int)this.field_145847_g).getOpposite() == from;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.reservoir.getInfo()};
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.DOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.storage.readFromNBT(nbt);
        this.reservoir.readFromNBT(nbt.func_74775_l("tank"));
        this.field_145847_g = nbt.func_74762_e("facing");
        this.pipe = nbt.func_74760_g("pipeLength");
        this.cooldown = nbt.func_74762_e("cooldown");
        this.yLevel = nbt.func_74762_e("yLevel");
        NBTTagCompound last = nbt.func_74775_l("lastPosition");
        this.x = last.func_74762_e("x");
        this.y = last.func_74762_e("y");
        this.z = last.func_74762_e("z");
        this.blk = ForgeDirection.getOrientation((int)last.func_74762_e("b"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        this.storage.writeToNBT(nbt);
        nbt.func_74782_a("tank", (NBTBase)Util.writeTankToNBT(new NBTTagCompound(), this.reservoir));
        nbt.func_74768_a("facing", this.field_145847_g);
        nbt.func_74776_a("pipeLength", this.pipe);
        nbt.func_74768_a("cooldown", this.cooldown);
        nbt.func_74768_a("yLevel", this.yLevel);
        NBTTagCompound last = new NBTTagCompound();
        last.func_74768_a("x", this.x);
        last.func_74768_a("y", this.y);
        last.func_74768_a("z", this.z);
        last.func_74768_a("b", this.blk.ordinal());
        nbt.func_74782_a("lastPosition", (NBTBase)last);
    }
}

