/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.common.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import mrdimka.craft.conveyor.codechicken.lib.raytracer.RayTracer;
import mrdimka.craft.conveyor.common.blocks.fluids.BlockFluidOil;
import mrdimka.craft.conveyor.common.init.ModAchievements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.world.BlockEvent;

public class AchievementEvents {
    @SubscribeEvent
    public void onPickup(PlayerEvent.ItemPickupEvent e) {
        ItemStack i = e.pickedUp != null ? e.pickedUp.func_92059_d() : null;
        AchievementEvents.invoke(EnumAchievement.PICKING, i, e.player);
    }

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent e) {
        ItemStack i = e.crafting;
        AchievementEvents.invoke(EnumAchievement.CRAFTING, i, e.player);
    }

    @SubscribeEvent
    public void onSmelt(PlayerEvent.ItemSmeltedEvent e) {
        ItemStack i = e.smelting;
        AchievementEvents.invoke(EnumAchievement.SMELTING, i, e.player);
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent e) {
        ItemStack i = new ItemStack(e.block, e.blockMetadata);
        AchievementEvents.invoke(EnumAchievement.BREAKING, i, e.getPlayer());
    }

    @SubscribeEvent
    public void handleLooking(TickEvent.PlayerTickEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        MovingObjectPosition t = RayTracer.reTrace(e.player, 32.0);
        if (e != null && e.player != null && e.player.field_70170_p != null && e.player.field_70170_p.func_147439_a(t.field_72311_b, t.field_72312_c, t.field_72309_d) instanceof BlockFluidOil) {
            ModAchievements.triggerAchievement(e.player, "oil");
        }
    }

    private static void invoke(EnumAchievement type, ItemStack stack, EntityPlayer playerTrigger) {
        String achievement = "";
        if (playerTrigger instanceof EntityPlayerMP) {
            try {
                Achievement c = ModAchievements.mapping.get(ModAchievements.getter.get((Object)type).get(stack != null ? stack.func_77973_b() : null).get(stack != null ? stack.func_77960_j() : 0));
                if (!((EntityPlayerMP)playerTrigger).func_147099_x().func_77443_a(c)) {
                    playerTrigger.func_71064_a((StatBase)c, 1);
                }
            }
            catch (Throwable err) {
                // empty catch block
            }
        }
    }

    public static enum EnumAchievement {
        CRAFTING,
        SMELTING,
        PICKING,
        BREAKING,
        CUSTOM,
        LOOKING;

    }
}

