/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.api.events.platform;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import mrdimka.craft.conveyor.api.events.platform.BusLogger;
import mrdimka.craft.conveyor.api.events.platform.EventBase;
import mrdimka.craft.conveyor.api.events.platform.EventReceiver;
import org.apache.logging.log4j.Level;

public class DeliveryBus {
    private static final Set<DeliveryBus> busses = new HashSet<DeliveryBus>();
    public final String name;
    public final Set<Object> targetObjects = new HashSet<Object>();
    public final BusLogger log;

    public DeliveryBus(String busName) {
        Stopwatch timer = Stopwatch.createStarted();
        this.name = busName;
        busses.add(this);
        this.log = new BusLogger("DeliveryBus#'" + this.name + "'");
        System.gc();
        this.log.error("Delivery bus loaded in %s ms.", timer.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public boolean register(Object obj) {
        return this.targetObjects.add(obj);
    }

    public void deliver(EventBase event) {
        for (Object o : this.targetObjects.toArray(new Object[0])) {
            Method[] ms;
            for (Method m : ms = o.getClass().getMethods()) {
                m.setAccessible(true);
                Class<?>[] params = m.getParameterTypes();
                if (params.length != 1 || !event.getClass().isAssignableFrom(params[0]) || m.getAnnotation(EventReceiver.class) == null) continue;
                try {
                    m.invoke(o, event);
                }
                catch (Throwable err) {
                    FMLLog.log((String)("DeliveryBus#" + this.name + "'"), (Level)Level.ERROR, (String)("En error ocurred, while processing method " + o.getClass().getName() + "." + m.getName() + "(" + event.getClass().getName() + ");"), (Object[])new Object[0]);
                    err.printStackTrace();
                }
            }
        }
    }
}

