/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.api.events.platform;

import cpw.mods.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class BusLogger {
    public final String logName;

    public BusLogger(String name) {
        this.logName = name;
    }

    public void log(Level level, String format, Object ... data) {
        FMLLog.log((String)this.logName, (Level)level, (String)format, (Object[])data);
    }

    public void error(String format, Object ... data) {
        this.log(Level.ERROR, format, data);
    }

    public void bigWarning(String format, Object ... data) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        this.log(Level.WARN, "****************************************", new Object[0]);
        this.log(Level.WARN, "* " + format, data);
        for (int i = 2; i < 8 && i < trace.length; ++i) {
            this.log(Level.WARN, "*  at %s%s", trace[i].toString(), i == 7 ? "..." : "");
        }
        this.log(Level.WARN, "****************************************", new Object[0]);
    }

    public void warning(String format, Object ... data) {
        this.log(Level.WARN, format, data);
    }

    public void info(String format, Object ... data) {
        this.log(Level.INFO, format, data);
    }

    public void fine(String format, Object ... data) {
        this.log(Level.DEBUG, format, data);
    }

    public void finer(String format, Object ... data) {
        this.log(Level.TRACE, format, data);
    }
}

