/*
 * Decompiled with CFR 0.152.
 */
package mrdimka.craft.conveyor.api.blocks;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mrdimka.craft.conveyor.api.ConvCraftPrefs;
import mrdimka.craft.conveyor.api.IAbstractSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class MetalSet
implements IAbstractSet {
    public static final Set<MetalSet> sets = new SpecialSet<MetalSet>();
    public final String modid;
    public final String metal_name;
    public final Item ingot;
    public final Item nugget;
    public final Block ore;
    public final Block block;
    public final Block oreTargetingBlock;
    public final Block musthaveBlockAround;
    public final int oreRarity;
    public final int oreMinY;
    public final int oreMaxY;
    public final int maxClusterSize;
    public final CreativeTabs tab;
    public int musthaveBlockRadius = 3;

    public MetalSet setMusthaveBlockRad(int rad) {
        this.musthaveBlockRadius = rad;
        return this;
    }

    public MetalSet(String modid, String metal, boolean defaultIngotFromOreRecipe, CreativeTabs tab, Block oreTargetingBlock, Block musthaveBlockAround, int oreRarityIn10000, int oreMinY, int oreMaxY, int maxClusterSize) {
        this.modid = modid;
        this.metal_name = metal;
        this.oreRarity = oreRarityIn10000;
        this.oreMaxY = oreMaxY;
        this.oreMinY = oreMinY;
        this.maxClusterSize = maxClusterSize;
        this.oreTargetingBlock = oreTargetingBlock;
        this.musthaveBlockAround = musthaveBlockAround;
        this.tab = tab;
        if (!modid.equalsIgnoreCase(Loader.instance().activeModContainer().getModId())) {
            FMLLog.log((String)ConvCraftPrefs.getName(), (Level)Level.ERROR, (String)(Loader.instance().activeModContainer().getName() + " tried to register MetalSet with fake modid '" + modid + "'. Changing it to '" + Loader.instance().activeModContainer().getModId() + "'"), (Object[])new Object[0]);
            modid = Loader.instance().activeModContainer().getModId();
        }
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            this.ingot = null;
            this.nugget = null;
            this.ore = null;
            this.block = null;
            FMLLog.log((String)ConvCraftPrefs.getName(), (Level)Level.ERROR, (String)(Loader.instance().activeModContainer().getName() + " tried to register MetalSet in the " + Loader.instance().getLoaderState().name() + " loading stage."), (Object[])new Object[0]);
            return;
        }
        String casedMetal = metal.toLowerCase();
        char caseM = casedMetal.charAt(0);
        casedMetal = (caseM + "").toUpperCase() + casedMetal.substring(1);
        this.ingot = new Item().func_77655_b(modid + ":ingot_" + metal).func_111206_d(modid + ":ingot_" + metal);
        this.nugget = new Item().func_77655_b(modid + ":nugget_" + metal).func_111206_d(modid + ":nugget_" + metal);
        this.ore = new Block(Material.field_151576_e){}.func_149663_c(modid + ":ore_" + metal).func_149658_d(modid + ":ore_" + metal).func_149711_c(1.0f);
        this.block = new Block(Material.field_151573_f){}.func_149663_c(modid + ":block_" + metal).func_149658_d(modid + ":block_" + metal).func_149672_a(Block.field_149777_j).func_149711_c(2.0f);
        GameRegistry.registerBlock((Block)this.ore, (String)("ore_" + metal));
        GameRegistry.registerBlock((Block)this.block, (String)("block_" + metal));
        GameRegistry.registerItem((Item)this.ingot, (String)("ingot_" + metal));
        GameRegistry.registerItem((Item)this.nugget, (String)("nugget_" + metal));
        if (tab != null) {
            this.ore.func_149647_a(tab);
            this.block.func_149647_a(tab);
            this.ingot.func_77637_a(tab);
            this.nugget.func_77637_a(tab);
        }
        OreDictionary.registerOre((String)("ore" + casedMetal), (Block)this.ore);
        OreDictionary.registerOre((String)("block" + casedMetal), (Block)this.block);
        OreDictionary.registerOre((String)("ingot" + casedMetal), (Item)this.ingot);
        OreDictionary.registerOre((String)("nugget" + casedMetal), (Item)this.nugget);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(this.ingot, (Object[])this.repeat("nugget" + casedMetal, 9)));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(this.nugget, 9), new Object[]{"ingot" + casedMetal}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(this.block, (Object[])this.repeat("ingot" + casedMetal, 9)));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(this.ingot, 9), new Object[]{"block" + casedMetal}));
        if (defaultIngotFromOreRecipe) {
            GameRegistry.addSmelting((Block)this.ore, (ItemStack)new ItemStack(this.ingot), (float)((float)casedMetal.length() / 4.0f));
        }
        SpecialSet sp = (SpecialSet)sets;
        sp.setState(1);
        sp.add(this);
        sp.setState(2);
        FMLLog.log((String)ConvCraftPrefs.getName(), (Level)Level.INFO, (String)(Loader.instance().activeModContainer().getName() + " registered a MetalSet with metal name '" + casedMetal + "'"), (Object[])new Object[0]);
    }

    public MetalSet(String modid, String metal, boolean defaultIngotFromOreRecipe, Block oreTargetingBlock, Block musthaveBlockAround, int oreRarityIn10000, int oreMinY, int oreMaxY, int maxClusterSize) {
        this(modid, metal, defaultIngotFromOreRecipe, null, oreTargetingBlock, musthaveBlockAround, oreRarityIn10000, oreMinY, oreMaxY, maxClusterSize);
    }

    private <T> T[] repeat(T o, int times) {
        Object[] os = new Object[times];
        for (int i = 0; i < times; ++i) {
            os[i] = o;
        }
        return os;
    }

    private static class SpecialSet<E>
    extends HashSet<E> {
        private int state = 0;
        private static final int AVALIABLE = 1;
        private static final int UNAVALIABLE = 2;

        private SpecialSet() {
        }

        private void setState(int state) {
            this.state = state;
        }

        @Override
        public void clear() {
            if (this.state == 1) {
                super.clear();
            }
        }

        @Override
        public boolean add(E e) {
            return this.state == 1 ? super.add(e) : false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.state == 1 ? super.addAll(c) : false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public Object clone() {
            SpecialSet<E> cp = new SpecialSet<E>();
            super.setState(1);
            cp.addAll(this);
            super.setState(this.state);
            return cp;
        }
    }
}

