/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.steam;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;
import powercrystals.powerconverters.power.systems.PowerSteam;

@Optional.Interface(modid="BuildCraft|Core", iface="buildcraft.api.transport.IPipeConnection")
public class TileEntitySteamConsumer
extends TileEntityEnergyConsumer<IFluidHandler>
implements IFluidHandler,
IPipeConnection {
    private FluidTank _steamTank = new FluidTank(1000);
    private int _mBLastTick;
    PowerSteam powerSteam = (PowerSteam)PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id);
    private int lastSubtype = -1;

    public TileEntitySteamConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id), 0, IFluidHandler.class);
    }

    @Override
    public void func_145845_h() {
        boolean powered;
        super.func_145845_h();
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (!powered && this._steamTank.getFluid() != null && this._steamTank.getFluid().getFluid() != null && this._steamTank.getFluid().getFluid().getName() != null) {
            String fluidName = this._steamTank.getFluid().getFluid().getName();
            PowerSteam.SteamType steamType = this.powerSteam.getSteamType(fluidName);
            if (steamType != null && this._steamTank.getFluidAmount() > 0) {
                float energyLeft;
                this.lastSubtype = this.powerSteam.getSteamSubtype(steamType);
                int amount = Math.min(this._steamTank.getFluidAmount(), this.powerSteam.getThrottleConsumer());
                float energy = (float)amount * steamType.energyPerInput;
                float energyUsed = energy - (energyLeft = (float)((int)this.storeEnergy(energy, false)));
                if (energyUsed > 0.0f) {
                    int toDrain;
                    try {
                        toDrain = (int)(energyUsed / this.powerSteam.getInternalEnergyPerInput(this.field_145847_g));
                    }
                    catch (ArithmeticException e) {
                        toDrain = 0;
                    }
                    this._steamTank.drain(toDrain, true);
                    this._mBLastTick = toDrain - this._steamTank.getFluidAmount();
                } else {
                    this._mBLastTick = 0;
                }
            } else {
                this._mBLastTick = 0;
            }
        } else {
            this._mBLastTick = 0;
        }
    }

    @Override
    public int getVoltageIndex() {
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        PowerSteam.SteamType type;
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        if (this._steamTank.getFluid() == null ? (type = this.powerSteam.getSteamType(resource.getFluid().getName())) != null : this._steamTank.getFluid().getFluid().getName().equals(resource.getFluid().getName())) {
            return this._steamTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this._steamTank.getInfo()};
    }

    @Override
    public double getInputRate() {
        return this._mBLastTick;
    }

    @Override
    public int getSubtype() {
        return this.lastSubtype;
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        if (pipeType == IPipeTile.PipeType.FLUID) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

