/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.fortron;

import java.util.Map;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;
import resonant.api.mffs.fortron.IFortronStorage;

public class TileEntityFortronConsumer
extends TileEntityEnergyConsumer<IFortronStorage> {
    private int lastReceivedFortron;

    public TileEntityFortronConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("Fortron"), 0, IFortronStorage.class);
    }

    @Override
    public void func_145845_h() {
        boolean powered;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (powered) {
            return;
        }
        double perInput = this.getPowerSystem().getInternalEnergyPerInput(0);
        int demand = this.getTotalEnergyDemand();
        if ((double)demand / perInput < 1.0) {
            return;
        }
        int totalFortronDemand = (int)Math.floor((double)demand / perInput);
        for (Map.Entry it : this.getTiles().entrySet()) {
            IFortronStorage fs = (IFortronStorage)it.getValue();
            int fortronReceived = fs.requestFortron(totalFortronDemand, true);
            this.storeEnergy((double)fortronReceived * perInput, false);
            this.lastReceivedFortron += fortronReceived;
            if ((totalFortronDemand -= fortronReceived) > 0) continue;
            break;
        }
    }

    @Override
    public double getInputRate() {
        int last = this.lastReceivedFortron;
        this.lastReceivedFortron = 0;
        return last;
    }
}

