/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.base.BlockPowerConverter;
import powercrystals.powerconverters.power.systems.gt5.BlockGregTechConsumer;
import powercrystals.powerconverters.power.systems.gt5.BlockGregTechProducer;
import powercrystals.powerconverters.power.systems.gt5.ItemBlockGregTechConsumer;
import powercrystals.powerconverters.power.systems.gt5.ItemBlockGregTechProducer;
import powercrystals.powerconverters.power.systems.gt5.TileEntityGregTechConsumer;
import powercrystals.powerconverters.power.systems.gt5.TileEntityGregTechProducer;

public class PowerGregTech5
extends PowerSystem {
    public static final String id = "GT";
    public static final float DEFAULT_ENERGY_PER_INPUT = 4000.0f;
    public static final float DEFAULT_ENERGY_PER_OUTPUT = 4000.0f;
    public static final String CATEGORY_FACTORIZATION = "powersystems.gt";
    public static final String[] VOLTAGE_NAMES = new String[]{"ULV", "LV", "MV", "HV", "EV", "IV", "LuV", "ZPMV", "UV"};
    public static final int[] VOLTAGE_VALUES = new int[]{8, 32, 128, 512, 2048, 8192, 32768, 131072, 524288};
    public BlockPowerConverter blockProducer;
    public BlockPowerConverter blockConsumer;
    public Class<? extends ItemBlock> itemBlockProducer;
    public Class<? extends ItemBlock> itemBlockConsumer;

    public PowerGregTech5() {
        this.name = "GregTech";
        this._internalEnergyPerInput = 4000.0f;
        this._internalEnergyPerOutput = 4000.0f;
        this._unit = "EU";
        this.voltageNames = VOLTAGE_NAMES;
        this.voltageValues = VOLTAGE_VALUES;
        this.blockConsumer = new BlockGregTechConsumer();
        this.blockProducer = new BlockGregTechProducer();
        this.itemBlockConsumer = ItemBlockGregTechConsumer.class;
        this.itemBlockProducer = ItemBlockGregTechProducer.class;
        this.block = this.blockConsumer;
        this.itemBlock = this.itemBlockConsumer;
        this.consumer = TileEntityGregTechConsumer.class;
        this.producer = TileEntityGregTechProducer.class;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.blockConsumer, this.itemBlockConsumer, (String)"converter.gt.consumer");
        GameRegistry.registerBlock((Block)this.blockProducer, this.itemBlockProducer, (String)"converter.gt.producer");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterGTConsumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterGTProducer");
    }

    @Override
    public void registerCommonRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 0), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 1), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 2), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 2), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 3), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 3), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 4), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 4), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 5), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 5)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 5), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 5)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 6), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 6)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 6), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 6)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 7), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 7)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 7), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 7)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockConsumer, 1, 8), (Object[])new Object[]{new ItemStack((Block)this.blockProducer, 1, 8)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockProducer, 1, 8), (Object[])new Object[]{new ItemStack((Block)this.blockConsumer, 1, 8)});
    }

    @Override
    public void loadConfig(Configuration c) {
        this._internalEnergyPerInput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerInput", 4000.0).getDouble(4000.0);
        this._internalEnergyPerOutput = (float)c.get(CATEGORY_FACTORIZATION, "internalEnergyPerOutput", 4000.0).getDouble(4000.0);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerInput").set((double)this._internalEnergyPerInput);
        c.getCategory(CATEGORY_FACTORIZATION).get("internalEnergyPerOutput").set((double)this._internalEnergyPerOutput);
    }

    @Override
    public String getRateString(BridgeSideData data) {
        long EUt = VOLTAGE_VALUES[data.voltageNameIndex];
        long AMP = (long)Math.ceil(data.outputRate / (double)EUt);
        return AMP + " A";
    }
}

