/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.power.PowerSystem;

public class PowerSystemManager {
    private static PowerSystemManager instance;
    private Map<String, PowerSystem> powerSystems = new HashMap<String, PowerSystem>();
    private List<String> systemIds = new ArrayList<String>();
    private List<String> serverSystemIds = new ArrayList<String>();

    public static PowerSystemManager getInstance() {
        if (instance == null) {
            instance = new PowerSystemManager();
        }
        return instance;
    }

    public void setServerSystemIds() {
        this.serverSystemIds = this.systemIds;
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.readEnergyValues(powerSystem.writeEnergyValues());
        }
    }

    public void setServerSystemIds(ArrayList<String> ids) {
        this.serverSystemIds = ids;
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.readEnergyValues(powerSystem.writeEnergyValues());
        }
    }

    public void readPowerData(NBTTagCompound nbt) {
        this.serverSystemIds.clear();
        NBTTagList ids = nbt.func_150295_c("systemIds", 8);
        for (int i = 0; i < ids.func_74745_c(); ++i) {
            this.serverSystemIds.add(ids.func_150307_f(i));
        }
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            NBTTagCompound powerSystemNBT = nbt.func_74775_l(powerSystem.getId());
            powerSystem.readEnergyValues(powerSystemNBT);
        }
    }

    public NBTTagCompound writePowerData() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList ids = new NBTTagList();
        for (String systemId : this.systemIds) {
            ids.func_74742_a((NBTBase)new NBTTagString(systemId));
        }
        nbt.func_74782_a("systemIds", (NBTBase)ids);
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            nbt.func_74782_a(powerSystem.getId(), (NBTBase)powerSystem.writeEnergyValues());
        }
        return nbt;
    }

    public void registerPowerSystem(PowerSystem powerSystem) {
        this.registerPowerSystem(powerSystem.getId(), powerSystem);
        this.systemIds.add(powerSystem.getId());
    }

    public void registerPowerSystem(String id, PowerSystem powerSystem) {
        this.powerSystems.put(id, powerSystem);
    }

    public PowerSystem getPowerSystemByName(String name) {
        return this.powerSystems.containsKey(name) ? this.powerSystems.get(name) : null;
    }

    public int getPowerSystemId(String name) {
        return this.serverSystemIds.lastIndexOf(name);
    }

    public PowerSystem getPowerSystemById(int id) {
        String name = this.serverSystemIds.get(id);
        return this.getPowerSystemByName(name);
    }

    public void registerBlocks() {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.registerBlocks();
        }
    }

    public void registerCommonRecipes() {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.registerCommonRecipes();
        }
    }

    public void loadConfigs(Configuration c) {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.loadConfig(c);
        }
    }

    public void saveConfigs(Configuration c) {
        for (PowerSystem powerSystem : this.powerSystems.values()) {
            powerSystem.saveConfig(c);
        }
    }
}

